/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.gpio.impl;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.RegistryData;
import java.io.IOException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;

public final class GPIOPinRegistryFactory
extends DeviceRegistryFactory {
    private static final String PIN_NUMBER = "pinNumber";
    private static final String MODE = "mode";
    private static final String TRIGGER = "trigger";
    private static final String TYPE_VALUE = "gpio.GPIOPin";

    @Override
    public DeviceDescriptor<GPIOPin> createDeviceDescriptor(int n, RegistryData registryData) throws IOException {
        String string = registryData.getCharacterProperty("name");
        GPIOPinConfig gPIOPinConfig = GPIOPinRegistryFactory.createConfig(registryData);
        String[] stringArray = super.getProperties(registryData);
        return new PeripheralDescriptorImpl<GPIOPin>(n, string, gPIOPinConfig, GPIOPin.class, stringArray);
    }

    @Override
    public RegistryData createRegistryData(DeviceDescriptor deviceDescriptor) {
        GPIOPinConfig gPIOPinConfig = (GPIOPinConfig)deviceDescriptor.getConfiguration();
        String string = deviceDescriptor.getName();
        RegistryData registryData = GPIOPinRegistryFactory.createData(gPIOPinConfig);
        registryData.putCharacterProperty("deviceType", TYPE_VALUE);
        if (string != null) {
            registryData.putCharacterProperty("name", string);
        }
        super.putProperties(registryData, deviceDescriptor.getProperties());
        return registryData;
    }

    static GPIOPinConfig createConfig(RegistryData registryData) {
        GPIOPinConfig gPIOPinConfig;
        String string = registryData.getCharacterProperty("controllerName");
        int n = registryData.getIntegerProperty(PIN_NUMBER, -1);
        int n2 = registryData.getIntegerProperty("direction", 0);
        int n3 = registryData.getIntegerProperty(MODE, -1);
        int n4 = registryData.getIntegerProperty(TRIGGER, 0);
        boolean bl = registryData.getBooleanProperty("initValue", false);
        if (null == string) {
            int n5 = registryData.getIntegerProperty("controllerNumber", -1);
            gPIOPinConfig = new GPIOPinConfig(n5, n, n2, n3, n4, bl);
        } else {
            gPIOPinConfig = new GPIOPinConfig(string, n, n2, n3, n4, bl);
        }
        return gPIOPinConfig;
    }

    static RegistryData createData(GPIOPinConfig gPIOPinConfig) {
        int n;
        int n2;
        int n3;
        RegistryData registryData = new RegistryData();
        String string = gPIOPinConfig.getControllerName();
        if (string != null) {
            registryData.putCharacterProperty("controllerName", string);
        }
        if ((n3 = gPIOPinConfig.getControllerNumber()) != -1) {
            registryData.putIntegerProperty("controllerNumber", n3);
        }
        if ((n2 = gPIOPinConfig.getPinNumber()) != -1) {
            registryData.putIntegerProperty(PIN_NUMBER, n2);
        }
        if ((n = gPIOPinConfig.getDriveMode()) != -1) {
            registryData.putIntegerProperty(MODE, n);
        }
        registryData.putIntegerProperty("direction", gPIOPinConfig.getDirection());
        registryData.putIntegerProperty(TRIGGER, gPIOPinConfig.getTrigger());
        registryData.putBooleanProperty("initValue", gPIOPinConfig.getInitValue());
        return registryData;
    }
}

