/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.i2cbus.impl;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.RegistryData;
import java.io.IOException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.i2cbus.I2CDevice;
import jdk.dio.i2cbus.I2CDeviceConfig;

public final class I2CDeviceRegistryFactory
extends DeviceRegistryFactory {
    private static final String ADDRESS = "address";
    private static final String ADDRESS_SIZE = "addressSize";
    private static final String CLOCK_FREQUENCY = "clockFrequency";
    private static final String TYPE_VALUE = "i2cbus.I2CDevice";

    @Override
    public DeviceDescriptor<I2CDevice> createDeviceDescriptor(int n, RegistryData registryData) throws IOException {
        I2CDeviceConfig i2CDeviceConfig;
        String string = registryData.getCharacterProperty("name");
        String string2 = registryData.getCharacterProperty("controllerName");
        int n2 = registryData.getIntegerProperty(ADDRESS, -1);
        int n3 = registryData.getIntegerProperty(ADDRESS_SIZE, -1);
        int n4 = registryData.getIntegerProperty(CLOCK_FREQUENCY, -1);
        if (null == string2) {
            int n5 = registryData.getIntegerProperty("controllerNumber", -1);
            i2CDeviceConfig = new I2CDeviceConfig(n5, n2, n3, n4);
        } else {
            i2CDeviceConfig = new I2CDeviceConfig(string2, n2, n3, n4);
        }
        String[] stringArray = super.getProperties(registryData);
        return new PeripheralDescriptorImpl<I2CDevice>(n, string, i2CDeviceConfig, I2CDevice.class, stringArray);
    }

    @Override
    public RegistryData createRegistryData(DeviceDescriptor deviceDescriptor) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        I2CDeviceConfig i2CDeviceConfig = (I2CDeviceConfig)deviceDescriptor.getConfiguration();
        String string2 = deviceDescriptor.getName();
        RegistryData registryData = new RegistryData();
        registryData.putCharacterProperty("deviceType", TYPE_VALUE);
        if (string2 != null) {
            registryData.putCharacterProperty("name", string2);
        }
        if ((string = i2CDeviceConfig.getControllerName()) != null) {
            registryData.putCharacterProperty("controllerName", string);
        }
        if ((n4 = i2CDeviceConfig.getControllerNumber()) != -1) {
            registryData.putIntegerProperty("controllerNumber", n4);
        }
        if ((n3 = i2CDeviceConfig.getAddress()) != -1) {
            registryData.putIntegerProperty(ADDRESS, n3);
        }
        if ((n2 = i2CDeviceConfig.getAddressSize()) != -1) {
            registryData.putIntegerProperty(ADDRESS_SIZE, n2);
        }
        if ((n = i2CDeviceConfig.getClockFrequency()) != -1) {
            registryData.putIntegerProperty(CLOCK_FREQUENCY, n);
        }
        super.putProperties(registryData, deviceDescriptor.getProperties());
        return registryData;
    }
}

