/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.impl;

import com.oracle.dio.impl.Handle;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.dio.ClosedDeviceException;
import jdk.dio.Device;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceEvent;
import jdk.dio.UnavailableDeviceException;

public abstract class AbstractPeripheral<P extends Device<P>>
implements Device<P> {
    protected DeviceDescriptor<P> dscr;
    protected Handle handle;
    protected int access;
    protected boolean busyFlag;
    private boolean locked;

    protected AbstractPeripheral(DeviceDescriptor<P> deviceDescriptor, int n) {
        this.dscr = deviceDescriptor;
        this.access = n;
        this.handle = new Handle();
        this.busyFlag = false;
    }

    @Override
    public void tryLock(int n) throws UnavailableDeviceException, ClosedDeviceException, IOException {
        this.checkOpen();
        if (2 == this.access) {
            this.locked = true;
            if (!this.tryLock0(n)) {
                this.locked = false;
                throw new UnavailableDeviceException(ExceptionMessage.format(0, new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() throws IOException {
        Handle handle = this.handle;
        synchronized (handle) {
            this.unlock0();
        }
    }

    protected void conditionalLock() throws UnavailableDeviceException {
        if (!this.tryLock0(1)) {
            throw new UnavailableDeviceException(ExceptionMessage.format(0, new Object[0]));
        }
    }

    protected void conditionalUnlock() {
        if (!this.locked) {
            this.unlock0();
        }
    }

    @Override
    public void close() throws IOException {
        this.handle.close();
    }

    @Override
    public boolean isOpen() {
        return this.handle.isOpen();
    }

    @Override
    public DeviceDescriptor<P> getDescriptor() {
        return this.dscr;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    protected void checkOpen() throws ClosedDeviceException {
        if (!this.handle.isOpen()) {
            throw new ClosedDeviceException();
        }
    }

    protected void setBusyFlag(boolean bl, int n) throws IllegalArgumentException {
        if (this.busyFlag && bl) {
            throw new IllegalStateException(ExceptionMessage.format(n, new Object[0]));
        }
        this.busyFlag = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shiftBufferPosition(Buffer buffer, int n) {
        Buffer buffer2 = buffer;
        synchronized (buffer2) {
            if (n > buffer.position()) {
                try {
                    int n2 = buffer.limit();
                    buffer.position(n > n2 ? n2 : n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.position(buffer.limit());
                }
            }
        }
    }

    protected ByteBuffer convert(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        ByteBuffer byteBuffer3 = null;
        if (null != byteBuffer && byteBuffer.hasRemaining()) {
            if (byteBuffer.isDirect()) {
                byteBuffer3 = byteBuffer.slice();
                if (null != byteBuffer2 && byteBuffer2.hasRemaining() && byteBuffer2.remaining() < byteBuffer.remaining()) {
                    byteBuffer3.limit(byteBuffer2.remaining());
                }
            } else {
                int n = null == byteBuffer2 || 0 == byteBuffer2.remaining() ? Integer.MAX_VALUE : byteBuffer2.remaining();
                int n2 = byteBuffer.remaining() > n ? n : byteBuffer.remaining();
                byteBuffer3 = ByteBuffer.allocateDirect(n2);
                byteBuffer3.order(byteBuffer.order());
                byteBuffer3.put(byteBuffer.slice().limit(n2)).order(byteBuffer.order());
                byteBuffer3.flip();
            }
        }
        return byteBuffer3;
    }

    protected void checkBuffer(Buffer buffer) {
        if (0 == buffer.capacity()) {
            throw new IllegalArgumentException(ExceptionMessage.format(25, new Object[0]));
        }
    }

    protected Buffer prepareBufferInt(Buffer buffer, int n) {
        buffer.limit();
        if (0 > n) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    protected boolean tryLock0(int n) {
        return this.handle.tryLock(n);
    }

    protected void unlock0() {
        this.handle.unlock();
    }

    @Override
    public ByteOrder getByteOrder() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return ByteOrder.LITTLE_ENDIAN;
    }

    protected void processDeviceEvent(int n, DeviceEvent deviceEvent) {
    }

    protected void processNativeEvent(int n, int ... nArray) {
    }
}

