/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.registry;

import com.oracle.dio.registry.RegistrationEventHandlerImpl;
import java.util.HashMap;
import java.util.Map;
import jdk.dio.Device;
import jdk.dio.DeviceDescriptor;
import jdk.dio.RegistrationEvent;
import jdk.dio.RegistrationListener;

public abstract class RegistrationEventHandler<T extends Device> {
    private static RegistrationEventHandler singleton;
    protected Map<Class<T>, RegistrationListener> listeners = new HashMap<Class<T>, RegistrationListener>();

    protected RegistrationEventHandler() {
    }

    public static synchronized <C extends Device> void addListener(RegistrationListener registrationListener, Class<C> clazz) {
        RegistrationEventHandler.getHandler().startListening(clazz, registrationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static RegistrationEventHandler getHandler() {
        if (null != singleton) return singleton;
        Class<RegistrationEventHandler> clazz = RegistrationEventHandler.class;
        synchronized (RegistrationEventHandler.class) {
            if (null != singleton) return singleton;
            singleton = new RegistrationEventHandlerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static synchronized <C extends Device> void removeListener(RegistrationListener registrationListener, Class<C> clazz) {
        RegistrationEventHandler.getHandler().stopListening(clazz, registrationListener);
    }

    protected void notifyRegistered(DeviceDescriptor deviceDescriptor) {
        RegistrationListener registrationListener = this.listeners.get(deviceDescriptor.getInterface());
        if (null != registrationListener) {
            RegistrationEvent registrationEvent = new RegistrationEvent(deviceDescriptor);
            registrationListener.deviceRegistered(registrationEvent);
        }
    }

    protected void notifyRemoved(DeviceDescriptor deviceDescriptor) {
        RegistrationListener registrationListener = this.listeners.get(deviceDescriptor.getInterface());
        if (null != registrationListener) {
            RegistrationEvent registrationEvent = new RegistrationEvent(deviceDescriptor);
            registrationListener.deviceUnregistered(registrationEvent);
        }
    }

    protected void startListening(Class<T> clazz, RegistrationListener registrationListener) {
        this.listeners.put(clazz, registrationListener);
    }

    protected void stopListening(Class<T> clazz, RegistrationListener registrationListener) {
        this.listeners.remove(clazz);
    }
}

