/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.registry;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.RegistryImpl;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.PrivilegeController;
import com.oracle.dio.utils.PrivilegedAction;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Random;
import jdk.dio.Device;
import jdk.dio.DeviceAlreadyExistsException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceManager;
import jdk.dio.DeviceMgmtPermission;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.UnsupportedDeviceTypeException;

public abstract class Registry<T extends Device> {
    public static final boolean canRegister = true;

    public static Registry getInstance() {
        return new RegistryImpl();
    }

    public abstract DeviceDescriptor<? super T> get(int var1);

    public abstract Iterator<DeviceDescriptor<? super T>> get(String var1, Class<T> var2, String ... var3);

    public static void checkID(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(11, new Object[0]));
        }
    }

    public int register(PeripheralDescriptorImpl<? super T> peripheralDescriptorImpl) throws UnsupportedOperationException, IOException {
        Registry.checkPermission(peripheralDescriptorImpl.getName(), peripheralDescriptorImpl.getID(), "register");
        if (peripheralDescriptorImpl.getID() < -1) {
            throw new IllegalArgumentException(ExceptionMessage.format(8, new Object[0]));
        }
        int n = Registry.checkConfig(peripheralDescriptorImpl);
        return n;
    }

    private static int checkConfig(final DeviceDescriptor deviceDescriptor) throws IOException, UnsupportedDeviceTypeException, InvalidDeviceConfigException, DeviceNotFoundException, DeviceAlreadyExistsException {
        int n = PrivilegeController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() throws IOException {
                int n;
                block11: {
                    block10: {
                        Random random = new Random();
                        n = deviceDescriptor.getID();
                        while (true) {
                            if (deviceDescriptor.getID() == -1 && (n = random.nextInt()) < 1) {
                                continue;
                            }
                            try {
                                Object p = DeviceManager.open(n);
                                p.close();
                            }
                            catch (DeviceNotFoundException deviceNotFoundException) {
                                break block10;
                            }
                            catch (UnavailableDeviceException unavailableDeviceException) {
                                // empty catch block
                            }
                            if (deviceDescriptor.getID() != -1) break;
                        }
                        throw new DeviceAlreadyExistsException(ExceptionMessage.format(9, new Object[0]));
                    }
                    try {
                        Object p = DeviceManager.open(deviceDescriptor.getName(), deviceDescriptor.getInterface(), deviceDescriptor.getProperties());
                        p.close();
                    }
                    catch (IllegalArgumentException | DeviceNotFoundException exception) {
                        break block11;
                    }
                    catch (UnavailableDeviceException unavailableDeviceException) {
                        // empty catch block
                    }
                    throw new DeviceAlreadyExistsException(ExceptionMessage.format(10, new Object[0]));
                }
                try {
                    Object p = DeviceManager.open(deviceDescriptor.getInterface(), deviceDescriptor.getConfiguration());
                    p.close();
                }
                catch (UnavailableDeviceException unavailableDeviceException) {
                    // empty catch block
                }
                return n;
            }
        });
        return n;
    }

    public abstract DeviceDescriptor unregister(int var1);

    public static void checkPermission(String string, int n, String string2) {
        Object object = -1 == n ? ":*" : ":" + n;
        object = (null == string ? "*" : string) + (String)object;
        AccessController.checkPermission(new DeviceMgmtPermission((String)object, string2));
    }

    public abstract Iterator<DeviceDescriptor<? super T>> list(Class<T> var1);
}

