/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.spibus.impl;

import com.oracle.dio.impl.Handle;
import com.oracle.dio.spibus.impl.SPISlaveImpl;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import jdk.dio.ClosedDeviceException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.spibus.SPICompositeMessage;
import jdk.dio.spibus.SPIDevice;

final class SPICompositeMessageImpl
implements SPICompositeMessage {
    private final ArrayList<Message> messageList = new ArrayList();
    private boolean isAlreadyTransferedOnce;
    private final SPISlaveImpl device;
    private int delay;
    private int rxMsgs;

    private void checkStatus() throws ClosedDeviceException {
        if (this.isAlreadyTransferedOnce) {
            throw new IllegalStateException(ExceptionMessage.format(61, new Object[0]));
        }
        if (!this.device.isOpen()) {
            throw new ClosedDeviceException();
        }
    }

    private void check(Message message) throws ClosedDeviceException {
        this.checkStatus();
        if (0 > message.skip) {
            throw new IllegalArgumentException(ExceptionMessage.format(62, new Object[0]));
        }
        for (int i = 0; i < this.messageList.size(); ++i) {
            ByteBuffer byteBuffer = this.messageList.get((int)i).tx;
            ByteBuffer byteBuffer2 = this.messageList.get((int)i).rx;
            if ((null == byteBuffer || byteBuffer != message.tx && byteBuffer != message.rx) && (null == byteBuffer2 || byteBuffer2 != message.tx && byteBuffer2 != message.rx)) continue;
            throw new IllegalArgumentException(ExceptionMessage.format(64, new Object[0]));
        }
        if (null != message.rx) {
            ++this.rxMsgs;
        }
    }

    SPICompositeMessageImpl(SPISlaveImpl sPISlaveImpl) {
        this.device = sPISlaveImpl;
    }

    @Override
    public SPICompositeMessage appendRead(ByteBuffer byteBuffer) throws IOException, ClosedDeviceException {
        return this.appendRead(0, byteBuffer);
    }

    @Override
    public SPICompositeMessage appendRead(int n, ByteBuffer byteBuffer) throws IOException, ClosedDeviceException {
        byteBuffer.limit();
        return this.append(null, n, byteBuffer);
    }

    @Override
    public SPICompositeMessage appendWrite(ByteBuffer byteBuffer) throws IOException, ClosedDeviceException {
        byteBuffer.limit();
        return this.append(byteBuffer, 0, null);
    }

    @Override
    public SPICompositeMessage appendWriteAndRead(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException, ClosedDeviceException {
        return this.appendWriteAndRead(byteBuffer, 0, byteBuffer2);
    }

    @Override
    public SPICompositeMessage appendWriteAndRead(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) throws IOException, ClosedDeviceException {
        byteBuffer.limit();
        byteBuffer2.limit();
        return this.append(byteBuffer, n, byteBuffer2);
    }

    private synchronized SPICompositeMessage append(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) throws IOException, ClosedDeviceException {
        Message message = new Message(byteBuffer, n, byteBuffer2, this.delay);
        this.check(message);
        this.messageList.add(message);
        return this;
    }

    @Override
    public synchronized SPICompositeMessage appendDelay(int n) throws ClosedDeviceException {
        this.checkStatus();
        this.delay = n;
        return this;
    }

    @Override
    public SPIDevice getTargetedDevice() {
        return this.device;
    }

    private ByteBuffer[] getBuffersForTransfer(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) {
        int n2 = byteBuffer == null ? 0 : byteBuffer.remaining();
        int n3 = byteBuffer2 == null ? 0 : byteBuffer2.remaining();
        int n4 = n2 < n + n3 ? n + n3 : n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[2];
        if (byteBuffer == null || !byteBuffer.isDirect() || byteBuffer.remaining() < n4) {
            byteBufferArray[0] = ByteBuffer.allocateDirect(n4);
            if (byteBuffer != null) {
                byteBufferArray[0].put(byteBuffer);
            }
            byteBufferArray[0].rewind();
        } else {
            byteBufferArray[0] = byteBuffer.slice();
        }
        byteBufferArray[1] = byteBuffer2 == null || !byteBuffer2.isDirect() || byteBuffer2.remaining() < n4 ? ByteBuffer.allocateDirect(n4) : byteBuffer2.slice();
        return byteBufferArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] transfer() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        Handle handle = this.device.getHandle();
        synchronized (handle) {
            int n;
            this.isAlreadyTransferedOnce = true;
            if (0 == this.messageList.size()) {
                return new int[0];
            }
            this.device.beginTransaction();
            try {
                n = this.messageList.size();
                for (int i = 0; i < n; ++i) {
                    Message message = this.messageList.get(i);
                    ByteBuffer[] object = this.getBuffersForTransfer(message.tx, message.skip, message.rx);
                    message.newTx = object[0];
                    message.newRx = object[1];
                    if (message.newRx.remaining() > 0) {
                        this.device.transferWithLock(message.newTx, message.newRx);
                    }
                    Thread.currentThread();
                    Thread.sleep(message.delay / 1000, message.delay % 1000 * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(ExceptionMessage.format(90, new Object[0]));
            }
            finally {
                this.device.endTransaction();
            }
            n = 0;
            int[] nArray = new int[this.rxMsgs];
            for (Message message : this.messageList) {
                if (message.tx != null) {
                    message.tx.position(message.tx.limit());
                }
                if (message.rx != null) {
                    message.newRx.position(message.skip);
                    try {
                        message.newRx.limit(message.skip + message.rx.remaining());
                        nArray[n++] = message.newRx.remaining();
                        message.rx.put(message.newRx);
                    }
                    catch (IllegalArgumentException | BufferOverflowException runtimeException) {
                        throw new ConcurrentModificationException(ExceptionMessage.format(89, new Object[0]));
                    }
                }
                message.newRx = null;
                message.newTx = null;
            }
            return nArray;
        }
    }

    private class Message {
        ByteBuffer tx;
        ByteBuffer rx;
        ByteBuffer newTx;
        ByteBuffer newRx;
        int skip;
        int delay;

        public Message(ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2, int n2) {
            this.rx = byteBuffer2;
            this.skip = n;
            this.tx = byteBuffer;
            this.delay = n2;
        }
    }
}

