/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.spibus.impl;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.RegistryData;
import java.io.IOException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.spibus.SPIDevice;
import jdk.dio.spibus.SPIDeviceConfig;

public final class SPIDeviceRegistryFactory
extends DeviceRegistryFactory {
    private static final String CLOCK_MODE = "clockMode";
    private static final String WORD_LENGTH = "wordLength";
    private static final String BIT_ORDERING = "bitOrdering";
    private static final String CS_ACTIVE = "csActive";
    private static final String TYPE_VALUE = "spibus.SPIDevice";

    @Override
    public DeviceDescriptor<SPIDevice> createDeviceDescriptor(int n, RegistryData registryData) throws IOException {
        SPIDeviceConfig sPIDeviceConfig;
        String string = registryData.getCharacterProperty("name");
        String string2 = registryData.getCharacterProperty("controllerName");
        int n2 = registryData.getIntegerProperty("address", -1);
        int n3 = registryData.getIntegerProperty("clockFrequency", -1);
        int n4 = registryData.getIntegerProperty(CLOCK_MODE, -1);
        int n5 = registryData.getIntegerProperty(WORD_LENGTH, -1);
        int n6 = registryData.getIntegerProperty(BIT_ORDERING, -1);
        int n7 = registryData.getIntegerProperty(CS_ACTIVE, -1);
        if (null == string2) {
            int n8 = registryData.getIntegerProperty("controllerNumber", -1);
            sPIDeviceConfig = new SPIDeviceConfig(n8, n2, n7, n3, n4, n5, n6);
        } else {
            sPIDeviceConfig = new SPIDeviceConfig(string2, n2, n7, n3, n4, n5, n6);
        }
        String[] stringArray = super.getProperties(registryData);
        return new PeripheralDescriptorImpl<SPIDevice>(n, string, sPIDeviceConfig, SPIDevice.class, stringArray);
    }

    @Override
    public RegistryData createRegistryData(DeviceDescriptor deviceDescriptor) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string;
        SPIDeviceConfig sPIDeviceConfig = (SPIDeviceConfig)deviceDescriptor.getConfiguration();
        String string2 = deviceDescriptor.getName();
        RegistryData registryData = new RegistryData();
        registryData.putCharacterProperty("deviceType", TYPE_VALUE);
        if (string2 != null) {
            registryData.putCharacterProperty("name", string2);
        }
        if ((string = sPIDeviceConfig.getControllerName()) != null) {
            registryData.putCharacterProperty("controllerName", string);
        }
        if ((n7 = sPIDeviceConfig.getControllerNumber()) != -1) {
            registryData.putIntegerProperty("controllerNumber", n7);
        }
        if ((n6 = sPIDeviceConfig.getAddress()) != -1) {
            registryData.putIntegerProperty("address", n6);
        }
        if ((n5 = sPIDeviceConfig.getClockFrequency()) != -1) {
            registryData.putIntegerProperty("clockFrequency", n5);
        }
        if ((n4 = sPIDeviceConfig.getClockMode()) != -1) {
            registryData.putIntegerProperty(CLOCK_MODE, n4);
        }
        if ((n3 = sPIDeviceConfig.getWordLength()) != -1) {
            registryData.putIntegerProperty(WORD_LENGTH, n3);
        }
        if ((n2 = sPIDeviceConfig.getBitOrdering()) != -1) {
            registryData.putIntegerProperty(BIT_ORDERING, n2);
        }
        if ((n = sPIDeviceConfig.getCSActiveLevel()) != -1) {
            registryData.putIntegerProperty(CS_ACTIVE, n);
        }
        super.putProperties(registryData, deviceDescriptor.getProperties());
        return registryData;
    }
}

