/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.uart.impl;

import com.oracle.dio.uart.impl.ModemSignalDispatcher;
import com.oracle.dio.uart.impl.UARTImpl;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.UnsupportedAccessModeException;
import jdk.dio.modem.ModemSignalEvent;
import jdk.dio.modem.ModemSignalListener;
import jdk.dio.uart.ModemUART;
import jdk.dio.uart.UART;

class ModemUARTImpl
extends UARTImpl
implements ModemUART,
ModemSignalDispatcher.SerialSignalListener {
    private ModemSignalListener modemListener;

    ModemUARTImpl(DeviceDescriptor<UART> deviceDescriptor, int n) throws DeviceNotFoundException, InvalidDeviceConfigException, UnsupportedAccessModeException {
        super(deviceDescriptor, n);
    }

    @Override
    public synchronized void setSignalState(int n, boolean bl) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (n != 1 && n != 16) {
            throw new IllegalArgumentException(ExceptionMessage.format(95, new Object[0]));
        }
        this.checkPowerState();
        this.setDTESignalState0(n, bl);
    }

    @Override
    public synchronized boolean getSignalState(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (n != 32 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException(ExceptionMessage.format(95, new Object[0]));
        }
        this.checkPowerState();
        return this.getDCESignalState0(n);
    }

    @Override
    public synchronized void setSignalChangeListener(ModemSignalListener<ModemUART> modemSignalListener, int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        int n2 = -47;
        if ((n & n2) != 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(96, new Object[0]));
        }
        this.checkPowerState();
        if (modemSignalListener != null && this.modemListener != null) {
            throw new IllegalStateException(ExceptionMessage.format(97, new Object[0]));
        }
        if (modemSignalListener != null) {
            if (this.modemListener == null) {
                ModemSignalDispatcher.getInstance().addListener(this.getHandle().getNativeHandle(), this);
            }
            this.modemListener = modemSignalListener;
        } else {
            ModemSignalDispatcher.getInstance().removeListener(this.getHandle().getNativeHandle(), this);
            this.modemListener = null;
        }
    }

    @Override
    public void signalChanged(int n, boolean bl) {
        ModemSignalListener modemSignalListener = this.modemListener;
        if (null != modemSignalListener) {
            ModemSignalEvent<ModemUARTImpl> modemSignalEvent = new ModemSignalEvent<ModemUARTImpl>(this, n, bl);
            try {
                modemSignalListener.signalStateChanged(modemSignalEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            if (this.modemListener != null) {
                ModemSignalDispatcher.getInstance().removeListener(this.getHandle().getNativeHandle(), this);
                this.modemListener = null;
            }
            super.close();
        }
    }

    private native void setDTESignalState0(int var1, boolean var2);

    private native boolean getDCESignalState0(int var1);
}

