/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.uart.impl;

import com.oracle.dio.impl.EventQueueManager;
import com.oracle.dio.power.impl.PowerManagedBase;
import com.oracle.dio.uart.impl.UARTOptionsHandler;
import com.oracle.dio.utils.Configuration;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Logging;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.StringTokenizer;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceEvent;
import jdk.dio.DeviceEventListener;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InputRoundListener;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.OutputRoundListener;
import jdk.dio.RoundCompletionEvent;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.UnsupportedAccessModeException;
import jdk.dio.uart.UART;
import jdk.dio.uart.UARTConfig;
import jdk.dio.uart.UARTEvent;
import jdk.dio.uart.UARTEventListener;
import jdk.dio.uart.UARTPermission;

class UARTImpl
extends PowerManagedBase<UART>
implements UART {
    private boolean isWriting;
    private final Object synchReadLock = new Object();
    private final Object synchWriteLock = new Object();
    private final Queue<ByteBuffer> writeBuffers = new LinkedList<ByteBuffer>();
    private final Queue<ByteBuffer> readBuffers = new LinkedList<ByteBuffer>();
    private InputRoundListener<UART, ByteBuffer> inRoundListener;
    private OutputRoundListener<UART, ByteBuffer> outRoundListener;
    private Hashtable<Integer, UARTEventListener> eventListeners;
    private int receiveTriggerLevel;
    private int inputTimeout = Integer.MAX_VALUE;
    private int totalBytesRead;

    UARTImpl(DeviceDescriptor<UART> deviceDescriptor, int n) throws DeviceNotFoundException, InvalidDeviceConfigException, UnsupportedAccessModeException {
        super(deviceDescriptor, n);
        byte[] byArray;
        String string = this.getSecurityName();
        UARTPermission uARTPermission = new UARTPermission(null != string ? string : "*");
        AccessController.checkPermission(uARTPermission);
        if (string == null) {
            throw new DeviceNotFoundException(ExceptionMessage.format(91, new Object[0]));
        }
        if (n != 1) {
            throw new UnsupportedAccessModeException();
        }
        UARTConfig uARTConfig = (UARTConfig)deviceDescriptor.getConfiguration();
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DeviceNotFoundException(ExceptionMessage.format(92, new Object[0]));
        }
        this.openUARTByConfig0(byArray, uARTConfig.getBaudRate(), uARTConfig.getStopBits(), uARTConfig.getFlowControlMode(), uARTConfig.getDataBits(), uARTConfig.getParity(), n == 1);
        this.isWriting = false;
        this.eventListeners = new Hashtable();
        this.initPowerManagement();
        UARTOptionsHandler.processOptions(this, deviceDescriptor.getProperties());
    }

    private boolean isAlphaNumerical(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSecurityName() {
        UARTConfig uARTConfig = (UARTConfig)this.dscr.getConfiguration();
        int n = uARTConfig.getControllerNumber();
        String string = null;
        if (null != uARTConfig.getControllerName()) {
            string = uARTConfig.getControllerName();
            int n2 = 0;
            while (n2 < string.length()) {
                if (!this.isAlphaNumerical(string.charAt(n2))) {
                    Logging.reportError("Unacceptable device name:", string);
                    return null;
                }
                ++n2;
            }
            return string;
        }
        if (n == -1) {
            n = 0;
        }
        try {
            String string2 = Configuration.getProperty("microedition.commports");
            if (null == string2) return string;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (n-- > 0 && stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer.hasMoreTokens()) return string;
            return stringTokenizer.nextToken();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return string;
    }

    protected void checkPowerPermission() {
        AccessController.checkPermission(new UARTPermission(this.getSecurityName(), "powermanage"));
    }

    @Override
    protected void processNativeEvent(int n, int ... nArray) {
        Object object;
        DeviceEventListener deviceEventListener = this.eventListeners.get(n);
        if (deviceEventListener != null) {
            try {
                object = new UARTEvent(this, n);
                deviceEventListener.eventDispatched((UARTEvent)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        switch (n) {
            case 0: {
                deviceEventListener = this.inRoundListener;
                if (deviceEventListener == null) break;
                object = this.readBuffers.peek();
                if (null == object) {
                    Logging.reportError("[UART] No buffer is ready for read operation");
                    return;
                }
                int n2 = this.read0((ByteBuffer)object);
                this.totalBytesRead += n2;
                this.shiftBufferPosition((Buffer)object, ((Buffer)object).position() + n2);
                boolean bl = deviceEventListener instanceof InternalRoundListener;
                if (((Buffer)object).hasRemaining() && !bl) break;
                RoundCompletionEvent<UARTImpl, Object> roundCompletionEvent = new RoundCompletionEvent<UARTImpl, Object>(this, object, this.totalBytesRead);
                try {
                    deviceEventListener.inputRoundCompleted(roundCompletionEvent);
                }
                catch (Exception exception) {
                    Logging.reportWarning(exception.toString());
                }
                if (bl) break;
                this.totalBytesRead = 0;
                if (this.inRoundListener == null) break;
                this.readBuffers.remove();
                if (((Buffer)object).hasRemaining()) {
                    this.readBuffers.add((ByteBuffer)object);
                    break;
                }
                roundCompletionEvent = new RoundCompletionEvent<UARTImpl, Object>(this, object, 0);
                EventQueueManager.getInstance().postEvent(this, 0, roundCompletionEvent);
                break;
            }
            case 2: {
                int n3 = nArray[0];
                object = this.outRoundListener;
                if (object == null) break;
                ByteBuffer byteBuffer = this.writeBuffers.poll();
                if (null == byteBuffer) {
                    Logging.reportError("[UART] No buffer is ready for write operation");
                    return;
                }
                this.shiftBufferPosition(byteBuffer, byteBuffer.limit());
                RoundCompletionEvent<UARTImpl, ByteBuffer> roundCompletionEvent = new RoundCompletionEvent<UARTImpl, ByteBuffer>(this, byteBuffer, n3);
                try {
                    object.outputRoundCompleted(roundCompletionEvent);
                }
                catch (Exception exception) {
                    Logging.reportWarning(exception.toString());
                }
                if (!this.isWriting) break;
                if (byteBuffer.hasRemaining()) {
                    this.writeBuffers.add(byteBuffer);
                } else {
                    roundCompletionEvent = new RoundCompletionEvent<UARTImpl, ByteBuffer>(this, byteBuffer, 0);
                    EventQueueManager.getInstance().postEvent(this, 2, roundCompletionEvent);
                }
                byteBuffer = this.writeBuffers.peek();
                if (null == byteBuffer) break;
                this.writeAsynch0(byteBuffer);
            }
        }
    }

    @Override
    protected void processDeviceEvent(int n, DeviceEvent deviceEvent) {
        if (n == 2) {
            OutputRoundListener<UART, ByteBuffer> outputRoundListener = this.outRoundListener;
            if (outputRoundListener != null) {
                try {
                    outputRoundListener.outputRoundCompleted((RoundCompletionEvent)deviceEvent);
                }
                catch (Exception exception) {
                    Logging.reportWarning(exception.toString());
                }
                if (this.isWriting) {
                    ByteBuffer byteBuffer = (ByteBuffer)((RoundCompletionEvent)deviceEvent).getBuffer();
                    if (byteBuffer.hasRemaining()) {
                        if (this.writeBuffers.peek() == null) {
                            this.writeAsynch0(byteBuffer);
                        }
                        this.writeBuffers.add(byteBuffer);
                    } else {
                        EventQueueManager.getInstance().postEvent(this, 2, deviceEvent);
                    }
                }
            }
        } else if (n == 0) {
            InputRoundListener<UART, ByteBuffer> inputRoundListener = this.inRoundListener;
            if (inputRoundListener != null) {
                try {
                    inputRoundListener.inputRoundCompleted((RoundCompletionEvent)deviceEvent);
                }
                catch (Exception exception) {
                    Logging.reportWarning(exception.toString());
                }
                if (this.inRoundListener != null) {
                    ByteBuffer byteBuffer = (ByteBuffer)((RoundCompletionEvent)deviceEvent).getBuffer();
                    if (byteBuffer.hasRemaining()) {
                        ByteBuffer byteBuffer2 = this.readBuffers.peek();
                        this.readBuffers.add(byteBuffer);
                        if (byteBuffer2 == null) {
                            this.processNativeEvent(0, 0);
                        }
                    } else {
                        EventQueueManager.getInstance().postEvent(this, 0, deviceEvent);
                    }
                }
            }
        } else {
            Logging.reportError("UART.processDeviceEvent: unknown event " + n);
        }
    }

    @Override
    public synchronized int getBaudRate() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.getBaudRate0();
    }

    @Override
    public synchronized int getDataBits() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.getDataBits0();
    }

    @Override
    public synchronized int getFlowControlMode() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        return this.getFlowControlMode0();
    }

    @Override
    public synchronized int getParity() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.getParity0();
    }

    @Override
    public synchronized int getStopBits() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.getStopBits0();
    }

    @Override
    public synchronized void setBaudRate(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        new UARTConfig.Builder().setBaudRate(n);
        this.setBaudRate0(n);
    }

    @Override
    public synchronized void setDataBits(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        new UARTConfig.Builder().setDataBits(n);
        this.setDataBits0(n);
    }

    @Override
    public synchronized void setEventListener(int n, UARTEventListener uARTEventListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        if (n != 1 && n != 0 && n != 2 && n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        UARTEventListener uARTEventListener2 = this.eventListeners.get(n);
        if (uARTEventListener != null && uARTEventListener2 != null) {
            throw new IllegalStateException();
        }
        if (uARTEventListener == null) {
            this.eventListeners.remove(n);
            this.unsubscribe(n);
        } else {
            this.eventListeners.put(n, uARTEventListener);
            this.subscribe(n);
        }
    }

    private void subscribe(int n) {
        EventQueueManager.getInstance().setEventListener(UART.class, n, this);
        this.setEventListener0(n);
    }

    private void unsubscribe(int n) {
        if (n == 0 && (this.inRoundListener != null || this.eventListeners.get(n) != null)) {
            return;
        }
        EventQueueManager.getInstance().removeEventListener(UART.class, n, this);
        this.removeEventListener0(n);
    }

    @Override
    public synchronized void setFlowControlMode(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        new UARTConfig.Builder().setFlowControlMode(n);
        this.setFlowControlMode0(n);
    }

    @Override
    public synchronized void setParity(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        new UARTConfig.Builder().setParity(n);
        this.setParity0(n);
    }

    @Override
    public synchronized void setStopBits(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        new UARTConfig.Builder().setStopBits(n);
        this.setStopBits0(n);
    }

    @Override
    public void startWriting(ByteBuffer byteBuffer, OutputRoundListener<UART, ByteBuffer> outputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkBuffer(byteBuffer);
        Objects.requireNonNull(outputRoundListener, ExceptionMessage.format(26, new Object[0]));
        this.writeAsync(byteBuffer, null, outputRoundListener);
    }

    @Override
    public void startWriting(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, OutputRoundListener<UART, ByteBuffer> outputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkBuffer(byteBuffer);
        this.checkBuffer(byteBuffer2);
        Objects.requireNonNull(outputRoundListener, ExceptionMessage.format(26, new Object[0]));
        this.writeAsync(byteBuffer, byteBuffer2, outputRoundListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAsync(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, OutputRoundListener<UART, ByteBuffer> outputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        Object object = this.synchWriteLock;
        synchronized (object) {
            this.checkWrite();
            this.writeBuffers.add(byteBuffer);
            if (null != byteBuffer2) {
                this.writeBuffers.add(byteBuffer2);
            }
            this.outRoundListener = outputRoundListener;
            this.subscribe(2);
            this.writeAsynch0(byteBuffer);
            this.isWriting = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWriting() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        Object object = this.synchWriteLock;
        synchronized (object) {
            if (this.isWriting) {
                this.writeBuffers.clear();
                this.outRoundListener = null;
                this.unsubscribe(2);
                this.stopWriting0();
                this.isWriting = false;
            }
        }
    }

    @Override
    public void startReading(ByteBuffer byteBuffer, InputRoundListener<UART, ByteBuffer> inputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkBuffer(byteBuffer);
        Objects.requireNonNull(inputRoundListener, ExceptionMessage.format(26, new Object[0]));
        this.readAsync(byteBuffer, null, inputRoundListener);
    }

    @Override
    public void startReading(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, InputRoundListener<UART, ByteBuffer> inputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkBuffer(byteBuffer);
        this.checkBuffer(byteBuffer2);
        Objects.requireNonNull(inputRoundListener, ExceptionMessage.format(26, new Object[0]));
        this.readAsync(byteBuffer, byteBuffer2, inputRoundListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAsync(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, InputRoundListener<UART, ByteBuffer> inputRoundListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        Object object = this.synchReadLock;
        synchronized (object) {
            this.checkRead();
            this.totalBytesRead = 0;
            this.inRoundListener = inputRoundListener;
            this.readBuffers.add(byteBuffer);
            if (null != byteBuffer2) {
                this.readBuffers.add(byteBuffer2);
            }
            this.subscribe(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReading(boolean bl) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        Object object = this.synchReadLock;
        synchronized (object) {
            if (null != this.inRoundListener && bl == this.inRoundListener instanceof InternalRoundListener) {
                this.readBuffers.clear();
                this.inRoundListener = null;
                this.unsubscribe(0);
                this.stopReading0();
                this.synchReadLock.notifyAll();
            }
        }
    }

    @Override
    public void stopReading() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.stopReading(false);
    }

    @Override
    public synchronized void generateBreak(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        if (0 > n) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.checkPowerState();
        this.generateBreak0(n);
    }

    @Override
    public synchronized void setReceiveTriggerLevel(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.receiveTriggerLevel = n;
    }

    @Override
    public synchronized int getReceiveTriggerLevel() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.receiveTriggerLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        int n;
        if (!byteBuffer.hasRemaining()) {
            n = 0;
        } else {
            n = byteBuffer.position();
            Object object = this.synchReadLock;
            synchronized (object) {
                this.checkRead();
                int n2 = this.read0(byteBuffer);
                this.shiftBufferPosition(byteBuffer, n + n2);
                if ((0 == this.receiveTriggerLevel || n2 < this.receiveTriggerLevel) && byteBuffer.hasRemaining() && !EventQueueManager.getInstance().isDispatchThread() && this.inputTimeout > 0) {
                    this.startReading(byteBuffer, new InternalRoundListener(0 != this.receiveTriggerLevel ? this.receiveTriggerLevel - n2 : byteBuffer.remaining()));
                    try {
                        if (this.inputTimeout == Integer.MAX_VALUE) {
                            this.synchReadLock.wait();
                        } else if (this.inputTimeout > 0) {
                            this.synchReadLock.wait(this.inputTimeout);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException();
                    }
                    finally {
                        this.stopReading(true);
                    }
                }
            }
            n = byteBuffer.position() - n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        int n = 0;
        Object object = this.synchWriteLock;
        synchronized (object) {
            this.checkWrite();
            this.isWriting = true;
        }
        try {
            n = this.write0(byteBuffer.slice());
            this.shiftBufferPosition(byteBuffer, byteBuffer.position() + n);
        }
        finally {
            this.isWriting = false;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.stopWriting();
            this.stopReading(this.inRoundListener instanceof InternalRoundListener);
            super.close();
        }
    }

    @Override
    public synchronized int getReceiveTimeout() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        return this.inputTimeout;
    }

    @Override
    public synchronized void setReceiveTimeout(int n) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkPowerState();
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(98, new Object[0]));
        }
        this.inputTimeout = n;
    }

    private void checkRead() {
        if (this.inRoundListener != null) {
            throw new IllegalStateException(ExceptionMessage.format(93, new Object[0]));
        }
    }

    private void checkWrite() {
        if (this.isWriting) {
            throw new IllegalStateException(ExceptionMessage.format(94, new Object[0]));
        }
    }

    protected synchronized int getGrpID() {
        return this.getUartId0();
    }

    @Override
    public synchronized ByteBuffer getInputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ByteBuffer getOutputBuffer() throws ClosedDeviceException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer prepareBuffer(ByteBuffer byteBuffer, int n) throws IOException, ClosedDeviceException {
        return (ByteBuffer)super.prepareBufferInt(byteBuffer, n);
    }

    private native void removeEventListener0(int var1);

    private native void setEventListener0(int var1);

    private native void openUARTByConfig0(byte[] var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native int write0(ByteBuffer var1);

    private native void writeAsynch0(ByteBuffer var1);

    private native int read0(ByteBuffer var1);

    private native int getBaudRate0();

    private native void setBaudRate0(int var1);

    private native int getDataBits0();

    private native void setDataBits0(int var1);

    private native int getParity0();

    private native int setParity0(int var1);

    private native int getStopBits0();

    private native int setStopBits0(int var1);

    private native void stopWriting0();

    private native void stopReading0();

    private native int getUartId0();

    private native int setFlowControlMode0(int var1);

    private native int getFlowControlMode0();

    private native int generateBreak0(int var1);

    private class InternalRoundListener
    implements InputRoundListener<UART, ByteBuffer> {
        private final int toRead;

        private InternalRoundListener(int n) {
            this.toRead = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            Object object = UARTImpl.this.synchReadLock;
            synchronized (object) {
                try {
                    UARTImpl.this.stopReading(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                UARTImpl.this.synchReadLock.notifyAll();
            }
        }

        @Override
        public void inputRoundCompleted(RoundCompletionEvent<UART, ByteBuffer> roundCompletionEvent) {
            if (roundCompletionEvent.getNumber() >= this.toRead || !roundCompletionEvent.getBuffer().hasRemaining()) {
                this.stop();
            }
        }

        @Override
        public void failed(Throwable throwable, UART uART) {
            this.stop();
        }
    }
}

