/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio;

import apimarker.API;
import java.nio.Buffer;
import jdk.dio.Device;
import jdk.dio.DeviceEvent;

@API(value="device-io_1.1")
public class RoundCompletionEvent<P extends Device<? super P>, B extends Buffer>
extends DeviceEvent<P> {
    private B buffer;
    private int number;
    private boolean onError;

    public RoundCompletionEvent(P p, B b, int n) {
        this(p, b, n, System.currentTimeMillis(), 0);
    }

    public RoundCompletionEvent(P p, B b, int n, long l, int n2) {
        if (null == p || b == null) {
            throw new NullPointerException();
        }
        if (n < 0 || l < 0L || n2 < 0 || n2 > 999) {
            throw new IllegalArgumentException();
        }
        this.device = p;
        this.buffer = b;
        this.number = n;
        this.timeStamp = l;
        this.timeStampMicros = n2;
        this.count = 1;
    }

    public RoundCompletionEvent(P p, B b, int n, boolean bl) {
        this(p, b, n, bl, System.currentTimeMillis(), 0);
    }

    public RoundCompletionEvent(P p, B b, int n, boolean bl, long l, int n2) {
        this(p, b, n, l, n2);
        this.onError = bl;
    }

    public B getBuffer() {
        return this.buffer;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isOnError() {
        return this.onError;
    }
}

