/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.counter;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.counter.PulseCounter;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_counter")
public final class PulseCounterConfig
implements DeviceConfig<PulseCounter>,
DeviceConfig.HardwareAddressing {
    public static final int TYPE_FALLING_EDGE_ONLY = 0;
    public static final int TYPE_NEGATIVE_PULSE = 3;
    public static final int TYPE_POSITIVE_PULSE = 2;
    public static final int TYPE_RISING_EDGE_ONLY = 1;
    private String controllerName;
    private int controllerNumber = -1;
    private int channelNumber = -1;
    private GPIOPinConfig sourceConfig;
    private int type = -1;

    @DontRenameMethod
    PulseCounterConfig() {
    }

    @Deprecated
    public PulseCounterConfig(int n, int n2, int n3) {
        this.controllerNumber = n;
        this.channelNumber = n2;
        this.type = n3;
        this.checkValues();
    }

    @Deprecated
    public PulseCounterConfig(int n, int n2, int n3, GPIOPinConfig gPIOPinConfig) {
        this(n, n2, n3);
        PulseCounterConfig.checkSourceConfig(gPIOPinConfig);
        this.sourceConfig = gPIOPinConfig;
    }

    @Deprecated
    public PulseCounterConfig(String string, int n, int n2) {
        this(-1, n, n2);
        string.length();
        this.controllerName = string;
    }

    @Deprecated
    public PulseCounterConfig(String string, int n, int n2, GPIOPinConfig gPIOPinConfig) {
        this(string, n, n2);
        PulseCounterConfig.checkSourceConfig(gPIOPinConfig);
        this.sourceConfig = gPIOPinConfig;
    }

    public static PulseCounterConfig deserialize(InputStream inputStream) throws IOException {
        return (PulseCounterConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    @Deprecated
    public GPIOPin getSource() {
        return null;
    }

    public GPIOPinConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 83);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private static void checkType(int n) {
        if (3 < n || 0 > n) {
            throw new IllegalArgumentException(ExceptionMessage.format(35, new Object[0]));
        }
    }

    private static void checkSourceConfig(GPIOPinConfig gPIOPinConfig) {
        if (gPIOPinConfig.getDirection() != 0 && gPIOPinConfig.getDirection() != 2) {
            throw new IllegalArgumentException(ExceptionMessage.format(36, new Object[0]));
        }
    }

    private void checkValues() throws IllegalArgumentException {
        int n;
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntValue(this.channelNumber);
        PulseCounterConfig.checkType(this.type);
        if (null != this.sourceConfig && (n = this.sourceConfig.getTrigger()) >>> 1 != this.type && this.type > 1 && n != 3) {
            throw new IllegalArgumentException(ExceptionMessage.format(36, new Object[0]));
        }
    }

    @API(value="device-io_1.1_counter")
    public static final class Builder {
        private final PulseCounterConfig instance = new PulseCounterConfig();

        public PulseCounterConfig build() {
            if (this.instance.type == -1) {
                throw new IllegalStateException();
            }
            this.instance.checkValues();
            return (PulseCounterConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setChannelNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.channelNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setSourceConfig(GPIOPinConfig gPIOPinConfig) {
            if (null != gPIOPinConfig) {
                PulseCounterConfig.checkSourceConfig(gPIOPinConfig);
            }
            this.instance.sourceConfig = gPIOPinConfig;
            return this;
        }

        public Builder setType(int n) {
            PulseCounterConfig.checkType(n);
            this.instance.type = n;
            return this;
        }
    }
}

