/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.gpio;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;
import jdk.dio.gpio.GPIOPort;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_gpio")
public final class GPIOPortConfig
implements DeviceConfig<GPIOPort> {
    public static final int DIR_BOTH_INIT_INPUT = 2;
    public static final int DIR_BOTH_INIT_OUTPUT = 3;
    public static final int DIR_INPUT_ONLY = 0;
    public static final int DIR_OUTPUT_ONLY = 1;
    private int direction;
    private int initValue;
    private GPIOPinConfig[] pinConfigs;

    @DontRenameMethod
    GPIOPortConfig() {
    }

    public GPIOPortConfig(int n, int n2, GPIOPinConfig ... gPIOPinConfigArray) {
        this.direction = n;
        this.initValue = n2;
        this.pinConfigs = new GPIOPinConfig[gPIOPinConfigArray.length];
        System.arraycopy(gPIOPinConfigArray, 0, this.pinConfigs, 0, gPIOPinConfigArray.length);
        this.checkValues();
    }

    private void checkValues() {
        if (0 > this.direction || 3 < this.direction) {
            throw new IllegalArgumentException(ExceptionMessage.format(48, new Object[0]));
        }
        if (this.pinConfigs.length == 0) {
            throw new IllegalArgumentException();
        }
        for (GPIOPinConfig gPIOPinConfig : this.pinConfigs) {
            if (gPIOPinConfig.getDirection() == this.direction || gPIOPinConfig.getDirection() >= 2) continue;
            throw new IllegalArgumentException(ExceptionMessage.format(51, new Object[0]));
        }
    }

    public static GPIOPortConfig deserialize(InputStream inputStream) throws IOException {
        return (GPIOPortConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getDirection() {
        return this.direction;
    }

    public int getInitValue() {
        return this.initValue;
    }

    public GPIOPinConfig[] getPinConfigs() {
        if (this.pinConfigs != null) {
            GPIOPinConfig[] gPIOPinConfigArray = new GPIOPinConfig[this.pinConfigs.length];
            System.arraycopy(this.pinConfigs, 0, gPIOPinConfigArray, 0, this.pinConfigs.length);
            return gPIOPinConfigArray;
        }
        return null;
    }

    @Deprecated
    public GPIOPin[] getPins() {
        return null;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 97);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }
}

