/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.i2cbus;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.i2cbus.I2CDevice;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_i2cbus")
public final class I2CDeviceConfig
implements DeviceConfig<I2CDevice>,
DeviceConfig.HardwareAddressing {
    public static final int ADDR_SIZE_7 = 7;
    public static final int ADDR_SIZE_10 = 10;
    private String controllerName;
    private int address = -1;
    private int addressSize = -1;
    private int controllerNumber = -1;
    private int clockFrequency = -1;
    private int inputBufferSize = -1;
    private int outputBufferSize = -1;

    @DontRenameMethod
    I2CDeviceConfig() {
    }

    @Deprecated
    public I2CDeviceConfig(int n, int n2, int n3, int n4) {
        this.controllerNumber = n;
        this.address = n2;
        this.addressSize = n3;
        this.clockFrequency = n4;
        this.checkValues();
    }

    @Deprecated
    public I2CDeviceConfig(String string, int n, int n2, int n3) {
        this(-1, n, n2, n3);
        string.length();
        this.controllerName = string;
    }

    public static I2CDeviceConfig deserialize(InputStream inputStream) throws IOException {
        return (I2CDeviceConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getAddress() {
        return this.address;
    }

    public int getAddressSize() {
        return this.addressSize;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getClockFrequency() {
        return this.clockFrequency;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 97);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private static void checkAddressSize(int n, int n2) {
        if (7 != n2 && 10 != n2) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        int n3 = 2;
        for (int i = 0; i < n2 - 1; ++i) {
            n3 *= 2;
        }
        if (n >= n3) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private void checkValues() {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntZeroOrPozitive(this.address);
        Utils.checkGreaterThanZero(this.clockFrequency);
        I2CDeviceConfig.checkAddressSize(this.address, this.addressSize);
    }

    @API(value="device-io_1.1_i2cbus")
    public static final class Builder {
        private final I2CDeviceConfig instance = new I2CDeviceConfig();

        public I2CDeviceConfig build() {
            if (-1 == this.instance.address) {
                throw new IllegalStateException();
            }
            return (I2CDeviceConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setAddress(int n, int n2) {
            Utils.checkIntZeroOrPozitive(n);
            I2CDeviceConfig.checkAddressSize(n, n2);
            this.instance.address = n;
            this.instance.addressSize = n2;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setInputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.inputBufferSize = n;
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.outputBufferSize = n;
            return this;
        }

        public Builder setClockFrequency(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.clockFrequency = n;
            return this;
        }
    }
}

