/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.spibus;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.spibus.SPIDevice;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_spibus")
public final class SPIDeviceConfig
implements DeviceConfig<SPIDevice>,
DeviceConfig.HardwareAddressing {
    public static final int CS_ACTIVE_HIGH = 0;
    public static final int CS_ACTIVE_LOW = 1;
    public static final int CS_NOT_CONTROLLED = 2;
    private String controllerName;
    private int address = -1;
    private int csActive = -1;
    private int controllerNumber = -1;
    private int bitOrdering = -1;
    private int clockFrequency = -1;
    private int clockMode;
    private int wordLength = -1;
    private int inputBufferSize = -1;
    private int outputBufferSize = -1;

    @DontRenameMethod
    SPIDeviceConfig() {
    }

    @Deprecated
    public SPIDeviceConfig(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, -1, n3, n4, n5, n6);
    }

    @Deprecated
    public SPIDeviceConfig(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.controllerNumber = n;
        this.address = n2;
        this.csActive = n3;
        this.clockFrequency = n4;
        this.clockMode = n5;
        this.wordLength = n6;
        this.bitOrdering = n7;
        this.checkParameters();
    }

    @Deprecated
    public SPIDeviceConfig(String string, int n, int n2, int n3, int n4, int n5) {
        this(string, n, -1, n2, n3, n4, n5);
    }

    @Deprecated
    public SPIDeviceConfig(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this(-1, n, n2, n3, n4, n5, n6);
        string.length();
        this.controllerName = string;
    }

    public static SPIDeviceConfig deserialize(InputStream inputStream) throws IOException {
        return (SPIDeviceConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getAddress() {
        return this.address;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getBitOrdering() {
        return this.bitOrdering;
    }

    public int getClockFrequency() {
        return this.clockFrequency;
    }

    public int getClockMode() {
        return this.clockMode;
    }

    public int getCSActiveLevel() {
        return this.csActive;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public int hashCode() {
        return Platform.hash(this, 7, 47);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private static void checkCsActive(int n) {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private static void checkClockMode(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private static void checkBitOrdering(int n) {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    private void checkParameters() {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntZeroOrPozitive(this.address);
        Utils.checkGreaterThanZero(this.clockFrequency);
        SPIDeviceConfig.checkCsActive(this.csActive);
        SPIDeviceConfig.checkClockMode(this.clockMode);
        SPIDeviceConfig.checkBitOrdering(this.bitOrdering);
        Utils.checkGreaterThanZero(this.wordLength);
    }

    @API(value="device-io_1.1_spibus")
    public static final class Builder {
        private final SPIDeviceConfig instance = new SPIDeviceConfig();

        public SPIDeviceConfig build() {
            if (-1 == this.instance.address) {
                throw new IllegalStateException();
            }
            return this.instance;
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setAddress(int n) {
            Utils.checkIntZeroOrPozitive(n);
            this.instance.address = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setInputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.inputBufferSize = n;
            return this;
        }

        public Builder setOutputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.outputBufferSize = n;
            return this;
        }

        public Builder setCSActiveLevel(int n) {
            SPIDeviceConfig.checkCsActive(n);
            this.instance.csActive = n;
            return this;
        }

        public Builder setBitOrdering(int n) {
            SPIDeviceConfig.checkBitOrdering(n);
            this.instance.bitOrdering = n;
            return this;
        }

        public Builder setClockMode(int n) {
            SPIDeviceConfig.checkClockMode(n);
            this.instance.clockMode = n;
            return this;
        }

        public Builder setWordLength(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.wordLength = n;
            return this;
        }

        public Builder setClockFrequency(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.clockFrequency = n;
            return this;
        }
    }
}

