/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.dio.registry;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

import com.oracle.dio.utils.Logging;

public final class RegistryList {
    private final Vector data;

    public RegistryList() {
        data = new Vector();
    }

    private RegistryList(Vector data) {
        this.data = data;
    }

    public void add(Object element) {
        if (null == element) {
            Logging.reportInformation("RegistryList ignores null element");
            return;
        }
        data.add(element);
    }

    public int size() {
        return data.size();
    }

    public boolean isEmpty() {
        return data.isEmpty();
    }

    public Enumeration<?> elements() {
        return data.elements();
    }

    public Object[] toArray() {
        return data.toArray();
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append('[');
        Enumeration<?> elements = data.elements();
        while (elements.hasMoreElements()) {
            Object element = elements.nextElement();
            if (element instanceof RegistryData) {
                output.append('{');
                output.append(element.toString());
                output.append('}');
            } else {
                output.append('\"');
                output.append(element.toString());
                output.append('\"');
            }
            output.append(',');
        }
        output.append(']');
        return output.toString();
    }

    @Override
    public Object clone() {
        return new RegistryList((Vector)data.clone());
    }
}
