/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.dio.utils;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Logging {

    /** Don't let anyone instantiate this class */
    private Logging() {
    }

    public static void reportError(String message) {
        log(Level.SEVERE, message);
    }

    public static void reportError(String message1, String message2) {
        reportError(message1 + message2);
    }

    public static void reportWarning(String message) {
        log(Level.WARNING, message);
    }

    public static void reportWarning(String message1, String message2) {
        reportWarning(message1 + message2);
    }

    public static void reportInformation(String message) {
        log(Level.INFO, message);
    }

    public static void reportInformation(String message1, String message2) {
        reportInformation(message1 + message2);
    }

    private static void log(Level level, String message) {
        Logger.getLogger("DIO").log(level, message);
    }
}
