/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.gpio.impl;

import com.oracle.dio.gpio.impl.GPIOPinFake;
import com.oracle.dio.impl.AbstractPeripheral;
import com.oracle.dio.impl.EventQueueManager;
import com.oracle.dio.utils.ExceptionMessage;
import java.io.IOException;
import java.security.AccessController;
import jdk.dio.ClosedDeviceException;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.gpio.GPIOPin;
import jdk.dio.gpio.GPIOPinConfig;
import jdk.dio.gpio.GPIOPort;
import jdk.dio.gpio.GPIOPortConfig;
import jdk.dio.gpio.GPIOPortPermission;
import jdk.dio.gpio.PortEvent;
import jdk.dio.gpio.PortListener;

class GPIOPortImpl
extends AbstractPeripheral<GPIOPort>
implements GPIOPort {
    private PortListener listener;
    private int maxVal;
    private GPIOPinFake[] pins;

    public GPIOPortImpl(DeviceDescriptor<GPIOPort> deviceDescriptor, int n) throws DeviceNotFoundException, InvalidDeviceConfigException {
        super(deviceDescriptor, n);
        int n2;
        this.dscr = deviceDescriptor;
        GPIOPortConfig gPIOPortConfig = (GPIOPortConfig)deviceDescriptor.getConfiguration();
        GPIOPortPermission gPIOPortPermission = new GPIOPortPermission(deviceDescriptor.getName() == null ? "" : deviceDescriptor.getName());
        AccessController.checkPermission(gPIOPortPermission);
        GPIOPinConfig[] gPIOPinConfigArray = gPIOPortConfig.getPinConfigs();
        int[][] nArray = new int[gPIOPinConfigArray.length][4];
        for (n2 = 0; n2 < gPIOPinConfigArray.length; ++n2) {
            GPIOPinConfig gPIOPinConfig = gPIOPinConfigArray[n2];
            if (gPIOPinConfig.getControllerName() != null) {
                throw new InvalidDeviceConfigException(ExceptionMessage.format(22, new Object[0]));
            }
            nArray[n2][0] = gPIOPinConfig.getControllerNumber();
            nArray[n2][1] = gPIOPinConfig.getPinNumber();
            nArray[n2][2] = gPIOPinConfig.getDriveMode();
            nArray[n2][3] = gPIOPinConfig.getTrigger();
        }
        this.openPortByConfig0(nArray, gPIOPortConfig.getDirection(), gPIOPortConfig.getInitValue(), n == 1);
        this.maxVal = this.getMaxVal0();
        this.pins = new GPIOPinFake[gPIOPinConfigArray.length];
        for (n2 = 0; n2 < this.pins.length; ++n2) {
            this.pins[n2] = new GPIOPinFake(gPIOPinConfigArray[n2]);
        }
    }

    @Override
    public int getMaxValue() throws ClosedDeviceException {
        this.checkOpen();
        return this.maxVal;
    }

    @Override
    public synchronized void setValue(int n) throws IOException, UnavailableDeviceException {
        this.checkOpen();
        if (n > this.maxVal || 0 > n) {
            throw new IllegalArgumentException();
        }
        if (!this.getOutputMode0()) {
            throw new UnsupportedOperationException(ExceptionMessage.format(58, new Object[0]));
        }
        this.writePort0(n);
    }

    @Override
    public synchronized int getValue() throws IOException, UnavailableDeviceException {
        this.checkOpen();
        return this.readPort0();
    }

    @Override
    public synchronized int getDirection() throws IOException, UnavailableDeviceException {
        this.checkOpen();
        return this.getOutputMode0() ? 1 : 0;
    }

    @Override
    public synchronized void setDirection(int n) throws IOException, UnavailableDeviceException {
        AccessController.checkPermission(new GPIOPortPermission(this.dscr.getName() == null ? "" : this.dscr.getName(), "setdirection"));
        this.checkOpen();
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(56, new Object[0]));
        }
        int n2 = ((GPIOPortConfig)this.getDescriptor().getConfiguration()).getDirection();
        if (1 == n && 0 == n2 || 0 == n && 1 == n2) {
            throw new UnsupportedOperationException(ExceptionMessage.format(57, new Object[0]));
        }
        this.setOutputMode0(1 == n);
    }

    public void processNativeEvent(int n, int n2) {
        PortListener portListener = this.listener;
        if (null != portListener) {
            portListener.valueChanged(new PortEvent(this, n2));
        }
    }

    @Override
    public synchronized void setInputListener(PortListener portListener) throws IOException, UnavailableDeviceException, ClosedDeviceException {
        this.checkOpen();
        if (this.getOutputMode0()) {
            throw new UnsupportedOperationException(ExceptionMessage.format(59, new Object[0]));
        }
        if (null == portListener) {
            EventQueueManager.getInstance().removeEventListener(GPIOPort.class, 0, this);
            if (null != this.listener) {
                try {
                    this.stopNoti0();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.listener = null;
        } else if (null == this.listener) {
            this.listener = portListener;
            try {
                this.startNoti0();
            }
            catch (IOException iOException) {
                this.listener = null;
                throw new UnsupportedOperationException(ExceptionMessage.format(54, new Object[0]));
            }
            EventQueueManager.getInstance().setEventListener(GPIOPort.class, 0, this);
        } else {
            throw new IllegalStateException(ExceptionMessage.format(55, new Object[0]));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            if (null != this.listener) {
                try {
                    this.setInputListener(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (GPIOPinFake gPIOPinFake : this.pins) {
                gPIOPinFake.closeInternal();
            }
            super.close();
        }
    }

    @Override
    public GPIOPin[] getPins() {
        return this.pins;
    }

    private native void openPortByConfig0(int[][] var1, int var2, int var3, boolean var4);

    private native int getMaxVal0();

    private native int readPort0() throws IOException;

    private native void writePort0(int var1) throws IOException;

    private native void setOutputMode0(boolean var1);

    private native boolean getOutputMode0();

    private native void startNoti0() throws IOException;

    private native void stopNoti0() throws IOException;
}

