/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.i2cbus.impl;

import com.oracle.dio.i2cbus.impl.I2CSlaveImpl;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Logging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import jdk.dio.ClosedDeviceException;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.i2cbus.I2CDevice;
import jdk.dio.i2cbus.I2CDeviceConfig;

class I2CCombinedMessage
implements jdk.dio.i2cbus.I2CCombinedMessage {
    ArrayList<Message<I2CSlaveImpl>> messageList = new ArrayList();
    int messageBus = -1;
    boolean isAlreadyTransferedOnce;
    int rxMessageCount;
    int stopConditionIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateAndAppend(Message message) throws ClosedDeviceException {
        ArrayList<Message<I2CSlaveImpl>> arrayList = this.messageList;
        synchronized (arrayList) {
            if (this.isAlreadyTransferedOnce) {
                throw new IllegalStateException(ExceptionMessage.format(61, new Object[0]));
            }
            if (0 > message.skip) {
                throw new IllegalArgumentException(ExceptionMessage.format(62, new Object[0]));
            }
            if (!message.device.isOpen()) {
                throw new ClosedDeviceException();
            }
            int n = ((I2CDeviceConfig)message.device.getDescriptor().getConfiguration()).getControllerNumber();
            if (-1 == this.messageBus) {
                this.messageBus = n;
            } else if (this.messageBus != n) {
                throw new IllegalArgumentException(ExceptionMessage.format(63, new Object[0]));
            }
            if (message.buf.remaining() != 0 || message.skip > 0) {
                boolean bl = false;
                for (Message<I2CSlaveImpl> message2 : this.messageList) {
                    if (message2.buf != message.buf) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.stopConditionIndex = this.messageList.size();
                }
            }
            this.messageList.add(message);
            if (message.isRx) {
                ++this.rxMessageCount;
            }
        }
    }

    I2CCombinedMessage() {
    }

    @Override
    public I2CCombinedMessage appendRead(I2CDevice i2CDevice, ByteBuffer byteBuffer) throws ClosedDeviceException {
        this.validateAndAppend(new Message(this, i2CDevice, byteBuffer, 0, true));
        return this;
    }

    @Override
    public I2CCombinedMessage appendRead(I2CDevice i2CDevice, int n, ByteBuffer byteBuffer) throws IOException, ClosedDeviceException {
        this.validateAndAppend(new Message(this, i2CDevice, byteBuffer, n, true));
        return this;
    }

    @Override
    public I2CCombinedMessage appendWrite(I2CDevice i2CDevice, ByteBuffer byteBuffer) throws IOException, ClosedDeviceException {
        this.validateAndAppend(new Message(this, i2CDevice, byteBuffer, 0, false));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] transfer() throws IOException, UnavailableDeviceException, ClosedDeviceException {
        int[] nArray;
        ArrayList<Message<I2CSlaveImpl>> arrayList = this.messageList;
        synchronized (arrayList) {
            this.isAlreadyTransferedOnce = true;
            if (0 == this.messageList.size()) {
                return null;
            }
            nArray = new int[this.rxMessageCount];
            int n = 0;
            int n2 = this.messageList.size();
            if (1 == n2) {
                Message<I2CSlaveImpl> message = this.messageList.get(0);
                int n3 = message.isRx ? message.skip : -1;
                Logging.reportInformation(ExceptionMessage.format(67, new Object[0]));
                int n4 = ((I2CSlaveImpl)message.device).transfer(0, n3, message.buf);
                if (this.rxMessageCount > 0) {
                    nArray[0] = n4;
                }
            } else {
                int n5 = 1;
                Logging.reportInformation(ExceptionMessage.format(66, new Object[0]));
                HashSet<I2CSlaveImpl> hashSet = new HashSet<I2CSlaveImpl>();
                for (int i = 0; i < this.messageList.size(); ++i) {
                    int n3;
                    Message<I2CSlaveImpl> object = this.messageList.get(i);
                    I2CSlaveImpl i2CSlaveImpl = (I2CSlaveImpl)object.device;
                    hashSet.add(i2CSlaveImpl);
                    int n4 = n3 = object.isRx ? object.skip : -1;
                    if (i == this.stopConditionIndex) {
                        Logging.reportInformation(ExceptionMessage.format(67, new Object[0]));
                        n5 = 2;
                    }
                    int n6 = i2CSlaveImpl.transfer(n5, n3, object.buf);
                    if (object.isRx) {
                        nArray[n++] = n6;
                    }
                    n5 = 3;
                }
                for (I2CSlaveImpl i2CSlaveImpl : hashSet) {
                    i2CSlaveImpl.applyDelayedConversions();
                }
            }
        }
        return nArray;
    }

    private class Message<P extends I2CDevice> {
        public P device;
        public ByteBuffer buf;
        public int skip;
        public boolean isRx;
        final /* synthetic */ I2CCombinedMessage this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Message(P p, ByteBuffer byteBuffer, int n2, boolean bl) {
            this.this$0 = (I2CCombinedMessage)n;
            this.device = p;
            this.buf = byteBuffer;
            this.skip = n2;
            this.isRx = bl;
        }
    }
}

