/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.impl;

import com.oracle.dio.impl.Event;
import com.oracle.dio.impl.EventHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import jdk.dio.Device;

public class EventQueue {
    private final ByteBuffer buffer;
    private final LinkedList<Event> queue = new LinkedList();
    private final ArrayList<Object> listeners = new ArrayList();
    private static final int SHARED_QUEUE_BUFFER_SIZE = 4096;
    private Thread nativeEventThread;
    private Thread eventDispatchThread;

    public Thread getEventDispatchThread() {
        return this.eventDispatchThread;
    }

    private EventQueue(int n) {
        this.buffer = ByteBuffer.allocateDirect(n);
        this.buffer.position(0).limit(0);
        this.startQueue();
        EventQueue.setNativeEntries(this.buffer);
    }

    public static EventQueue getSharedEventQueue() {
        return QueueInstanceHolder.sharedEventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<Event> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(event);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Device> void registerForEvent(Class<T> clazz, EventHandler eventHandler) {
        if (clazz == null || eventHandler == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(clazz);
            this.listeners.add(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Event event) {
        ArrayList<Object> arrayList = this.listeners;
        synchronized (arrayList) {
            for (int i = 0; i < this.listeners.size(); i += 2) {
                if (!this.listeners.get(i).equals(event.getType())) continue;
                EventHandler eventHandler = (EventHandler)this.listeners.get(i + 1);
                eventHandler.handleEvent(event);
            }
        }
    }

    private void startQueue() {
        this.nativeEventThread = new Thread(new NativeMethodThread());
        this.nativeEventThread.setDaemon(true);
        this.nativeEventThread.start();
        this.eventDispatchThread = new Thread(new EventDispatchThread());
        this.eventDispatchThread.setDaemon(true);
        this.eventDispatchThread.start();
    }

    private Class<? extends Device> getEventType(ByteBuffer byteBuffer) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while ('\u0000' != (c = (char)byteBuffer.get())) {
            stringBuilder.append(c);
        }
        try {
            return Class.forName(stringBuilder.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Device.class;
        }
    }

    private static native void setNativeEntries(ByteBuffer var0);

    private class EventDispatchThread
    implements Runnable {
        private EventDispatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Event event = null;
            while (true) {
                LinkedList linkedList = EventQueue.this.queue;
                synchronized (linkedList) {
                    try {
                        if (EventQueue.this.queue.isEmpty()) {
                            EventQueue.this.queue.wait();
                        }
                        event = (Event)EventQueue.this.queue.poll();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (event == null) continue;
                EventQueue.this.dispatch(event);
            }
        }
    }

    private class NativeMethodThread
    implements Runnable {
        private NativeMethodThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer byteBuffer = EventQueue.this.buffer;
            synchronized (byteBuffer) {
                try {
                    while (true) {
                        if (EventQueue.this.buffer.hasRemaining()) {
                            Class clazz = EventQueue.this.getEventType(EventQueue.this.buffer);
                            byte[] byArray = null;
                            short s = EventQueue.this.buffer.getShort();
                            if (s > 0) {
                                byArray = new byte[s];
                                EventQueue.this.buffer.get(byArray);
                            }
                            Event event = new Event(clazz, byArray);
                            EventQueue.this.postEvent(event);
                            continue;
                        }
                        EventQueue.this.buffer.position(0).limit(0);
                        EventQueue.this.buffer.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private static class QueueInstanceHolder {
        private static EventQueue sharedEventQueue = new EventQueue(4096);

        private QueueInstanceHolder() {
        }
    }
}

