/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.impl;

import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Logging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;

public final class Platform {
    private Platform() {
    }

    public static void initialize() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("dio");
                return null;
            }
        });
    }

    public static boolean equals(Object object, Object object2) {
        if (null == object || null == object2) {
            return false;
        }
        try {
            return Platform.serialize(object).equals(Platform.serialize(object2));
        }
        catch (IOException iOException) {
            return object == object2;
        }
    }

    public static Object clone(Object object) {
        try {
            return Platform.deserialize(Platform.serialize(object));
        }
        catch (IOException iOException) {
            Logging.reportWarning(ExceptionMessage.format(24, new Object[0]));
            return object;
        }
    }

    public static Object deserialize(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Invalid InputStream");
        throw new IOException("Platform.deserialize() is not implemented");
    }

    public static int serialize(Object object, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "Invalid OutputStream");
        throw new IOException("Platform.serialize() is not implemented");
    }

    public static int hash(Object object, int n, int n2) {
        try {
            return Platform.serialize(object).hashCode();
        }
        catch (IOException iOException) {
            return System.identityHashCode(object);
        }
    }

    private static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Platform.serialize(object, byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static Object deserialize(byte[] byArray) throws IOException {
        return Platform.deserialize(new ByteArrayInputStream(byArray));
    }
}

