/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.registry;

import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.registry.DeviceRegistryFactory;
import com.oracle.dio.registry.Registry;
import com.oracle.dio.registry.RegistryContent;
import com.oracle.dio.registry.RegistryData;
import com.oracle.dio.registry.RegistryList;
import com.oracle.dio.utils.Configuration;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jdk.dio.Device;
import jdk.dio.DeviceDescriptor;
import jdk.dio.UnsupportedDeviceTypeException;

class RegistryImpl<T extends Device>
extends Registry<T> {
    private static final String REGISTRY_FILE_PATH = "jdk.dio.registry";
    private static final String PREDEFINED = "predefined";
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    protected static final boolean canRegister = true;
    private WeakReference<Properties> registryCache;
    private WeakReference<RegistryContent> contentCache;

    RegistryImpl() {
    }

    @Override
    public synchronized DeviceDescriptor<? super T> get(int n) {
        Properties properties = this.loadRegistry();
        RegistryContent registryContent = this.readRegistryContent(properties);
        return this.createDescriptor(n, registryContent);
    }

    @Override
    public synchronized Iterator<DeviceDescriptor<? super T>> get(String string, Class<T> clazz, String ... stringArray) {
        return this.createDescriptorList(string, clazz, stringArray);
    }

    @Override
    public synchronized int register(PeripheralDescriptorImpl<? super T> peripheralDescriptorImpl) throws UnsupportedOperationException, IOException {
        int n = super.register(peripheralDescriptorImpl);
        Class<T> clazz = peripheralDescriptorImpl.getInterface();
        Properties properties = this.loadRegistry();
        RegistryContent registryContent = this.readRegistryContent(properties);
        String string = DeviceRegistryFactory.registryFactoryName(clazz);
        if (string == null) {
            throw new UnsupportedDeviceTypeException("Unsupported type: " + clazz.getName());
        }
        RegistryData registryData = null;
        try {
            registryData = ((DeviceRegistryFactory)Class.forName(string).newInstance()).createRegistryData(peripheralDescriptorImpl);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new UnsupportedDeviceTypeException("Unsupported type: " + clazz.getName());
        }
        registryContent.put(n, registryData);
        properties.setProperty(Integer.toString(n), registryData.toString());
        try {
            this.saveRegistry(properties);
        }
        catch (Exception exception) {
            registryContent.remove(n);
            properties.remove(Integer.toString(n));
            throw exception;
        }
        return n;
    }

    @Override
    public synchronized DeviceDescriptor unregister(int n) {
        Registry.checkPermission(null, n, "unregister");
        Registry.checkID(n);
        Properties properties = this.loadRegistry();
        RegistryContent registryContent = this.readRegistryContent(properties);
        RegistryData registryData = registryContent.get(n);
        DeviceDescriptor deviceDescriptor = this.createDescriptor(n, registryContent);
        if (registryData == null) {
            return null;
        }
        if (registryData.getBooleanProperty(PREDEFINED, false)) {
            throw new IllegalArgumentException("Device cannot be unregistered");
        }
        registryContent.remove(n);
        properties.remove(Integer.toString(n));
        try {
            this.saveRegistry(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return deviceDescriptor;
    }

    @Override
    public synchronized Iterator<DeviceDescriptor<? super T>> list(Class<T> clazz) {
        return this.createDescriptorList(null, clazz, new String[0]);
    }

    private Properties loadRegistry() {
        Properties properties = null;
        if (this.registryCache != null) {
            properties = (Properties)this.registryCache.get();
        }
        if (properties == null) {
            final Properties properties2 = properties = new Properties();
            final String string = Configuration.getSystemProperty(REGISTRY_FILE_PATH);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        if (string != null) {
                            properties2.load(new InputStreamReader((InputStream)new FileInputStream(string), RegistryImpl.DEFAULT_CHARSET_NAME));
                        }
                    }
                    catch (IOException | IllegalArgumentException | SecurityException exception) {
                        properties2.clear();
                    }
                    return null;
                }
            });
            this.registryCache = new WeakReference<Properties>(properties);
        }
        return properties;
    }

    private void saveRegistry(Properties properties) throws IOException {
        final String string = Configuration.getSystemProperty(REGISTRY_FILE_PATH);
        if (string == null) {
            throw new IOException("Registry is not available");
        }
        final Properties properties2 = properties;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    properties2.store(new OutputStreamWriter((OutputStream)new FileOutputStream(string), RegistryImpl.DEFAULT_CHARSET_NAME), null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private RegistryContent readRegistryContent(Properties properties) {
        RegistryContent registryContent = null;
        if (this.contentCache != null) {
            registryContent = (RegistryContent)this.contentCache.get();
        }
        if (registryContent == null) {
            registryContent = new RegistryContent();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.isEmpty()) continue;
                String string2 = properties.getProperty(string);
                this.processProperty(string, string2, registryContent);
            }
            this.contentCache = new WeakReference<RegistryContent>(registryContent);
        }
        return registryContent;
    }

    private void processProperty(String string, String string2, RegistryContent registryContent) {
        try {
            int n = Integer.parseInt(string);
            this.processEntryProperty(n, string2, registryContent);
        }
        catch (NumberFormatException numberFormatException) {
            this.processTypeProperty(string, string2, registryContent);
        }
    }

    private void processEntryProperty(int n, String string, RegistryContent registryContent) {
        RegistryData registryData = new RegistryData();
        RegistryImpl.parseBlock(string, registryData);
        if (!registryData.isEmpty()) {
            registryContent.put(n, registryData);
        }
    }

    private void processTypeProperty(String string, String string2, RegistryContent registryContent) {
        RegistryData registryData = new RegistryData();
        RegistryImpl.parseBlock(string2, registryData);
        if (!registryData.isEmpty()) {
            registryContent.putType(string, registryData);
        }
    }

    private static void parseBlock(String string, RegistryData registryData) {
        while (true) {
            Object object;
            int n;
            int n2 = 2;
            int n3 = string.indexOf("\\:");
            if (n3 == -1) {
                n2 = 1;
                n3 = string.indexOf(58);
                if (n3 == -1) break;
            }
            String string2 = string.substring(0, n3).trim();
            if ((string = string.substring(n3 + n2).trim()).charAt(0) == '[') {
                n = string.indexOf(93);
                if (n == -1) break;
                object = new RegistryList();
                RegistryImpl.parseList(string.substring(1, n).trim(), (RegistryList)object);
                if (!((RegistryList)object).isEmpty()) {
                    registryData.putListProperty(string2, (RegistryList)object);
                }
                if ((n3 = string.indexOf(44, n + 1)) == -1) break;
                string = string.substring(n3 + 1).trim();
                continue;
            }
            n = string.indexOf(44);
            if (n == -1) {
                object = string;
                string = "";
            } else {
                object = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            }
            if (((String)object).isEmpty()) continue;
            registryData.putCharacterProperty(string2, (String)object);
        }
    }

    private static void parseList(String string, RegistryList registryList) {
        while (!string.isEmpty()) {
            int n;
            Object object;
            int n2;
            if (string.charAt(0) == '{') {
                n2 = string.indexOf(125);
                if (n2 == -1) break;
                object = new RegistryData();
                RegistryImpl.parseBlock(string.substring(1, n2), (RegistryData)object);
                if (!((RegistryData)object).isEmpty()) {
                    registryList.add(object);
                }
                if ((n = string.indexOf(44, n2 + 1)) == -1) break;
                string = string.substring(n + 1).trim();
                continue;
            }
            if (string.charAt(0) != '\"' || (n2 = string.indexOf(34, 1)) == -1) break;
            object = string.substring(1, n2).trim();
            if (!((String)object).isEmpty()) {
                registryList.add(object);
            }
            if ((n = string.indexOf(44, n2)) == -1) break;
            string = string.substring(n + 1).trim();
        }
    }

    private DeviceDescriptor createDescriptor(int n, RegistryContent registryContent) {
        RegistryData registryData = registryContent.get(n);
        if (registryData == null) {
            return null;
        }
        String string = registryData.getCharacterProperty("deviceType");
        if (string == null) {
            return null;
        }
        String string2 = DeviceRegistryFactory.registryFactoryName(string);
        if (string2 == null) {
            return null;
        }
        RegistryData registryData2 = registryContent.getType(string);
        if (registryData2 != null) {
            registryData = registryData.cloneRegistryData();
            Enumeration<String> enumeration = registryData2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (registryData.hasProperty(string3)) continue;
                registryData.copyProperty(string3, registryData2);
            }
        }
        try {
            return ((DeviceRegistryFactory)Class.forName(string2).newInstance()).createDeviceDescriptor(n, registryData);
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            return null;
        }
    }

    private Iterator<DeviceDescriptor<? super T>> createDescriptorList(String string, Class<T> clazz, String ... stringArray) {
        Vector<Object> vector = new Vector<Object>();
        Properties properties = this.loadRegistry();
        RegistryContent registryContent = this.readRegistryContent(properties);
        Enumeration<Integer> enumeration = registryContent.entries();
        while (enumeration.hasMoreElements()) {
            Object object;
            int n = enumeration.nextElement();
            RegistryData registryData = registryContent.get(n);
            if (clazz != null && ((object = registryData.getCharacterProperty("deviceType")) == null || clazz.getName().indexOf((String)object) == -1) || string != null && ((object = registryData.getCharacterProperty("name")) == null || !((String)object).equals(string)) || (object = this.createDescriptor(n, registryContent)) == null) continue;
            if (stringArray != null && stringArray.length > 0) {
                String[] stringArray2 = object.getProperties();
                if (stringArray2 == null || stringArray2.length == 0) continue;
                boolean bl = true;
                block1: for (int i = 0; bl && i < stringArray.length; ++i) {
                    bl = false;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (!stringArray[i].equalsIgnoreCase(stringArray2[j])) continue;
                        bl = true;
                        continue block1;
                    }
                }
                if (!bl) continue;
            }
            vector.add(object);
        }
        return vector.iterator();
    }
}

