/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.uart.impl;

import com.oracle.dio.impl.Event;
import com.oracle.dio.impl.EventHandler;
import com.oracle.dio.impl.EventQueue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdk.dio.uart.ModemUART;

class ModemSignalDispatcher
implements EventHandler {
    private static ModemSignalDispatcher instance;
    private static final int QUEUE_BUFFER_SIZE = 4096;
    private final EventQueue queue = EventQueue.getSharedEventQueue();
    private Map<Long, SerialContext> contextMap = new HashMap<Long, SerialContext>();

    static synchronized ModemSignalDispatcher getInstance() {
        if (instance == null) {
            instance = new ModemSignalDispatcher();
        }
        return instance;
    }

    private ModemSignalDispatcher() {
        this.queue.registerForEvent(ModemUART.class, this);
    }

    private List<SerialSignalListener> getListeners(long l) {
        return this.contextMap.get((Object)Long.valueOf((long)l)).listeners;
    }

    private long getContext(long l) {
        return this.contextMap.get((Object)Long.valueOf((long)l)).context;
    }

    synchronized void addListener(long l, SerialSignalListener serialSignalListener) {
        List<SerialSignalListener> list;
        if (!this.contextMap.containsKey(l)) {
            long l2 = this.startListening(l);
            this.contextMap.put(l, new SerialContext(l2));
        }
        if (!(list = this.getListeners(l)).contains(serialSignalListener)) {
            list.add(serialSignalListener);
        }
    }

    synchronized void removeListener(long l, SerialSignalListener serialSignalListener) {
        if (this.contextMap.containsKey(l)) {
            List<SerialSignalListener> list = this.getListeners(l);
            list.remove(serialSignalListener);
            if (list.isEmpty()) {
                long l2 = this.getContext(l);
                this.stopListening(l2);
                this.contextMap.remove(l);
            }
        }
    }

    private long startListening(long l) {
        return this.startListening0(l);
    }

    private void stopListening(long l) {
        if (l != -1L) {
            this.stopListening0(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Event event) {
        SignalEvent signalEvent = new SignalEvent(event.getPayload());
        long l = signalEvent.getHandler();
        int n = signalEvent.getLine();
        boolean bl = signalEvent.getState();
        ModemSignalDispatcher modemSignalDispatcher = this;
        synchronized (modemSignalDispatcher) {
            List<SerialSignalListener> list = this.getListeners(l);
            Iterator<SerialSignalListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().signalChanged(n, bl);
            }
        }
        return true;
    }

    private native long startListening0(long var1);

    private native void stopListening0(long var1);

    private static class SignalEvent
    extends Event {
        private long handler;
        private int line;
        private boolean state;

        SignalEvent(byte[] byArray) {
            super(ModemUART.class, null);
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.getPayload());
            this.handler = byteBuffer.getLong();
            this.line = byteBuffer.getInt();
            this.state = byteBuffer.get() != 0;
        }

        long getHandler() {
            return this.handler;
        }

        int getLine() {
            return this.line;
        }

        boolean getState() {
            return this.state;
        }
    }

    private static class SerialContext {
        final long context;
        final List<SerialSignalListener> listeners = new ArrayList<SerialSignalListener>();

        SerialContext(long l) {
            this.context = l;
        }
    }

    static interface SerialSignalListener {
        public void signalChanged(int var1, boolean var2);
    }
}

