/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.uart.impl;

import com.oracle.dio.uart.impl.UARTImpl;
import com.oracle.dio.utils.Logging;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

class UARTOptionsHandler {
    private static final String RS485_ENABLE = "jdk.dio.uart.rs485.enable";
    private static final String RS485_RTS_ON_SEND = "jdk.dio.uart.rs485.rts_on_send";

    UARTOptionsHandler() {
    }

    static void processOptions(UARTImpl uARTImpl, String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string.trim()).append('\n');
        }
        try {
            StringReader iOException = new StringReader(stringBuilder.toString());
            Properties properties = new Properties();
            properties.load(iOException);
            if ("true".equals(properties.get(RS485_ENABLE))) {
                int n = "true".equals(properties.get(RS485_RTS_ON_SEND)) ? 1 : 0;
                UARTOptionsHandler.enableRS485(uARTImpl.getHandle().getNativeHandle(), n != 0);
            }
        }
        catch (IOException iOException) {
            Logging.reportError("Can't parse UART options");
        }
    }

    private static native boolean enableRS485(long var0, boolean var2);
}

