/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class Configuration {
    private Configuration() {
    }

    public static String getProperty(String string) {
        return Configuration.getPropertyDefault(string, null);
    }

    public static String getSystemProperty(String string) {
        return Configuration.getPropertyDefault(string, null);
    }

    public static String getPropertyDefault(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    public static int getPositiveIntProperty(String string, int n) {
        int n2 = Configuration.getIntProperty(string, n);
        return n2 > 0 ? n2 : n;
    }

    public static int getNonNegativeIntProperty(String string, int n) {
        int n2 = Configuration.getIntProperty(string, n);
        return n2 >= 0 ? n2 : n;
    }

    public static int getIntProperty(String string, int n) {
        String string2 = Configuration.getPropertyDefault(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static boolean getBoolProperty(String string, boolean bl) {
        String string2 = Configuration.getPropertyDefault(string, null);
        if (string2 != null) {
            try {
                return Boolean.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }
}

