/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.dio.utils;

import com.oracle.dio.utils.ExceptionMessage;
import java.util.StringTokenizer;

public final class Utils {
    public static final int EMPTY = 0;
    public static final int DECIMAL_DIGITS = 1;
    public static final int HEXADECIMAL_DIGITS = 2;
    public static final int HEXADECIMAL_DIGITS_INTERVAL = 3;

    public static boolean implies(String string, String string2) {
        int n = string2.indexOf(",");
        if (n == -1) {
            return Utils.isIncluded(string2, string);
        }
        return Utils.implies(string, string2.substring(0, n)) && Utils.implies(string, string2.substring(n + 1));
    }

    public static String[] getActionsList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static boolean isIncluded(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreElements()) {
            if (!stringTokenizer.nextToken().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidAction(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        boolean bl = true;
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(",")) {
                if (bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            bl = false;
            if (Utils.isIncluded(string3, string2)) continue;
            return false;
        }
        return !bl;
    }

    public static String verifyAndOrderActions(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(ExceptionMessage.format(17, new Object[0]));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(ExceptionMessage.format(19, new Object[0]));
        }
        if (!Utils.isValidAction(string, string2)) {
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(30);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!Utils.isIncluded(string3, string)) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string3);
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String verifyAndOrderDeviceActions(String string) {
        return Utils.verifyAndOrderActions(string, "open,powermanage");
    }

    public static void checkIntZeroOrPozitive(int n) {
        if (-1 >= n) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    public static void checkIntValue(int n) {
        if (-1 > n) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    public static void checkGreaterThanZero(int n) {
        if (-1 != n && n < 1) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
    }

    public static void checkDoubleGreaterThanZero(double d) {
        if (Double.compare(d, 1.0) < 0 || Double.compare(d, Double.NaN) == 0 || Double.compare(d, Double.POSITIVE_INFINITY) == 0) {
            throw new IllegalArgumentException(Double.toString(d));
        }
    }

    public static String[] parseDevicePermissionName(String string) {
        string = string.trim();
        String[] stringArray = new String[2];
        int n = -1;
        while (-1 != (n = string.indexOf(58, n + 1)) && n != 0 && '\\' == string.charAt(n - 1)) {
        }
        if (-1 == n) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    public static void checkDevicePermissionChannelFormat(String string, int n) {
        String string2 = Utils.parseDevicePermissionName(string)[1];
        if (string2.equals("*") || string2.equals("")) {
            return;
        }
        switch (n) {
            case 1: {
                if (Utils.isNonNegativeNumber(string2, 10)) break;
                throw new IllegalArgumentException();
            }
            case 2: {
                if (Utils.isNonNegativeNumber(string2, 16)) break;
                throw new IllegalArgumentException();
            }
            case 3: {
                if (Utils.isNonNegativeNumberInterval(string2)) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public static void checkNewScaledRange(double d, double d2, double d3) {
        block3: {
            block2: {
                double d4 = d * d3;
                double d5 = d2 * d3;
                if (d4 < 1.0) break block2;
                Integer n = new Integer(Integer.MAX_VALUE);
                if (!(d5 > n.doubleValue())) break block3;
            }
            throw new IllegalArgumentException();
        }
    }

    private static boolean isNonNegativeNumber(String string, int n) {
        try {
            return Integer.parseInt(string, n) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isNonNegativeNumberInterval(String string) {
        int n = string.length();
        int n2 = string.indexOf(45);
        if (-1 == n2 || n - 1 <= n2) {
            return false;
        }
        try {
            return Long.parseLong(string.substring(0, n2), 16) >= 0L && Integer.parseInt(string.substring(n2 + 1), 16) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

