/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio;

import apimarker.API;
import com.oracle.dio.impl.PeripheralDescriptorImpl;
import com.oracle.dio.impl.PeripheralFactory;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.registry.RegistrationEventHandler;
import com.oracle.dio.registry.RegistrationEventSender;
import com.oracle.dio.registry.Registry;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Logging;
import com.oracle.dio.utils.PrivilegeController;
import com.oracle.dio.utils.PrivilegedAction;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import jdk.dio.Device;
import jdk.dio.DeviceAlreadyExistsException;
import jdk.dio.DeviceConfig;
import jdk.dio.DeviceDescriptor;
import jdk.dio.DeviceMgmtPermission;
import jdk.dio.DeviceNotFoundException;
import jdk.dio.InvalidDeviceConfigException;
import jdk.dio.RegistrationListener;
import jdk.dio.UnavailableDeviceException;
import jdk.dio.UnsupportedAccessModeException;
import jdk.dio.UnsupportedDeviceTypeException;
import jdk.dio.spi.AbstractDevice;
import jdk.dio.spi.DeviceProvider;

@API(value="device-io_1.1")
public class DeviceManager {
    public static final int EXCLUSIVE = 1;
    public static final int SHARED = 2;
    public static final int UNSPECIFIED_ID = -1;

    public static <P extends Device<? super P>> Iterator<DeviceDescriptor<P>> list() {
        return Registry.getInstance().list(null);
    }

    public static <P extends Device<? super P>> Iterator<DeviceDescriptor<P>> list(Class<P> clazz) {
        clazz.isArray();
        return Registry.getInstance().list(clazz);
    }

    public static <P extends Device<? super P>> P open(Class<P> clazz, DeviceConfig<? super P> deviceConfig) throws IOException, InvalidDeviceConfigException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException {
        return DeviceManager.open(clazz, deviceConfig, 1);
    }

    public static <P extends Device<? super P>> P open(Class<P> clazz, DeviceConfig<? super P> deviceConfig, int n) throws IOException, InvalidDeviceConfigException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        if (null == clazz) {
            throw new NullPointerException(ExceptionMessage.format(1, new Object[0]));
        }
        return DeviceManager.openWithConfig(clazz, deviceConfig, n);
    }

    private static <P extends Device<? super P>> P openWithConfig(Class<P> clazz, DeviceConfig<? super P> deviceConfig, int n) throws IOException, InvalidDeviceConfigException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        if (null == deviceConfig) {
            throw new NullPointerException(ExceptionMessage.format(1, new Object[0]));
        }
        DeviceManager.checkMode(n);
        PeripheralDescriptorImpl<P> peripheralDescriptorImpl = new PeripheralDescriptorImpl<P>(-1, null, deviceConfig, clazz, null);
        if (null != clazz) {
            try {
                return DeviceManager.getFactory(clazz).create(peripheralDescriptorImpl, n);
            }
            catch (DeviceNotFoundException | UnsupportedDeviceTypeException deviceException) {
                P p = DeviceManager.loadFromDriver(peripheralDescriptorImpl, n);
                if (null == p) {
                    throw deviceException;
                }
                return p;
            }
        }
        P p = DeviceManager.loadFromDriver(peripheralDescriptorImpl, n);
        if (null == p) {
            throw new UnsupportedDeviceTypeException(deviceConfig.toString());
        }
        return p;
    }

    public static <P extends Device<? super P>> P open(int n) throws IOException, DeviceNotFoundException, UnavailableDeviceException {
        try {
            return (P)DeviceManager.open(n, Device.class);
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            throw new DeviceNotFoundException(ExceptionMessage.format(2, unsupportedDeviceTypeException.getMessage()));
        }
    }

    public static <P extends Device<? super P>> P open(int n, Class<P> clazz) throws IOException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException {
        try {
            return DeviceManager.open(n, clazz, 1);
        }
        catch (UnsupportedAccessModeException unsupportedAccessModeException) {
            throw new DeviceNotFoundException(ExceptionMessage.format(3, new Object[0]));
        }
    }

    public static <P extends Device<? super P>> P open(int n, Class<P> clazz, int n2) throws IOException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        Registry.checkID(n);
        AccessController.checkPermission(new DeviceMgmtPermission("*:" + n, "open"));
        DeviceManager.checkMode(n2);
        if (null == clazz) {
            throw new NullPointerException(ExceptionMessage.format(4, new Object[0]));
        }
        PeripheralDescriptorImpl peripheralDescriptorImpl = (PeripheralDescriptorImpl)Registry.getInstance().get(n);
        if (null == peripheralDescriptorImpl) {
            throw new DeviceNotFoundException(ExceptionMessage.format(5, String.valueOf(n)));
        }
        if (!clazz.isAssignableFrom(peripheralDescriptorImpl.getInterface())) {
            DeviceManager.getFactory(clazz);
            throw new DeviceNotFoundException(ExceptionMessage.format(6, n, peripheralDescriptorImpl.getInterface()));
        }
        try {
            final PeripheralFactory peripheralFactory = DeviceManager.getFactory(peripheralDescriptorImpl.getInterface());
            final PeripheralDescriptorImpl peripheralDescriptorImpl2 = peripheralDescriptorImpl;
            final int n3 = n2;
            return (P)((Device)PrivilegeController.doPrivileged(new PrivilegedAction<P>(){

                @Override
                public P run() throws IOException {
                    return peripheralFactory.create(peripheralDescriptorImpl2, n3);
                }
            }));
        }
        catch (InvalidDeviceConfigException invalidDeviceConfigException) {
            throw new DeviceNotFoundException(invalidDeviceConfigException.getMessage());
        }
        catch (DeviceNotFoundException | UnsupportedDeviceTypeException deviceException) {
            P p = DeviceManager.loadFromDriver(peripheralDescriptorImpl, n2);
            if (null == p) {
                throw deviceException;
            }
            return p;
        }
    }

    public static <P extends Device<? super P>> P open(int n, int n2) throws IOException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        try {
            return (P)DeviceManager.open(n, Device.class, n2);
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            throw new DeviceNotFoundException(ExceptionMessage.format(2, unsupportedDeviceTypeException.getMessage()));
        }
    }

    public static <P extends Device<? super P>> P open(DeviceConfig<? super P> deviceConfig) throws IOException, InvalidDeviceConfigException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException {
        return DeviceManager.open(deviceConfig, 1);
    }

    public static <P extends Device<? super P>> P open(DeviceConfig<? super P> deviceConfig, int n) throws IOException, InvalidDeviceConfigException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        return DeviceManager.openWithConfig(DeviceManager.getDefaultType(deviceConfig), deviceConfig, n);
    }

    public static <P extends Device<? super P>> P open(String string, Class<P> clazz, int n, String ... stringArray) throws IOException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException, UnsupportedAccessModeException {
        if (null == string && (null == stringArray || 0 == stringArray.length)) {
            throw new IllegalArgumentException(ExceptionMessage.format(7, new Object[0]));
        }
        AccessController.checkPermission(new DeviceMgmtPermission((null == string ? "" : string) + ":*", "open"));
        if (null == clazz) {
            throw new NullPointerException(ExceptionMessage.format(4, new Object[0]));
        }
        DeviceManager.checkMode(n);
        try {
            DeviceManager.getFactory(clazz);
        }
        catch (UnsupportedDeviceTypeException unsupportedDeviceTypeException) {
            DeviceManager.checkWithProviders(clazz);
        }
        Iterator<DeviceDescriptor<P>> iterator = Registry.getInstance().get(string, clazz, stringArray);
        while (iterator.hasNext()) {
            PeripheralDescriptorImpl peripheralDescriptorImpl = (PeripheralDescriptorImpl)iterator.next();
            try {
                final PeripheralFactory peripheralFactory = DeviceManager.getFactory(peripheralDescriptorImpl.getInterface());
                final PeripheralDescriptorImpl peripheralDescriptorImpl2 = peripheralDescriptorImpl;
                final int n2 = n;
                return (P)((Device)PrivilegeController.doPrivileged(new PrivilegedAction<P>(){

                    @Override
                    public P run() throws IOException {
                        return peripheralFactory.create(peripheralDescriptorImpl2, n2);
                    }
                }));
            }
            catch (InvalidDeviceConfigException invalidDeviceConfigException) {
                throw new DeviceNotFoundException(invalidDeviceConfigException.getMessage());
            }
            catch (UnavailableDeviceException unavailableDeviceException) {
                if (iterator.hasNext()) continue;
                throw unavailableDeviceException;
            }
            catch (DeviceNotFoundException | UnsupportedDeviceTypeException deviceException) {
                P p = DeviceManager.loadFromDriver(peripheralDescriptorImpl, n);
                if (null == p) {
                    throw deviceException;
                }
                return p;
            }
        }
        throw new DeviceNotFoundException(string);
    }

    public static <P extends Device<? super P>> P open(String string, Class<P> clazz, String ... stringArray) throws IOException, UnsupportedDeviceTypeException, DeviceNotFoundException, UnavailableDeviceException {
        try {
            return DeviceManager.open(string, clazz, 1, stringArray);
        }
        catch (UnsupportedAccessModeException unsupportedAccessModeException) {
            throw new DeviceNotFoundException(ExceptionMessage.format(3, new Object[0]));
        }
    }

    public static <P extends Device<? super P>> int register(int n, Class<P> clazz, DeviceConfig<? super P> deviceConfig, String string, String ... stringArray) throws IOException, UnsupportedDeviceTypeException, InvalidDeviceConfigException, DeviceNotFoundException, DeviceAlreadyExistsException {
        PeripheralDescriptorImpl<P> peripheralDescriptorImpl = new PeripheralDescriptorImpl<P>(n, string, deviceConfig, clazz, stringArray);
        try {
            P p = DeviceManager.loadFromDriver(peripheralDescriptorImpl, 1);
            Throwable throwable = null;
            if (p != null) {
                if (throwable != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    p.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = Registry.getInstance().register(peripheralDescriptorImpl);
        RegistrationEventSender.notifyRegistered(null, peripheralDescriptorImpl);
        return n2;
    }

    public static void unregister(int n) {
        Registry registry = Registry.getInstance();
        DeviceDescriptor deviceDescriptor = registry.unregister(n);
        if (null != deviceDescriptor) {
            RegistrationEventSender.notifyUnregistered(null, deviceDescriptor);
        }
    }

    public static <P extends Device<? super P>> void addRegistrationListener(RegistrationListener<P> registrationListener, Class<P> clazz) {
        registrationListener.getClass();
        clazz.isArray();
        RegistrationEventHandler.addListener(registrationListener, clazz);
    }

    public static <P extends Device<? super P>> void removeRegistrationListener(RegistrationListener<P> registrationListener, Class<P> clazz) {
        registrationListener.getClass();
        clazz.isArray();
        RegistrationEventHandler.removeListener(registrationListener, clazz);
    }

    private DeviceManager() {
    }

    private static void checkMode(int n) throws UnsupportedAccessModeException {
        if (2 != n && 1 != n) {
            throw new UnsupportedAccessModeException();
        }
    }

    private static <P extends Device<? super P>> Class<P> getDefaultType(DeviceConfig<? super P> deviceConfig) throws UnsupportedDeviceTypeException {
        String string = deviceConfig.getClass().getName();
        if (-1 != string.indexOf("jdk.dio.")) {
            try {
                int n = string.indexOf("Config");
                return Class.forName(string.substring(0, n));
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static PeripheralFactory getFactory(Class clazz) throws UnsupportedDeviceTypeException {
        String string = clazz.getName();
        if (-1 != string.indexOf("jdk.dio.")) {
            int n = string.indexOf(46, "jdk.dio.".length());
            try {
                String string2 = string.substring("jdk.dio.".length(), n);
                String string3 = string.substring(n + 1);
                return (PeripheralFactory)Class.forName("com.oracle.dio." + string2 + ".impl." + string3 + "Factory").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException exception) {
                // empty catch block
            }
        }
        throw new UnsupportedDeviceTypeException(ExceptionMessage.format(12, string));
    }

    private static <P extends Device<? super P>> P loadFromDriver(PeripheralDescriptorImpl<P> peripheralDescriptorImpl, int n) throws DeviceNotFoundException, UnavailableDeviceException, InvalidDeviceConfigException, UnsupportedAccessModeException, IOException {
        ServiceLoader<DeviceProvider> serviceLoader = ServiceLoader.load(DeviceProvider.class);
        Iterator<DeviceProvider> iterator = serviceLoader.iterator();
        Object c = peripheralDescriptorImpl.getConfiguration();
        Class<P> clazz = peripheralDescriptorImpl.getInterface();
        boolean bl = false;
        try {
            if (!iterator.hasNext()) {
                return null;
            }
            while (iterator.hasNext()) {
                DeviceProvider deviceProvider = iterator.next();
                try {
                    if (!deviceProvider.getConfigType().isAssignableFrom(c.getClass()) || null != clazz && !deviceProvider.getType().equals(clazz)) continue;
                    bl = true;
                    if (!deviceProvider.matches(peripheralDescriptorImpl.getProperties())) continue;
                    AbstractDevice abstractDevice = deviceProvider.open(c, peripheralDescriptorImpl.getProperties(), n);
                    peripheralDescriptorImpl.setDeviceProvider(deviceProvider);
                    return (P)abstractDevice;
                }
                catch (SecurityException | InvalidDeviceConfigException | UnavailableDeviceException | UnsupportedAccessModeException exception) {
                    peripheralDescriptorImpl.setDeviceProvider(deviceProvider);
                    throw exception;
                }
                catch (Throwable throwable) {
                    Logging.reportError("Provider " + deviceProvider + " throws " + throwable);
                    bl = true;
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            return null;
        }
        if (bl) {
            throw new DeviceNotFoundException(ExceptionMessage.format(15, new Object[0]));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkWithProviders(Class clazz) throws UnsupportedDeviceTypeException {
        Iterator<DeviceProvider> iterator = ServiceLoader.load(DeviceProvider.class).iterator();
        try {
            while (iterator.hasNext()) {
                DeviceProvider deviceProvider = iterator.next();
                try {
                    if (!deviceProvider.getType().equals(clazz)) continue;
                    return;
                }
                catch (Throwable throwable) {
                }
            }
            throw new UnsupportedDeviceTypeException(ExceptionMessage.format(16, new Object[0]));
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        throw new UnsupportedDeviceTypeException(ExceptionMessage.format(16, new Object[0]));
    }

    static {
        Platform.initialize();
    }
}

