/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio;

import apimarker.API;
import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Utils;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Objects;
import jdk.dio.DevicePermission;

@API(value="device-io_1.1")
public class DeviceMgmtPermission
extends Permission {
    public static final String REGISTER = "register";
    public static final String UNREGISTER = "unregister";
    public static final String OPEN = "open";
    private String myActions;
    private String thisName;
    private int lowID = -1;
    private int highID = -1;

    public DeviceMgmtPermission(String string, String string2) {
        super(string.toString());
        if (null == string2) {
            throw new IllegalArgumentException(ExceptionMessage.format(17, new Object[0]));
        }
        this.checkTargetNameFormat(string);
        this.myActions = Utils.verifyAndOrderActions(string2, "register,unregister,open");
    }

    private void checkTargetNameFormat(String string) {
        String string2;
        Objects.requireNonNull(string, ExceptionMessage.format(18, new Object[0]));
        int n = -1;
        while (-1 != (n = string.indexOf(58, n + 1)) && n != 0 && '\\' == string.charAt(n - 1)) {
        }
        if (-1 == n) {
            this.thisName = string;
            string2 = "";
        } else {
            this.thisName = string.substring(0, n);
            string2 = string.substring(n + 1);
            if ("".equals(string2)) {
                throw new IllegalArgumentException(ExceptionMessage.format(20, new Object[0]));
            }
        }
        if ("*".equals(string2) || "".equals(string2)) {
            this.lowID = 0;
            this.highID = Integer.MAX_VALUE;
        } else {
            n = -1;
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isDigit(c) || '-' != c || bl) continue;
                bl = true;
                break;
            }
            this.lowID = 0;
            this.highID = Integer.MAX_VALUE;
            try {
                if (bl) {
                    n = string2.indexOf(45);
                    if (n > 0) {
                        this.lowID = Integer.parseInt(string2.substring(0, n));
                    }
                    if (n < string2.length() - 1) {
                        this.highID = Integer.parseInt(string2.substring(n + 1));
                    }
                    if (this.lowID > this.highID) {
                        throw new IllegalArgumentException(ExceptionMessage.format(20, new Object[0]));
                    }
                } else {
                    this.lowID = Integer.parseInt(string2);
                    this.highID = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(ExceptionMessage.format(20, new Object[0]));
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return DevicePermission.equals(this, object);
    }

    @Override
    public String getActions() {
        return this.myActions;
    }

    @Override
    public int hashCode() {
        return (this.getName() + this.myActions).hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        if (!Utils.implies(this.myActions, permission.getActions())) {
            return false;
        }
        String string = ((DeviceMgmtPermission)permission).thisName;
        if (!"*".equals(this.thisName) && !this.thisName.equals(string)) {
            return false;
        }
        int n = ((DeviceMgmtPermission)permission).lowID;
        int n2 = ((DeviceMgmtPermission)permission).highID;
        return n >= this.lowID && n <= this.highID && n2 >= this.lowID && n2 <= this.highID;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

