/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio;

import com.oracle.dio.utils.ExceptionMessage;
import com.oracle.dio.utils.Utils;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import jdk.dio.DevicePermission;
import jdk.dio.LocalPermission;

final class PeripheralPermissionCollection
extends PermissionCollection {
    private final Vector<DevicePermission> permissions = new Vector(6);
    private final Class permClazz;

    PeripheralPermissionCollection(Class clazz) {
        this.permClazz = clazz;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!this.permClazz.isInstance(permission)) {
            return false;
        }
        DevicePermission devicePermission = (DevicePermission)permission;
        String[] stringArray = Utils.getActionsList(devicePermission.getActions());
        Enumeration<DevicePermission> enumeration = this.permissions.elements();
        int n = stringArray.length;
        if (n <= 1) {
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().implies(devicePermission)) continue;
                return true;
            }
        } else {
            boolean bl = true;
            for (int i = 0; i < n && bl; ++i) {
                boolean bl2 = false;
                LocalPermission localPermission = new LocalPermission(permission.getName(), stringArray[i]);
                enumeration = this.permissions.elements();
                while (enumeration.hasMoreElements()) {
                    DevicePermission devicePermission2 = enumeration.nextElement();
                    if (!devicePermission2.privateImplies(localPermission)) continue;
                    bl2 = true;
                    break;
                }
                bl = bl && bl2;
            }
            return bl;
        }
        return false;
    }

    @Override
    public void add(Permission permission) {
        if (!this.permClazz.isInstance(permission)) {
            throw new IllegalArgumentException(ExceptionMessage.format(20, permission));
        }
        if (this.isReadOnly()) {
            throw new SecurityException(ExceptionMessage.format(21, new Object[0]));
        }
        this.permissions.addElement((DevicePermission)permission);
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

