/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.adc;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import com.oracle.dio.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.adc.ADCChannel;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_adc")
public final class ADCChannelConfig
implements DeviceConfig<ADCChannel>,
DeviceConfig.HardwareAddressing {
    private String controllerName;
    private int channelNumber = -1;
    private int controllerNumber = -1;
    private int resolution = -1;
    private int samplingInterval = -1;
    private int samplingTime = -1;
    private long scaleFactor = 0x3FF0000000000000L;
    private int inputBufferSize = -1;

    @DontRenameMethod
    ADCChannelConfig() {
    }

    @Deprecated
    public ADCChannelConfig(int n, int n2, int n3, int n4, int n5) {
        this.controllerNumber = n;
        this.channelNumber = n2;
        this.resolution = n3;
        this.samplingInterval = n4;
        this.samplingTime = n5;
        this.checkValues();
    }

    @Deprecated
    public ADCChannelConfig(String string, int n, int n2, int n3, int n4) {
        this.controllerName = string;
        this.channelNumber = n;
        this.resolution = n2;
        this.samplingInterval = n3;
        this.samplingTime = n4;
        string.length();
        this.checkValues();
    }

    public static ADCChannelConfig deserialize(InputStream inputStream) throws IOException {
        return (ADCChannelConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }

    public int getSamplingTime() {
        return this.samplingTime;
    }

    public double getScaleFactor() {
        return Double.longBitsToDouble(this.scaleFactor);
    }

    public int hashCode() {
        return Platform.hash(this, 7, 97);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }

    private void checkValues() throws IllegalArgumentException {
        Utils.checkIntValue(this.controllerNumber);
        Utils.checkIntValue(this.channelNumber);
        Utils.checkGreaterThanZero(this.resolution);
        Utils.checkGreaterThanZero(this.samplingInterval);
        Utils.checkGreaterThanZero(this.samplingTime);
    }

    @API(value="device-io_1.1_adc")
    public static final class Builder {
        private final ADCChannelConfig instance = new ADCChannelConfig();

        public ADCChannelConfig build() {
            return (ADCChannelConfig)Platform.clone(this.instance);
        }

        public Builder setControllerName(String string) {
            this.instance.controllerName = string;
            return this;
        }

        public Builder setChannelNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.channelNumber = n;
            return this;
        }

        public Builder setControllerNumber(int n) {
            Utils.checkIntValue(n);
            this.instance.controllerNumber = n;
            return this;
        }

        public Builder setResolution(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.resolution = n;
            return this;
        }

        public Builder setSamplingInterval(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.samplingInterval = n;
            return this;
        }

        public Builder setSamplingTime(int n) {
            Utils.checkGreaterThanZero(n);
            this.instance.samplingTime = n;
            return this;
        }

        public Builder setScaleFactor(double d) {
            Utils.checkDoubleGreaterThanZero(d);
            this.instance.scaleFactor = Double.doubleToLongBits(d);
            return this;
        }

        public Builder setInputBufferSize(int n) {
            Utils.checkIntValue(n);
            this.instance.inputBufferSize = n;
            return this;
        }
    }
}

