/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.atcmd;

import apimarker.API;
import com.oracle.dio.impl.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jdk.dio.DeviceConfig;
import jdk.dio.atcmd.ATDevice;
import romizer.DontRenameMethod;
import serializator.SerializeMe;

@SerializeMe
@API(value="device-io_1.1_atcmd")
public final class ATDeviceConfig
implements DeviceConfig<ATDevice>,
DeviceConfig.HardwareAddressing {
    private String controllerName;
    private int controllerNumber = -1;
    private int channelNumber = -1;

    @DontRenameMethod
    ATDeviceConfig() {
    }

    public ATDeviceConfig(String string, int n) {
        this(-1, n);
        string.length();
        this.controllerName = string;
    }

    public ATDeviceConfig(int n, int n2) {
        if (-1 > n2 || -1 > n) {
            throw new IllegalArgumentException();
        }
        this.controllerNumber = n;
        this.channelNumber = n2;
    }

    public static ATDeviceConfig deserialize(InputStream inputStream) throws IOException {
        return (ATDeviceConfig)Platform.deserialize(inputStream);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return Platform.serialize(this, outputStream);
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    @Override
    public int getControllerNumber() {
        return this.controllerNumber;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public int hashCode() {
        return Platform.hash(this, 3, 79);
    }

    public boolean equals(Object object) {
        return Platform.equals(this, object);
    }
}

