/*
 * Decompiled with CFR 0.152.
 */
package jdk.dio.uart;

import apimarker.API;
import jdk.dio.DeviceEvent;
import jdk.dio.uart.UART;

@API(value="device-io_1.1_uart")
public class UARTEvent
extends DeviceEvent<UART> {
    public static final int INPUT_BUFFER_OVERRUN = 1;
    public static final int INPUT_DATA_AVAILABLE = 0;
    public static final int OUTPUT_BUFFER_EMPTY = 2;
    public static final int BREAK_INTERRUPT = 4;
    public static final int PARITY_ERROR = 8;
    public static final int FRAMING_ERROR = 16;
    private int id;

    public UARTEvent(UART uART, int n) {
        this(uART, n, System.currentTimeMillis(), 0);
    }

    public UARTEvent(UART uART, int n, long l, int n2) {
        if (null == uART) {
            throw new NullPointerException();
        }
        if (n != 0 && n != 1 && n != 2 && n != 4 && n != 16 && n != 8) {
            throw new IllegalArgumentException();
        }
        if (l < 0L || n2 < 0 || n2 > 999) {
            throw new IllegalArgumentException();
        }
        this.device = uART;
        this.id = n;
        this.timeStamp = l;
        this.timeStampMicros = n2;
        this.count = 1;
    }

    public int getID() {
        return this.id;
    }
}

