/*
 * Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.dio.utils;

public final class Constants {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String PREFIX = "jdk.dio.";
    public static final String FACTORY_PREFIX = "com.oracle.dio.";
    public static final String FACTORY = "Factory";
    public static final String CONFIG = "Config";
    public static final long INVALID_HANDLE = -1;
    public static final String PATH = "controllerName";
    public static final String IMPL = ".impl.";
    public static final String TYPE = "type";
    public static final String DIRECTION= "direction";
    public static final String INIT_VALUE = "initValue";
    public static final int MAX_WORD_LEN = 32;
    public static final String DEVICE_NUMBER = "controllerNumber";
    public static final String CHANNEL_NUMBER = "channelNumber";
    public static final String PROPERTIES = "properties";
    public static final String RESOLUTION = "resolution";
    public static final String SAMPLING_INTERVAL = "samplingInterval";
    public static final String ADDRESS = "address";
    public static final String CLOCK_FREQUENCY = "clockFrequency";
    public static final String SCALE_FACTOR = "scaleFactor";
}
