/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package test.robot.javafx.scene.layout;

import org.junit.jupiter.api.Test;

/**
 */
public class RegionBorderStrokeUITest extends RegionUITestBase {

    @Test public void dummy() {

    }
//    /**************************************************************************
//     *                                                                        *
//     * Tests for a color filled stroke                                        *
//     *                                                                        *
//     *************************************************************************/
//
//--    public void color_BorderWidth_Thin(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thin;" +
//--                        "-fx-border-color: red;");
//--    }
//
//    public void color_BorderWidth_Thin1(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 1;" +
//                        "-fx-border-color: red;");
//    }
//
//--    public void color_BorderWidth_Medium(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: medium;" +
//--                        "-fx-border-color: red;");
//--    }
//
//    public void color_BorderWidth_Medium2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 3;" +
//                        "-fx-border-color: red;");
//    }
//
//--    public void color_BorderWidth_Thick(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thick;" +
//--                        "-fx-border-color: red;");
//--    }
//
//    public void color_BorderWidth_Thick2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_Solid(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_SolidLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_Dashed(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DasheddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DashedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_Dotted(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DotteddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_Style_DottedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: red;");
//    }
//
//    public void color_MultipleInsetBorders(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red, green, blue;" +
//                        "-fx-border-width: 5, 10, 15;" +
//                        "-fx-border-insets: 0, 5, 15;");
//    }
//
//    public void color_UniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void color_NonuniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 25 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
//
//    public void color_NonuniformBorderWidths_uniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red;" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void color_NonuniformBorderWidths_nonuniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red;" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
//
//    /**************************************************************************
//     *                                                                        *
//     * Tests for an image-pattern filled stroke                               *
//     *                                                                        *
//     *************************************************************************/
//
//--    public void image_BorderWidth_Thin(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thin;" +
//--                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//--    }
//
//    public void image_BorderWidth_Thin1(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 1;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//--    public void image_BorderWidth_Medium(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: medium;" +
//--                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//--    }
//
//    public void image_BorderWidth_Medium2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 3;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//--    public void image_BorderWidth_Thick(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thick;" +
//--                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//--    }
//
//    public void image_BorderWidth_Thick2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_Solid(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_SolidLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_Dashed(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DasheddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DashedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_Dotted(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DotteddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_Style_DottedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');");
//    }
//
//    public void image_MultipleInsetBorders(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: red, green, blue;" +
//                        "-fx-border-width: 5, 10, 15;" +
//                        "-fx-border-insets: 0, 5, 15;");
//    }
//
//    public void image_UniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void image_NonuniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 25 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
//
//    public void image_NonuniformBorderWidths_uniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void image_NonuniformBorderWidths_nonuniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: repeating-image-pattern('test/robot/javafx/scene/layout/test20x20.png');" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
//
//    /**************************************************************************
//     *                                                                        *
//     * Tests for a linear filled stroke                                       *
//     *                                                                        *
//     *************************************************************************/
//
//--    public void linear_BorderWidth_Thin(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thin;" +
//--                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//--    }
//
//    public void linear_BorderWidth_Thin1(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 1;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//--    public void linear_BorderWidth_Medium(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: medium;" +
//--                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//--    }
//
//    public void linear_BorderWidth_Medium2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 3;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//--    public void linear_BorderWidth_Thick(Region region) {
//--        region.setStyle("-fx-background-color: lightgrey;" +
//--                        "-fx-border-style: solid;" +
//--                        "-fx-border-width: thick;" +
//--                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//--    }
//
//    public void linear_BorderWidth_Thick2(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_Solid(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_SolidLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_Dashed(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DasheddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DashedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dashed line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_Dotted(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedPhase5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted phase 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedCentered(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted centered;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedInside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted inside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedOutside(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted outside;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DotteddLineJoinBevel(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join bevel;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedLineJoinRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedLineJoinMiter5(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-join miter 5;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedLineCapSquare(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap square;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedLineCapButt(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap butt;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_Style_DottedLineCapRound(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: dotted line-cap round;" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);");
//    }
//
//    public void linear_MultipleInsetBorders(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%), green, blue;" +
//                        "-fx-border-width: 5, 10, 15;" +
//                        "-fx-border-insets: 0, 5, 15;");
//    }
//
//    public void linear_UniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void linear_NonuniformBorderRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 25 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);" +
//                        "-fx-border-width: 5;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
//
//    public void linear_NonuniformBorderWidths_uniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15;");
//    }
//
//    public void linear_NonuniformBorderWidths_nonuniformRadius(Region region) {
//        region.setStyle("-fx-background-color: lightgrey;" +
//                        "-fx-background-radius: 15 20 25 30;" +
//                        "-fx-border-style: solid;" +
//                        "-fx-border-color: linear-gradient(to bottom, red 0%, blue 100%);" +
//                        "-fx-border-width: 5 10 15 20;" +
//                        "-fx-border-radius: 15 20 25 30;");
//    }
}
