/*
 * Copyright (C) 2005, 2006, 2008 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "CompositeEditCommand.h"

namespace WebCore {

class EditingStyle;

class InsertParagraphSeparatorCommand : public CompositeEditCommand {
public:
    static Ref<InsertParagraphSeparatorCommand> create(Ref<Document>&& document, bool useDefaultParagraphElement = false, bool pasteBlockqutoeIntoUnquotedArea = false, EditAction editingAction = EditAction::Insert)
    {
        return adoptRef(*new InsertParagraphSeparatorCommand(WTFMove(document), useDefaultParagraphElement, pasteBlockqutoeIntoUnquotedArea, editingAction));
    }

private:
    InsertParagraphSeparatorCommand(Ref<Document>&&, bool useDefaultParagraphElement, bool pasteBlockqutoeIntoUnquotedArea, EditAction);

    void doApply() override;

    void calculateStyleBeforeInsertion(const Position&);
    void applyStyleAfterInsertion(Node* originalEnclosingBlock);
    void getAncestorsInsideBlock(const Node* insertionNode, Element* outerBlock, Vector<RefPtr<Element>>& ancestors);
    Ref<Element> cloneHierarchyUnderNewBlock(const Vector<RefPtr<Element>>& ancestors, Ref<Element>&& blockToInsert);

    bool shouldUseDefaultParagraphElement(Node*) const;

    bool preservesTypingStyle() const override;

    RefPtr<EditingStyle> protectedStyle() const { return m_style; }

    RefPtr<EditingStyle> m_style;

    bool m_mustUseDefaultParagraphElement;
    bool m_pasteBlockqutoeIntoUnquotedArea;
};

} // namespace WebCore
