/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.Arrays;
import java.util.Set;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDS
implements EmbeddedSceneDSInterface {
    private final EmbeddedSceneDnD dnd;
    private final ClipboardAssistance assistant;
    private final GlassSceneDnDEventHandler dndHandler;

    public EmbeddedSceneDS(EmbeddedSceneDnD dnd, ClipboardAssistance assistant, GlassSceneDnDEventHandler dndHandler) {
        this.dnd = dnd;
        this.assistant = assistant;
        this.dndHandler = dndHandler;
    }

    @Override
    public Set<TransferMode> getSupportedActions() {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> QuantumClipboard.clipboardActionsToTransferModes(this.assistant.getSupportedSourceActions()));
    }

    @Override
    public Object getData(String mimeType) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> this.assistant.getData(mimeType));
    }

    @Override
    public String[] getMimeTypes() {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> this.assistant.getMimeTypes());
    }

    @Override
    public boolean isMimeTypeAvailable(String mimeType) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(() -> Arrays.asList(this.assistant.getMimeTypes()).contains(mimeType));
    }

    @Override
    public void dragDropEnd(TransferMode performedAction) {
        assert (this.dnd.isHostThread());
        this.dnd.executeOnFXThread(() -> {
            try {
                this.dndHandler.handleDragEnd(performedAction, this.assistant);
            }
            finally {
                this.dnd.onDragSourceReleased(this);
            }
            return null;
        });
    }
}

