/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.ContextMenu;
import com.sun.webkit.Pasteboard;
import com.sun.webkit.PopupMenu;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.reflect.misc.MethodUtil;

public abstract class Utilities {
    private static Utilities instance;
    private static final Set<String> classMethodsWhitelist;
    private static final Set<String> classesBlacklist;
    private static final List<String> packagesBlacklist;

    public static synchronized void setUtilities(Utilities util) {
        instance = util;
    }

    public static synchronized Utilities getUtilities() {
        return instance;
    }

    protected abstract Pasteboard createPasteboard();

    protected abstract PopupMenu createPopupMenu();

    protected abstract ContextMenu createContextMenu();

    private static final Set<String> asSet(String ... items) {
        return new HashSet<String>(Arrays.asList(items));
    }

    private static Object fwkInvokeWithContext(Method method, Object instance, Object[] args, Object accObj) throws Throwable {
        AccessControlContext acc = (AccessControlContext)accObj;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.equals(Class.class)) {
            if (!classMethodsWhitelist.contains(method.getName())) {
                throw new UnsupportedOperationException("invocation not supported");
            }
        } else {
            String className = clazz.getName();
            if (classesBlacklist.contains(className)) {
                throw new UnsupportedOperationException("invocation not supported");
            }
            packagesBlacklist.forEach(packageName -> {
                if (className.startsWith(packageName + ".")) {
                    throw new UnsupportedOperationException("invocation not supported");
                }
            });
        }
        try {
            return AccessController.doPrivileged(() -> MethodUtil.invoke(method, instance, args), acc);
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            } else if (cause instanceof InvocationTargetException && cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw cause;
        }
    }

    static {
        classMethodsWhitelist = Utilities.asSet("getCanonicalName", "getEnumConstants", "getFields", "getMethods", "getName", "getPackageName", "getSimpleName", "getSuperclass", "getTypeName", "getTypeParameters", "isAssignableFrom", "isArray", "isEnum", "isInstance", "isInterface", "isLocalClass", "isMemberClass", "isPrimitive", "isSynthetic", "toGenericString", "toString");
        classesBlacklist = Utilities.asSet("java.lang.ClassLoader", "java.lang.Module", "java.lang.Runtime", "java.lang.System");
        packagesBlacklist = Arrays.asList("java.lang.invoke", "java.lang.module", "java.lang.reflect", "java.security", "sun.misc");
    }
}

