/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.web.NGWebView;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.InputMethodClientImpl;
import com.sun.javafx.webkit.KeyCodeMap;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCFocusEvent;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.event.WCKeyEvent;
import com.sun.webkit.event.WCMouseEvent;
import com.sun.webkit.event.WCMouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class WebView
extends Parent {
    private static final Map<Object, Integer> idMap = new HashMap<Object, Integer>();
    private static final boolean DEFAULT_CONTEXT_MENU_ENABLED = true;
    private static final FontSmoothingType DEFAULT_FONT_SMOOTHING_TYPE = FontSmoothingType.LCD;
    private static final double DEFAULT_ZOOM = 1.0;
    private static final double DEFAULT_FONT_SCALE = 1.0;
    private static final double DEFAULT_MIN_WIDTH = 0.0;
    private static final double DEFAULT_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_PREF_WIDTH = 800.0;
    private static final double DEFAULT_PREF_HEIGHT = 600.0;
    private static final double DEFAULT_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_MAX_HEIGHT = Double.MAX_VALUE;
    private final WebPage page;
    private final WebEngine engine;
    private volatile InputMethodClientImpl imClient;
    private final TKPulseListener stagePulseListener;
    private final ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width");
    private final ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper(this, "height");
    private DoubleProperty zoom;
    private DoubleProperty fontScale;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private BooleanProperty contextMenuEnabled;
    private static final int WK_DND_ACTION_NONE = 0;
    private static final int WK_DND_ACTION_COPY = 1;
    private static final int WK_DND_ACTION_MOVE = 2;
    private static final int WK_DND_ACTION_LINK = 0x40000000;

    public final WebEngine getEngine() {
        return this.engine;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getHeight() {
        return this.height.get();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    public final void setZoom(double value) {
        WebEngine.checkThread();
        this.zoomProperty().set(value);
    }

    public final double getZoom() {
        return this.zoom != null ? this.zoom.get() : 1.0;
    }

    public final DoubleProperty zoomProperty() {
        if (this.zoom == null) {
            this.zoom = new StyleableDoubleProperty(1.0){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setZoomFactor((float)this.get(), false);
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.ZOOM;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "zoom";
                }
            };
        }
        return this.zoom;
    }

    public final void setFontScale(double value) {
        WebEngine.checkThread();
        this.fontScaleProperty().set(value);
    }

    public final double getFontScale() {
        return this.fontScale != null ? this.fontScale.get() : 1.0;
    }

    public DoubleProperty fontScaleProperty() {
        if (this.fontScale == null) {
            this.fontScale = new StyleableDoubleProperty(1.0){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setZoomFactor((float)this.get(), true);
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.FONT_SCALE;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "fontScale";
                }
            };
        }
        return this.fontScale;
    }

    public WebView() {
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.getStyleClass().add("web-view");
        this.engine = new WebEngine();
        this.engine.setView(this);
        this.page = this.engine.getPage();
        this.page.setFontSmoothingType(DEFAULT_FONT_SMOOTHING_TYPE.ordinal());
        this.registerEventHandlers();
        this.stagePulseListener = () -> this.handleStagePulse();
        this.focusedProperty().addListener((ov, t, t1) -> {
            if (this.page != null) {
                WCFocusEvent focusEvent = new WCFocusEvent(this.isFocused() ? 2 : 3, -1);
                this.page.dispatchFocusEvent(focusEvent);
            }
        });
        this.setFocusTraversable(true);
        Toolkit.getToolkit().addStageTkPulseListener(this.stagePulseListener);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double width, double height) {
        if (width != this.width.get() || height != this.height.get()) {
            this.width.set(width);
            this.height.set(height);
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            this.impl_geomChanged();
        }
    }

    @Override
    public final double minWidth(double height) {
        double result = this.getMinWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public final double minHeight(double width) {
        double result = this.getMinHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public final double prefWidth(double height) {
        double result = this.getPrefWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public final double prefHeight(double width) {
        double result = this.getPrefHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public final double maxWidth(double height) {
        double result = this.getMaxWidth();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    @Override
    public final double maxHeight(double width) {
        double result = this.getMaxHeight();
        return Double.isNaN(result) || result < 0.0 ? 0.0 : result;
    }

    public DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new StyleableDoubleProperty(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MIN_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double value) {
        this.minWidthProperty().set(value);
    }

    public final double getMinWidth() {
        return this.minWidth != null ? this.minWidth.get() : 0.0;
    }

    public DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new StyleableDoubleProperty(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MIN_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double value) {
        this.minHeightProperty().set(value);
    }

    public final double getMinHeight() {
        return this.minHeight != null ? this.minHeight.get() : 0.0;
    }

    public void setMinSize(double minWidth, double minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new StyleableDoubleProperty(800.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.PREF_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double value) {
        this.prefWidthProperty().set(value);
    }

    public final double getPrefWidth() {
        return this.prefWidth != null ? this.prefWidth.get() : 800.0;
    }

    public DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new StyleableDoubleProperty(600.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.PREF_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double value) {
        this.prefHeightProperty().set(value);
    }

    public final double getPrefHeight() {
        return this.prefHeight != null ? this.prefHeight.get() : 600.0;
    }

    public void setPrefSize(double prefWidth, double prefHeight) {
        this.setPrefWidth(prefWidth);
        this.setPrefHeight(prefHeight);
    }

    public DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MAX_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double value) {
        this.maxWidthProperty().set(value);
    }

    public final double getMaxWidth() {
        return this.maxWidth != null ? this.maxWidth.get() : Double.MAX_VALUE;
    }

    public DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public CssMetaData<WebView, Number> getCssMetaData() {
                    return StyleableProperties.MAX_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double value) {
        this.maxHeightProperty().set(value);
    }

    public final double getMaxHeight() {
        return this.maxHeight != null ? this.maxHeight.get() : Double.MAX_VALUE;
    }

    public void setMaxSize(double maxWidth, double maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    public final void setFontSmoothingType(FontSmoothingType value) {
        this.fontSmoothingTypeProperty().set(value);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType != null ? (FontSmoothingType)((Object)this.fontSmoothingType.get()) : DEFAULT_FONT_SMOOTHING_TYPE;
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(DEFAULT_FONT_SMOOTHING_TYPE){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setFontSmoothingType(((FontSmoothingType)((Object)this.get())).ordinal());
                }

                @Override
                public CssMetaData<WebView, FontSmoothingType> getCssMetaData() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "fontSmoothingType";
                }
            };
        }
        return this.fontSmoothingType;
    }

    public final void setContextMenuEnabled(boolean value) {
        this.contextMenuEnabledProperty().set(value);
    }

    public final boolean isContextMenuEnabled() {
        return this.contextMenuEnabled == null ? true : this.contextMenuEnabled.get();
    }

    public final BooleanProperty contextMenuEnabledProperty() {
        if (this.contextMenuEnabled == null) {
            this.contextMenuEnabled = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setContextMenuEnabled(this.get());
                }

                @Override
                public CssMetaData<WebView, Boolean> getCssMetaData() {
                    return StyleableProperties.CONTEXT_MENU_ENABLED;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "contextMenuEnabled";
                }
            };
        }
        return this.contextMenuEnabled;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return WebView.getClassCssMetaData();
    }

    private boolean isTreeReallyVisible() {
        if (this.getScene() == null) {
            return false;
        }
        Window window = this.getScene().getWindow();
        if (window == null) {
            return false;
        }
        boolean iconified = window instanceof Stage ? ((Stage)window).isIconified() : false;
        return this.impl_isTreeVisible() && window.isShowing() && window.getWidth() > 0.0 && window.getHeight() > 0.0 && !iconified;
    }

    private void handleStagePulse() {
        if (this.page == null) {
            return;
        }
        boolean reallyVisible = this.isTreeReallyVisible();
        if (reallyVisible) {
            if (this.page.isDirty()) {
                Scene.impl_setAllowPGAccess(true);
                NGWebView peer = (NGWebView)this.impl_getPeer();
                peer.update();
                if (this.page.isRepaintPending()) {
                    this.impl_markDirty(DirtyBits.WEBVIEW_VIEW);
                }
                Scene.impl_setAllowPGAccess(false);
            }
        } else {
            this.page.dropRenderFrames();
        }
    }

    private void processMouseEvent(MouseEvent ev) {
        Integer id;
        if (this.page == null) {
            return;
        }
        EventType<? extends MouseEvent> type = ev.getEventType();
        double x = ev.getX();
        double y = ev.getY();
        double screenX = ev.getScreenX();
        double screenY = ev.getScreenY();
        if (type == MouseEvent.MOUSE_EXITED) {
            type = MouseEvent.MOUSE_MOVED;
            x = -32768.0;
            y = -32768.0;
            Point2D screenPoint = this.localToScreen(x, y);
            if (screenPoint == null) {
                return;
            }
            screenX = screenPoint.getX();
            screenY = screenPoint.getY();
        }
        if ((id = idMap.get(type)) == null) {
            return;
        }
        int buttonMask = (ev.isPrimaryButtonDown() ? 1 : 0) | (ev.isMiddleButtonDown() ? 2 : 0) | (ev.isSecondaryButtonDown() ? 4 : 0);
        WCMouseEvent mouseEvent = new WCMouseEvent(id, idMap.get((Object)ev.getButton()), ev.getClickCount(), (int)x, (int)y, (int)screenX, (int)screenY, System.currentTimeMillis(), ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), ev.isPopupTrigger(), buttonMask);
        this.page.dispatchMouseEvent(mouseEvent);
        ev.consume();
    }

    private void processScrollEvent(ScrollEvent ev) {
        if (this.page == null) {
            return;
        }
        double dx = -ev.getDeltaX() * this.getFontScale() * this.getScaleX();
        double dy = -ev.getDeltaY() * this.getFontScale() * this.getScaleY();
        WCMouseWheelEvent wheelEvent = new WCMouseWheelEvent((int)ev.getX(), (int)ev.getY(), (int)ev.getScreenX(), (int)ev.getScreenY(), System.currentTimeMillis(), ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), (float)dx, (float)dy);
        this.page.dispatchMouseWheelEvent(wheelEvent);
        ev.consume();
    }

    private void processKeyEvent(KeyEvent ev) {
        if (this.page == null) {
            return;
        }
        String text = null;
        String keyIdentifier = null;
        int windowsVirtualKeyCode = 0;
        if (ev.getEventType() == KeyEvent.KEY_TYPED) {
            text = ev.getCharacter();
        } else {
            KeyCodeMap.Entry keyCodeEntry = KeyCodeMap.lookup(ev.getCode());
            keyIdentifier = keyCodeEntry.getKeyIdentifier();
            windowsVirtualKeyCode = keyCodeEntry.getWindowsVirtualKeyCode();
        }
        WCKeyEvent keyEvent = new WCKeyEvent(idMap.get(ev.getEventType()), text, keyIdentifier, windowsVirtualKeyCode, ev.isShiftDown(), ev.isControlDown(), ev.isAltDown(), ev.isMetaDown(), System.currentTimeMillis());
        if (this.page.dispatchKeyEvent(keyEvent)) {
            ev.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputMethodClientImpl getInputMethodClient() {
        if (this.imClient == null) {
            WebView webView = this;
            synchronized (webView) {
                if (this.imClient == null) {
                    this.imClient = new InputMethodClientImpl(this, this.page);
                }
            }
        }
        return this.imClient;
    }

    private void processInputMethodEvent(InputMethodEvent ie) {
        if (this.page == null) {
            return;
        }
        if (!this.getInputMethodClient().getInputMethodState()) {
            ie.consume();
            return;
        }
        WCInputMethodEvent imEvent = InputMethodClientImpl.convertToWCInputMethodEvent(ie);
        if (this.page.dispatchInputMethodEvent(imEvent)) {
            ie.consume();
            return;
        }
    }

    private static int getWKDndEventType(EventType et) {
        int commandId = 0;
        if (et == DragEvent.DRAG_ENTERED) {
            commandId = 0;
        } else if (et == DragEvent.DRAG_EXITED) {
            commandId = 3;
        } else if (et == DragEvent.DRAG_OVER) {
            commandId = 1;
        } else if (et == DragEvent.DRAG_DROPPED) {
            commandId = 4;
        }
        return commandId;
    }

    private static int getWKDndAction(TransferMode ... tms) {
        int dndActionId = 0;
        for (TransferMode tm : tms) {
            if (tm == TransferMode.COPY) {
                dndActionId |= 1;
                continue;
            }
            if (tm == TransferMode.MOVE) {
                dndActionId |= 2;
                continue;
            }
            if (tm != TransferMode.LINK) continue;
            dndActionId |= 0x40000000;
        }
        return dndActionId;
    }

    private static TransferMode[] getFXDndAction(int wkDndAction) {
        LinkedList<TransferMode> tms = new LinkedList<TransferMode>();
        if ((wkDndAction & 1) != 0) {
            tms.add(TransferMode.COPY);
        }
        if ((wkDndAction & 2) != 0) {
            tms.add(TransferMode.MOVE);
        }
        if ((wkDndAction & 0x40000000) != 0) {
            tms.add(TransferMode.LINK);
        }
        return tms.toArray(new TransferMode[0]);
    }

    private void registerEventHandlers() {
        this.addEventHandler(KeyEvent.ANY, event -> this.processKeyEvent((KeyEvent)event));
        this.addEventHandler(MouseEvent.ANY, event -> {
            this.processMouseEvent((MouseEvent)event);
            if (event.isDragDetect() && !this.page.isDragConfirmed()) {
                event.setDragDetect(false);
            }
        });
        this.addEventHandler(ScrollEvent.SCROLL, event -> this.processScrollEvent((ScrollEvent)event));
        this.setOnInputMethodTextChanged(event -> this.processInputMethodEvent((InputMethodEvent)event));
        EventHandler<DragEvent> destHandler = event -> {
            try {
                Dragboard db = event.getDragboard();
                LinkedList<String> mimes = new LinkedList<String>();
                LinkedList<String> values = new LinkedList<String>();
                for (DataFormat df : db.getContentTypes()) {
                    Object content = db.getContent(df);
                    if (content == null) continue;
                    for (String mime : df.getIdentifiers()) {
                        mimes.add(mime);
                        values.add(content.toString());
                    }
                }
                if (!mimes.isEmpty()) {
                    int wkDndEventType = WebView.getWKDndEventType(event.getEventType());
                    int wkDndAction = this.page.dispatchDragOperation(wkDndEventType, mimes.toArray(new String[0]), values.toArray(new String[0]), (int)event.getX(), (int)event.getY(), (int)event.getScreenX(), (int)event.getScreenY(), WebView.getWKDndAction(db.getTransferModes().toArray(new TransferMode[0])));
                    if (wkDndEventType != 4 || wkDndAction != 0) {
                        event.acceptTransferModes(WebView.getFXDndAction(wkDndAction));
                    }
                    event.consume();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        };
        this.setOnDragEntered(destHandler);
        this.setOnDragExited(destHandler);
        this.setOnDragOver(destHandler);
        this.setOnDragDropped(destHandler);
        this.setOnDragDetected(event -> {
            if (this.page.isDragConfirmed()) {
                this.page.confirmStartDrag();
                event.consume();
            }
        });
        this.setOnDragDone(event -> {
            this.page.dispatchDragOperation(104, null, null, (int)event.getX(), (int)event.getY(), (int)event.getScreenX(), (int)event.getScreenY(), WebView.getWKDndAction(event.getAcceptedTransferMode()));
            event.consume();
        });
        this.setInputMethodRequests(this.getInputMethodClient());
    }

    @Override
    @Deprecated
    protected void impl_pickNodeLocal(PickRay pickRay, PickResultChooser result) {
        this.impl_intersects(pickRay, result);
    }

    @Override
    protected ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGWebView();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        bounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), 0.0f);
        tx.transform(bounds, bounds);
        return bounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double localX, double localY) {
        return true;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        NGWebView peer = (NGWebView)this.impl_getPeer();
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            peer.setPage(this.page);
        }
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            peer.resize((float)this.getWidth(), (float)this.getHeight());
        }
        if (this.impl_isDirty(DirtyBits.WEBVIEW_VIEW)) {
            peer.requestRender();
        }
    }

    static /* synthetic */ FontSmoothingType access$1200() {
        return DEFAULT_FONT_SMOOTHING_TYPE;
    }

    static {
        idMap.put((Object)MouseButton.NONE, 0);
        idMap.put((Object)MouseButton.PRIMARY, 1);
        idMap.put((Object)MouseButton.MIDDLE, 2);
        idMap.put((Object)MouseButton.SECONDARY, 4);
        idMap.put(MouseEvent.MOUSE_PRESSED, 0);
        idMap.put(MouseEvent.MOUSE_RELEASED, 1);
        idMap.put(MouseEvent.MOUSE_MOVED, 2);
        idMap.put(MouseEvent.MOUSE_DRAGGED, 3);
        idMap.put(KeyEvent.KEY_PRESSED, 1);
        idMap.put(KeyEvent.KEY_RELEASED, 2);
        idMap.put(KeyEvent.KEY_TYPED, 0);
    }

    private static final class StyleableProperties {
        private static final CssMetaData<WebView, Boolean> CONTEXT_MENU_ENABLED = new CssMetaData<WebView, Boolean>("-fx-context-menu-enabled", BooleanConverter.getInstance(), Boolean.valueOf(true)){

            @Override
            public boolean isSettable(WebView view) {
                return view.contextMenuEnabled == null || !view.contextMenuEnabled.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.contextMenuEnabledProperty());
            }
        };
        private static final CssMetaData<WebView, FontSmoothingType> FONT_SMOOTHING_TYPE = new CssMetaData<WebView, FontSmoothingType>("-fx-font-smoothing-type", new EnumConverter<FontSmoothingType>(FontSmoothingType.class), WebView.access$1200()){

            @Override
            public boolean isSettable(WebView view) {
                return view.fontSmoothingType == null || !view.fontSmoothingType.isBound();
            }

            @Override
            public StyleableProperty<FontSmoothingType> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.fontSmoothingTypeProperty());
            }
        };
        private static final CssMetaData<WebView, Number> ZOOM = new CssMetaData<WebView, Number>("-fx-zoom", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.zoom == null || !view.zoom.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.zoomProperty());
            }
        };
        private static final CssMetaData<WebView, Number> FONT_SCALE = new CssMetaData<WebView, Number>("-fx-font-scale", SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.fontScale == null || !view.fontScale.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.fontScaleProperty());
            }
        };
        private static final CssMetaData<WebView, Number> MIN_WIDTH = new CssMetaData<WebView, Number>("-fx-min-width", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.minWidth == null || !view.minWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.minWidthProperty());
            }
        };
        private static final CssMetaData<WebView, Number> MIN_HEIGHT = new CssMetaData<WebView, Number>("-fx-min-height", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.minHeight == null || !view.minHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.minHeightProperty());
            }
        };
        private static final CssMetaData<WebView, Number> MAX_WIDTH = new CssMetaData<WebView, Number>("-fx-max-width", SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(WebView view) {
                return view.maxWidth == null || !view.maxWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.maxWidthProperty());
            }
        };
        private static final CssMetaData<WebView, Number> MAX_HEIGHT = new CssMetaData<WebView, Number>("-fx-max-height", SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(WebView view) {
                return view.maxHeight == null || !view.maxHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.maxHeightProperty());
            }
        };
        private static final CssMetaData<WebView, Number> PREF_WIDTH = new CssMetaData<WebView, Number>("-fx-pref-width", SizeConverter.getInstance(), (Number)800.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.prefWidth == null || !view.prefWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.prefWidthProperty());
            }
        };
        private static final CssMetaData<WebView, Number> PREF_HEIGHT = new CssMetaData<WebView, Number>("-fx-pref-height", SizeConverter.getInstance(), (Number)600.0){

            @Override
            public boolean isSettable(WebView view) {
                return view.prefHeight == null || !view.prefHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(WebView view) {
                return (StyleableProperty)((Object)view.prefHeightProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            styleables.add(CONTEXT_MENU_ENABLED);
            styleables.add(FONT_SMOOTHING_TYPE);
            styleables.add(ZOOM);
            styleables.add(FONT_SCALE);
            styleables.add(MIN_WIDTH);
            styleables.add(PREF_WIDTH);
            styleables.add(MAX_WIDTH);
            styleables.add(MIN_HEIGHT);
            styleables.add(PREF_HEIGHT);
            styleables.add(MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

