/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.jmx.json.impl;

import com.oracle.javafx.jmx.json.JSONException;
import com.oracle.javafx.jmx.json.impl.JSONMessages;
import com.oracle.javafx.jmx.json.impl.JSONSymbol;
import java.io.IOException;
import java.io.Reader;

final class JSONScanner {
    private Reader reader;
    private String value;
    private int prevChar;
    private int x;
    private int y = 1;
    private int checkpointX;
    private int checkpointY;
    private long offset;
    private boolean isInt;

    JSONScanner(Reader reader) throws IOException {
        this.reader = reader;
        this.offset = 0L;
        this.prevChar = reader.read();
    }

    JSONSymbol nextSymbol() throws JSONException, IOException {
        JSONSymbol s;
        int ch = this.prevChar;
        while (ch != -1 && (ch == 32 || ch == 9 || ch == 12 || ch == 10 || ch == 13)) {
            ch = this.readChar(true);
        }
        this.value = null;
        switch (ch) {
            case -1: {
                s = JSONSymbol.EOS;
                this.prevChar = -1;
                break;
            }
            case 123: {
                s = JSONSymbol.CURLYOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 125: {
                s = JSONSymbol.CURLYCLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 91: {
                s = JSONSymbol.SQUAREOPEN;
                this.prevChar = this.readChar(true);
                break;
            }
            case 93: {
                s = JSONSymbol.SQUARECLOSE;
                this.prevChar = this.readChar(true);
                break;
            }
            case 58: {
                s = JSONSymbol.COLON;
                this.prevChar = this.readChar(true);
                break;
            }
            case 44: {
                s = JSONSymbol.COMMA;
                this.prevChar = this.readChar(true);
                break;
            }
            case 116: {
                this.readKeyword("true");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 102: {
                this.readKeyword("false");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 110: {
                this.readKeyword("null");
                s = JSONSymbol.KEYWORD;
                break;
            }
            case 34: {
                this.value = this.readString();
                s = JSONSymbol.STRING;
                break;
            }
            case 45: {
                this.value = this.readNumber(ch);
                s = JSONSymbol.NUMBER;
                break;
            }
            default: {
                if (ch >= 48 && ch <= 57) {
                    this.value = this.readNumber(ch);
                    s = JSONSymbol.NUMBER;
                    break;
                }
                Object[] args = new Object[]{Character.valueOf((char)ch)};
                throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
            }
        }
        return s;
    }

    String getValue() {
        return this.value;
    }

    private void readKeyword(String text) throws JSONException, IOException {
        int i;
        int ch = 0;
        for (i = 1; i < text.length() && (ch = this.readChar(false)) == text.charAt(i); ++i) {
        }
        if (i < text.length()) {
            Object[] args = new Object[]{Character.valueOf((char)ch)};
            throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
        }
        this.value = text;
        this.prevChar = this.readChar(true);
    }

    private String readString() throws JSONException, IOException {
        int ch;
        StringBuilder val = new StringBuilder();
        do {
            ch = this.readChar(false);
            block0 : switch (ch) {
                case -1: {
                    throw new JSONException(JSONMessages.localize(null, "unexpected_end_of_stream"), this.line(), this.column());
                }
                case 92: {
                    int ch2 = this.readChar(false);
                    switch (ch2) {
                        case 34: 
                        case 47: 
                        case 92: {
                            val.append((char)ch2);
                            break block0;
                        }
                        case 98: {
                            val.append('\b');
                            break block0;
                        }
                        case 102: {
                            val.append('\f');
                            break block0;
                        }
                        case 110: {
                            val.append('\n');
                            break block0;
                        }
                        case 114: {
                            val.append('\r');
                            break block0;
                        }
                        case 116: {
                            val.append('\t');
                            break block0;
                        }
                        case 117: {
                            int unicode = 0;
                            int i = 4;
                            while (--i >= 0) {
                                ch2 = this.readChar(false);
                                unicode = (char)(unicode << 4);
                                if (ch2 >= 48 && ch2 <= 57) {
                                    unicode = (char)(unicode | (char)ch2 - 48);
                                    continue;
                                }
                                if (ch2 >= 97 && ch2 <= 102) {
                                    unicode = (char)(unicode | (char)ch2 - 97 + 10);
                                    continue;
                                }
                                if (ch2 >= 65 && ch2 <= 70) {
                                    unicode = (char)(unicode | (char)ch2 - 65 + 10);
                                    continue;
                                }
                                Object[] args = new Object[]{Character.valueOf((char)ch2)};
                                throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
                            }
                            val.append((char)(unicode & 0xFFFF));
                            break block0;
                        }
                    }
                    Object[] args = new Object[]{Character.valueOf((char)ch2)};
                    throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
                }
                case 34: {
                    break;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 127 && ch <= 159) {
                        throw new JSONException(JSONMessages.localize(null, "control_character_in_string"), this.line(), this.column());
                    }
                    val.append((char)ch);
                }
            }
        } while (ch != 34);
        this.prevChar = this.readChar(true);
        return val.toString();
    }

    private String readNumber(int prefetch) throws JSONException, IOException {
        int count;
        int ch = prefetch;
        StringBuilder val = new StringBuilder();
        val.append((char)ch);
        if (ch == 45) {
            ch = this.readChar(true);
            val.append((char)ch);
            if (ch < 48 || ch > 57) {
                Object[] args = new Object[]{Character.valueOf((char)ch)};
                throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
            }
        }
        this.isInt = true;
        if (ch == 48) {
            ch = this.readChar(true);
            val.append((char)ch);
        } else {
            do {
                ch = this.readChar(true);
                val.append((char)ch);
            } while (ch >= 48 && ch <= 57);
        }
        if (ch == 46) {
            this.isInt = false;
            count = 0;
            do {
                ch = this.readChar(true);
                val.append((char)ch);
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                Object[] args = new Object[]{Character.valueOf((char)ch)};
                throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
            }
        }
        if (ch == 101 || ch == 69) {
            this.isInt = false;
            ch = this.readChar(false);
            val.append((char)ch);
            if (ch == 43 || ch == 45) {
                ch = this.readChar(false);
                val.append((char)ch);
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                ch = this.readChar(true);
                val.append((char)ch);
                ++count;
            }
            if (count == 0) {
                Object[] args = new Object[]{Character.valueOf((char)ch)};
                throw new JSONException(JSONMessages.localize(args, "unexpected_char"), this.line(), this.column());
            }
        }
        this.prevChar = ch;
        return val.toString().substring(0, val.length() - 1);
    }

    private int readChar(boolean checkpoint) throws IOException {
        int ch = this.reader.read();
        if (checkpoint) {
            this.checkpointX = this.x;
            this.checkpointY = this.y;
        }
        if (ch == 10) {
            ++this.y;
            this.x = 0;
        } else {
            ++this.x;
        }
        ++this.offset;
        return ch;
    }

    boolean isInteger() {
        return this.isInt;
    }

    void close() throws IOException {
        this.reader.close();
    }

    int line() {
        return this.y;
    }

    int column() {
        return this.x;
    }

    long getCharacterOffset() {
        return this.offset;
    }

    public String toString() {
        return this.y + ":" + this.x + (this.offset >= 0L ? "@" + this.offset : "");
    }
}

