/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm;

import sun.jvm.hotspot.asm.InstructionVisitor;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;

public class Disassembler {
    private static String options = "";
    private static long decode_function;
    protected long startPc;
    protected byte[] code;
    private CodeBlob blob;
    private NMethod nmethod;

    public static void decode(InstructionVisitor visitor, CodeBlob blob) {
        Disassembler.decode(visitor, blob, blob.codeBegin(), blob.codeEnd());
    }

    public static void decode(InstructionVisitor visitor, CodeBlob blob, Address begin, Address end) {
        int codeSize = (int)end.minus(begin);
        long startPc = VM.getAddressValue(begin);
        byte[] code = new byte[codeSize];
        for (int i = 0; i < code.length; ++i) {
            code[i] = begin.getJByteAt(i);
        }
        Disassembler dis = new Disassembler(startPc, code);
        dis.decode(visitor);
    }

    private Disassembler(long startPc, byte[] code) {
        this.startPc = startPc;
        this.code = code;
        if (decode_function == 0L) {
            StringBuilder path = new StringBuilder(System.getProperty("java.home"));
            String sep = System.getProperty("file.separator");
            String os = System.getProperty("os.name");
            String libname = "hsdis";
            String arch = System.getProperty("os.arch");
            if (os.lastIndexOf("Windows", 0) != -1) {
                libname = arch.equals("x86") ? libname + "-i386" : (arch.equals("amd64") ? libname + "-amd64" : libname + "-" + arch);
                path.append(sep + "bin" + sep);
                libname = libname + ".dll";
            } else if (os.lastIndexOf("SunOS", 0) != -1) {
                if (arch.equals("x86") || arch.equals("i386")) {
                    path.append(sep + "lib" + sep + "i386" + sep);
                    libname = libname + "-i386.so";
                } else if (arch.equals("amd64")) {
                    path.append(sep + "lib" + sep + "amd64" + sep);
                    libname = libname + "-amd64.so";
                } else {
                    path.append(sep + "lib" + sep + arch + sep);
                    libname = libname + "-" + arch + ".so";
                }
            } else if (os.lastIndexOf("Linux", 0) != -1) {
                if (arch.equals("x86") || arch.equals("i386")) {
                    path.append(sep + "lib" + sep + "i386" + sep);
                    libname = libname + "-i386.so";
                } else if (arch.equals("amd64") || arch.equals("x86_64")) {
                    path.append(sep + "lib" + sep + "amd64" + sep);
                    libname = libname + "-amd64.so";
                } else {
                    path.append(sep + "lib" + sep + arch + sep);
                    libname = libname + "-" + arch + ".so";
                }
            } else if (os.lastIndexOf("Mac OS X", 0) != -1) {
                path.append(sep + "lib" + sep);
                libname = arch.equals("amd64") || arch.equals("x86_64") ? libname + "-amd64.dylib" : libname + "-" + arch + ".dylib";
            } else {
                path.append(sep + "lib" + sep + "arch" + sep);
                libname = libname + "-" + arch + ".so";
            }
            decode_function = Disassembler.load_library(path.toString(), libname);
        }
    }

    private static native long load_library(String var0, String var1);

    private native void decode(InstructionVisitor var1, long var2, byte[] var4, String var5, long var6);

    private void decode(InstructionVisitor visitor) {
        visitor.prologue();
        this.decode(visitor, this.startPc, this.code, options, decode_function);
        visitor.epilogue();
    }

    private boolean match(String event, String tag) {
        if (!event.startsWith(tag)) {
            return false;
        }
        int taglen = tag.length();
        if (taglen == event.length()) {
            return true;
        }
        char delim = event.charAt(taglen);
        return delim == ' ' || delim == '/' || delim == '=';
    }

    private long handleEvent(InstructionVisitor visitor, String event, long arg) {
        if (this.match(event, "insn")) {
            try {
                visitor.beginInstruction(arg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (this.match(event, "/insn")) {
            try {
                visitor.endInstruction(arg);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            if (this.match(event, "addr")) {
                if (arg != 0L) {
                    visitor.printAddress(arg);
                }
                return arg;
            }
            if (this.match(event, "mach")) {
                // empty if block
            }
        }
        return 0L;
    }

    private void rawPrint(InstructionVisitor visitor, String s) {
        visitor.print(s);
    }
}

