/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.AbstractShadow;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.GaussianShadow;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxShadowState;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;

public class BoxShadow
extends AbstractShadow {
    private final BoxShadowState state = new BoxShadowState();

    public BoxShadow() {
        this(1, 1);
    }

    public BoxShadow(int hsize, int vsize) {
        this(hsize, vsize, 1, DefaultInput);
    }

    public BoxShadow(int hsize, int vsize, int passes) {
        this(hsize, vsize, passes, DefaultInput);
    }

    public BoxShadow(int hsize, int vsize, int passes, Effect input) {
        super(input);
        this.setHorizontalSize(hsize);
        this.setVerticalSize(vsize);
        this.setPasses(passes);
        this.setColor(Color4f.BLACK);
        this.setSpread(0.0f);
    }

    @Override
    LinearConvolveKernel getState() {
        return this.state;
    }

    @Override
    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    @Override
    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getHorizontalSize() {
        return this.state.getHsize();
    }

    public final void setHorizontalSize(int hsize) {
        this.state.setHsize(hsize);
    }

    public int getVerticalSize() {
        return this.state.getVsize();
    }

    public final void setVerticalSize(int vsize) {
        this.state.setVsize(vsize);
    }

    public int getPasses() {
        return this.state.getBlurPasses();
    }

    public final void setPasses(int passes) {
        this.state.setBlurPasses(passes);
    }

    @Override
    public Color4f getColor() {
        return this.state.getShadowColor();
    }

    @Override
    public final void setColor(Color4f color) {
        this.state.setShadowColor(color);
    }

    @Override
    public float getSpread() {
        return this.state.getSpread();
    }

    @Override
    public final void setSpread(float spread) {
        this.state.setSpread(spread);
    }

    @Override
    public float getGaussianRadius() {
        float d = (float)(this.getHorizontalSize() + this.getVerticalSize()) / 2.0f;
        return (d *= 3.0f) < 1.0f ? 0.0f : (d - 1.0f) / 2.0f;
    }

    @Override
    public float getGaussianWidth() {
        return (float)this.getHorizontalSize() * 3.0f;
    }

    @Override
    public float getGaussianHeight() {
        return (float)this.getVerticalSize() * 3.0f;
    }

    @Override
    public void setGaussianRadius(float r) {
        float d = r * 2.0f + 1.0f;
        this.setGaussianWidth(d);
        this.setGaussianHeight(d);
    }

    @Override
    public void setGaussianWidth(float w) {
        this.setHorizontalSize(Math.round(w /= 3.0f));
    }

    @Override
    public void setGaussianHeight(float h) {
        this.setVerticalSize(Math.round(h /= 3.0f));
    }

    @Override
    public AbstractShadow.ShadowMode getMode() {
        switch (this.getPasses()) {
            case 1: {
                return AbstractShadow.ShadowMode.ONE_PASS_BOX;
            }
            case 2: {
                return AbstractShadow.ShadowMode.TWO_PASS_BOX;
            }
        }
        return AbstractShadow.ShadowMode.THREE_PASS_BOX;
    }

    @Override
    public AbstractShadow implFor(AbstractShadow.ShadowMode mode) {
        switch (mode) {
            case GAUSSIAN: {
                GaussianShadow gs = new GaussianShadow();
                gs.setInput(this.getInput());
                gs.setGaussianWidth(this.getGaussianWidth());
                gs.setGaussianHeight(this.getGaussianHeight());
                gs.setColor(this.getColor());
                gs.setSpread(this.getSpread());
                return gs;
            }
            case ONE_PASS_BOX: {
                this.setPasses(1);
                break;
            }
            case TWO_PASS_BOX: {
                this.setPasses(2);
                break;
            }
            case THREE_PASS_BOX: {
                this.setPasses(3);
            }
        }
        return this;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return Renderer.getRenderer(fctx).getAccelType();
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseBounds r = super.getBounds(null, defaultInput);
        int hgrow = this.state.getKernelSize(0) / 2;
        int vgrow = this.state.getKernelSize(1) / 2;
        RectBounds ret = new RectBounds(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
        ret.grow(hgrow, vgrow);
        return BoxShadow.transformBounds(transform, ret);
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        Rectangle r = inputDatas[0].getUntransformedBounds();
        r = this.state.getResultBounds(r, 0);
        r = this.state.getResultBounds(r, 1);
        r.intersectWith(outputClip);
        return r;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        drc.grow(this.state.getKernelSize(0) / 2, this.state.getKernelSize(1) / 2);
        return drc;
    }
}

