/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.jnlp.JNLPBundler;
import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JSCallback;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DeployParams
extends CommonParams {
    final List<RelativeFileSet> resources = new ArrayList<RelativeFileSet>();
    String id;
    String title;
    String vendor;
    String email;
    String description;
    String category;
    String licenseType;
    String copyright;
    String version;
    Boolean systemWide;
    Boolean serviceHint;
    Boolean signBundle;
    Boolean installdirChooser;
    String applicationClass;
    String preloader;
    List<Param> params;
    List<HtmlParam> htmlParams;
    List<String> arguments;
    int width;
    int height;
    String embeddedWidth = null;
    String embeddedHeight = null;
    String appName;
    String codebase;
    boolean embedJNLP = true;
    @Deprecated
    final boolean embedCertificates = false;
    boolean allPermissions = false;
    String updateMode = "background";
    boolean isExtension = false;
    boolean isSwingApp = false;
    Boolean needShortcut = null;
    Boolean needMenu = null;
    boolean needInstall = false;
    String outfile;
    boolean includeDT;
    String placeholder = "'javafx-app-placeholder'";
    String appId = null;
    boolean offlineAllowed = true;
    List<JSCallback> callbacks;
    List<Template> templates = new LinkedList<Template>();
    String jrePlatform = "1.6+";
    String fxPlatform = "8.0+";
    File javaRuntimeToUse = null;
    boolean javaRuntimeWasSet = false;
    List<String> jvmargs = new LinkedList<String>();
    Map<String, String> jvmUserArgs = new LinkedHashMap<String, String>();
    Map<String, String> properties = new LinkedHashMap<String, String>();
    Map<String, ? super Object> bundlerArguments = new LinkedHashMap<String, Object>();
    String fallbackApp = null;
    List<Icon> icons = new LinkedList<Icon>();
    Bundler.BundleType bundleType = Bundler.BundleType.NONE;
    String targetFormat = null;
    static final Set<String> multi_args = new TreeSet<String>(Arrays.asList(StandardBundlerParam.JVM_PROPERTIES.getID(), StandardBundlerParam.JVM_OPTIONS.getID(), StandardBundlerParam.USER_JVM_OPTIONS.getID(), StandardBundlerParam.ARGUMENTS.getID()));

    public void setJavaRuntimeSource(File src) {
        this.javaRuntimeToUse = src;
        this.javaRuntimeWasSet = true;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSystemWide(Boolean systemWide) {
        this.systemWide = systemWide;
    }

    public void setServiceHint(Boolean serviceHint) {
        this.serviceHint = serviceHint;
    }

    public void setInstalldirChooser(Boolean installdirChooser) {
        this.installdirChooser = installdirChooser;
    }

    public void setSignBundle(Boolean signBundle) {
        this.signBundle = signBundle;
    }

    public void setJRE(String v) {
        this.jrePlatform = v;
    }

    public void setSwingAppWithEmbeddedJavaFX(boolean v) {
        this.isSwingApp = v;
    }

    public void setNeedInstall(boolean b) {
        this.needInstall = b;
    }

    public void setOfflineAllowed(boolean b) {
        this.offlineAllowed = b;
    }

    public void setNeedShortcut(Boolean b) {
        this.needShortcut = b;
    }

    public void setNeedMenu(Boolean b) {
        this.needMenu = b;
    }

    public void setEmbeddedDimensions(String w, String h) {
        this.embeddedWidth = w;
        this.embeddedHeight = h;
    }

    public void setFallback(String v) {
        if (v == null) {
            return;
        }
        this.fallbackApp = "none".equals(v) || "null".equals(v) ? null : v;
    }

    public void setJavafx(String v) {
        this.fxPlatform = v;
    }

    public void addJvmArg(String v) {
        this.jvmargs.add(v);
    }

    public void addJvmUserArg(String n, String v) {
        this.jvmUserArgs.put(n, v);
    }

    public void addJvmProperty(String n, String v) {
        this.properties.put(n, v);
    }

    public void setAllPermissions(boolean allPermissions) {
        this.allPermissions = allPermissions;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setArguments(List<String> args) {
        this.arguments = args;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEmbedJNLP(boolean embedJNLP) {
        this.embedJNLP = embedJNLP;
    }

    @Deprecated
    public void setEmbedCertifcates(boolean v) {
        if (v) {
            System.out.println("JavaFX Packager no longer supports embedding certificates in JNLP files.  Setting will be ignored.");
        }
    }

    public void setPlaceholder(String p) {
        this.placeholder = p;
    }

    public void setAppId(String id) {
        this.appId = id;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHtmlParams(List<HtmlParam> htmlParams) {
        this.htmlParams = htmlParams;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public void setPreloader(String preloader) {
        this.preloader = preloader;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = updateMode;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setExtension(boolean isExtension) {
        this.isExtension = isExtension;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setIncludeDT(boolean doEmbed) {
        this.includeDT = doEmbed;
    }

    public void setJSCallbacks(List<JSCallback> list) {
        this.callbacks = list;
    }

    public void setCallbacks(List<Callback> list) {
        ArrayList<JSCallback> jslist = new ArrayList<JSCallback>(list.size());
        for (Callback cb : list) {
            jslist.add(new JSCallback(cb.getName(), cb.getCmd()));
        }
        this.callbacks = jslist;
    }

    public void addTemplate(File in, File out) {
        this.templates.add(new Template(in, out));
    }

    List<File> expandFileset(File root) {
        LinkedList<File> files = new LinkedList<File>();
        if (IOUtils.isNotSymbolicLink(root)) {
            if (root.isDirectory()) {
                File[] children = root.listFiles();
                if (children != null) {
                    for (File f : children) {
                        files.addAll(this.expandFileset(f));
                    }
                }
            } else {
                files.add(root);
            }
        }
        return files;
    }

    @Override
    public void addResource(File baseDir, String path) {
        File file = new File(baseDir, path);
        file = file.getAbsoluteFile();
        if (baseDir == null) {
            baseDir = file.getParentFile();
        }
        this.resources.add(new RelativeFileSet(baseDir, (Set<File>)new LinkedHashSet<File>(this.expandFileset(file))));
    }

    @Override
    public void addResource(File baseDir, File file) {
        file = file.getAbsoluteFile();
        if (baseDir == null) {
            baseDir = file.getParentFile();
        }
        this.resources.add(new RelativeFileSet(baseDir, (Set<File>)new LinkedHashSet<File>(this.expandFileset(file))));
    }

    public void addResource(File baseDir, String path, String type) {
        this.addResource(baseDir, DeployParams.createFile(baseDir, path), type);
    }

    public void addResource(File baseDir, File file, String type) {
        this.addResource(baseDir, file, "eager", type, null, null);
    }

    public void addResource(File baseDir, File file, String mode, String type, String os, String arch) {
        LinkedHashSet<File> singleFile = new LinkedHashSet<File>();
        singleFile.add(file);
        if (baseDir == null) {
            baseDir = file.getParentFile();
        }
        RelativeFileSet rfs = new RelativeFileSet(baseDir, (Set<File>)singleFile);
        rfs.setArch(arch);
        rfs.setMode(mode);
        rfs.setOs(os);
        rfs.setType(this.parseTypeFromString(type, file));
        this.resources.add(rfs);
    }

    private RelativeFileSet.Type parseTypeFromString(String type, File file) {
        if (type == null) {
            if (file.getName().endsWith(".jar")) {
                return RelativeFileSet.Type.jar;
            }
            if (file.getName().endsWith(".jnlp")) {
                return RelativeFileSet.Type.jnlp;
            }
            return RelativeFileSet.Type.UNKNOWN;
        }
        return RelativeFileSet.Type.valueOf(type);
    }

    private static File createFile(File baseDir, String path) {
        File testFile = new File(path);
        return testFile.isAbsolute() ? testFile : new File(baseDir == null ? null : baseDir.getAbsolutePath(), path);
    }

    public static void validateAppName(String s) throws PackagerException {
        if (s == null || s.length() == 0) {
            return;
        }
        int last = s.length() - 1;
        char fc = s.charAt(0);
        char lc = s.charAt(last);
        if (lc == '\\') {
            throw new PackagerException("ERR_InvalidCharacterInArgument", "-name");
        }
        for (int i = 0; i < s.length(); ++i) {
            char a = s.charAt(i);
            if ((a < ' ' || a > '~' || a == '%') && (Character.isISOControl(a) || Character.isWhitespace(a) || a == '%')) {
                throw new PackagerException("ERR_InvalidCharacterInArgument", "-name");
            }
            if (a != '\"') continue;
            throw new PackagerException("ERR_InvalidCharacterInArgument", "-name");
        }
    }

    @Override
    public void validate() throws PackagerException {
        if (this.outdir == null) {
            throw new PackagerException("ERR_MissingArgument", "-outdir");
        }
        if (this.outfile == null) {
            throw new PackagerException("ERR_MissingArgument", "-outfile");
        }
        if (this.resources.isEmpty()) {
            throw new PackagerException("ERR_MissingAppResources");
        }
        if (this.applicationClass == null) {
            throw new PackagerException("ERR_MissingArgument", "-appclass");
        }
        DeployParams.validateAppName(this.appName);
    }

    public void addIcon(String href, String kind, int w, int h, int d, RunMode m) {
        this.icons.add(new Icon(href, kind, w, h, d, m));
    }

    public void setBundleType(Bundler.BundleType type) {
        this.bundleType = type;
    }

    public Bundler.BundleType getBundleType() {
        return this.bundleType;
    }

    public void setTargetFormat(String t) {
        this.targetFormat = t;
    }

    public String getTargetFormat() {
        return this.targetFormat;
    }

    private String getArch() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(arch) || "i386".equals(arch) || "i486".equals(arch) || "i586".equals(arch) || "i686".equals(arch)) {
            arch = "x86";
        } else if ("x86_64".equals(arch) || "amd64".equals("arch")) {
            arch = "x86_64";
        }
        return arch;
    }

    public void addBundleArgument(String key, Object value) {
        if (multi_args.contains(key) && value instanceof String) {
            Object existingValue = this.bundlerArguments.get(key);
            if (existingValue instanceof String) {
                this.bundlerArguments.put(key, existingValue + "\n\n" + value);
            } else if (existingValue instanceof List) {
                ((List)existingValue).add(value);
            } else if (existingValue instanceof Map && ((String)value).contains("=")) {
                String[] mapValues = ((String)value).split("=", 2);
                ((Map)existingValue).put(mapValues[0], mapValues[1]);
            } else {
                this.bundlerArguments.put(key, value);
            }
        } else {
            this.bundlerArguments.put(key, value);
        }
    }

    public BundleParams getBundleParams() {
        BundleParams bundleParams = new BundleParams();
        String currentOS = System.getProperty("os.name").toLowerCase();
        String currentArch = this.getArch();
        for (RelativeFileSet relativeFileSet : this.resources) {
            String string = relativeFileSet.getOs();
            String arch = relativeFileSet.getArch();
            if (string != null && !currentOS.contains(string.toLowerCase()) || arch != null && !currentArch.startsWith(arch.toLowerCase()) || relativeFileSet.getType() == RelativeFileSet.Type.nativelib || relativeFileSet.getType() != RelativeFileSet.Type.license) continue;
            for (String string2 : relativeFileSet.getIncludedFiles()) {
                bundleParams.addLicenseFile(string2);
            }
        }
        bundleParams.setAppResourcesList(this.resources);
        bundleParams.setIdentifier(this.id);
        if (this.javaRuntimeWasSet) {
            bundleParams.setRuntime(this.javaRuntimeToUse);
        }
        bundleParams.setApplicationClass(this.applicationClass);
        bundleParams.setPrelaoderClass(this.preloader);
        bundleParams.setName(this.appName);
        bundleParams.setAppVersion(this.version);
        bundleParams.setType(this.bundleType);
        bundleParams.setBundleFormat(this.targetFormat);
        bundleParams.setVendor(this.vendor);
        bundleParams.setEmail(this.email);
        bundleParams.setShortcutHint(this.needShortcut);
        bundleParams.setMenuHint(this.needMenu);
        bundleParams.setSystemWide(this.systemWide);
        bundleParams.setServiceHint(this.serviceHint);
        bundleParams.setInstalldirChooser(this.installdirChooser);
        bundleParams.setSignBundle(this.signBundle);
        bundleParams.setCopyright(this.copyright);
        bundleParams.setApplicationCategory(this.category);
        bundleParams.setLicenseType(this.licenseType);
        bundleParams.setDescription(this.description);
        bundleParams.setTitle(this.title);
        if (this.verbose) {
            bundleParams.setVerbose(true);
        }
        bundleParams.setJvmProperties(this.properties);
        bundleParams.setJvmargs(this.jvmargs);
        bundleParams.setJvmUserArgs(this.jvmUserArgs);
        bundleParams.setArguments(this.arguments);
        File appIcon = null;
        for (Icon icon : this.icons) {
            if (icon.kind != null && !icon.kind.equals("default") || (appIcon = new File(icon.href)).exists()) continue;
            Log.debug("Icon [" + icon.href + "] is not valid absolute path. Assume it is relative to the output dir.");
            appIcon = new File(this.outdir, icon.href);
        }
        bundleParams.setIcon(appIcon);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.params != null) {
            for (Param p : this.params) {
                treeMap.put(p.name, p.value);
            }
        }
        this.putUnlessNullOrEmpty(JNLPBundler.APP_PARAMS.getID(), treeMap);
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        TreeMap<String, String> escapedHtmlParams = new TreeMap<String, String>();
        if (this.htmlParams != null) {
            for (HtmlParam htmlParam : this.htmlParams) {
                if (htmlParam.needEscape) {
                    escapedHtmlParams.put(htmlParam.name, htmlParam.value);
                    continue;
                }
                treeMap2.put(htmlParam.name, htmlParam.value);
            }
        }
        this.putUnlessNullOrEmpty(JNLPBundler.APPLET_PARAMS.getID(), treeMap2);
        this.putUnlessNullOrEmpty(JNLPBundler.ESCAPED_APPLET_PARAMS.getID(), escapedHtmlParams);
        this.putUnlessNull(JNLPBundler.WIDTH.getID(), this.width);
        this.putUnlessNull(JNLPBundler.HEIGHT.getID(), this.height);
        this.putUnlessNull(JNLPBundler.EMBEDDED_WIDTH.getID(), this.embeddedWidth);
        this.putUnlessNull(JNLPBundler.EMBEDDED_HEIGHT.getID(), this.embeddedHeight);
        this.putUnlessNull(JNLPBundler.CODEBASE.getID(), this.codebase);
        this.putUnlessNull(JNLPBundler.EMBED_JNLP.getID(), this.embedJNLP);
        this.putUnlessNull(JNLPBundler.ALL_PERMISSIONS.getID(), this.allPermissions);
        this.putUnlessNull(JNLPBundler.UPDATE_MODE.getID(), this.updateMode);
        this.putUnlessNull(JNLPBundler.EXTENSION.getID(), this.isExtension);
        this.putUnlessNull(JNLPBundler.SWING_APP.getID(), this.isSwingApp);
        this.putUnlessNull(JNLPBundler.OUT_FILE.getID(), this.outfile);
        this.putUnlessNull(JNLPBundler.INCLUDE_DT.getID(), this.includeDT);
        this.putUnlessNull(JNLPBundler.PLACEHOLDER.getID(), this.placeholder);
        this.putUnlessNull(JNLPBundler.OFFLINE_ALLOWED.getID(), this.offlineAllowed);
        TreeMap<String, String> callbacksMap = new TreeMap<String, String>();
        if (this.callbacks != null) {
            for (JSCallback jSCallback : this.callbacks) {
                callbacksMap.put(jSCallback.getName(), jSCallback.getCmd());
            }
        }
        this.putUnlessNull(JNLPBundler.JS_CALLBACKS.getID(), callbacksMap);
        TreeMap<File, File> treeMap3 = new TreeMap<File, File>();
        if (this.templates != null) {
            for (Template template : this.templates) {
                treeMap3.put(template.in, template.out);
            }
        }
        this.putUnlessNull(JNLPBundler.TEMPLATES.getID(), treeMap3);
        this.putUnlessNull(JNLPBundler.FX_PLATFORM.getID(), this.fxPlatform);
        this.putUnlessNull(JNLPBundler.JRE_PLATFORM.getID(), this.jrePlatform);
        this.putUnlessNull(JNLPBundler.FALLBACK_APP.getID(), this.fallbackApp);
        TreeSet<String> treeSet = new TreeSet<String>(this.bundlerArguments.keySet());
        treeSet.retainAll(bundleParams.getBundleParamsAsMap().keySet());
        if (!treeSet.isEmpty()) {
            throw new RuntimeException("Deploy Params and Bundler Arguments overlap in the following values:" + treeSet.toString());
        }
        bundleParams.addAllBundleParams(this.bundlerArguments);
        return bundleParams;
    }

    public void putUnlessNull(String param, Object value) {
        if (value != null) {
            this.bundlerArguments.put(param, value);
        }
    }

    public void putUnlessNullOrEmpty(String param, Map value) {
        if (value != null && !value.isEmpty()) {
            this.bundlerArguments.put(param, value);
        }
    }

    static class Icon {
        static final int UNDEFINED = -1;
        String href;
        String kind;
        int width = -1;
        int height = -1;
        int depth = -1;
        RunMode mode = RunMode.WEBSTART;

        Icon(String href, String kind, int w, int h, int d, RunMode m) {
            this.mode = m;
            this.href = href;
            this.kind = kind;
            if (w > 0) {
                this.width = w;
            }
            if (h > 0) {
                this.height = h;
            }
            if (d > 0) {
                this.depth = d;
            }
        }
    }

    static class Template {
        File in;
        File out;

        Template(File in, File out) {
            this.in = in;
            this.out = out;
        }
    }

    public static enum RunMode {
        WEBSTART,
        EMBEDDED,
        STANDALONE,
        ALL;

    }
}

