/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyCode;

public final class KeyCodeMap {
    private static final Map<KeyCode, Entry> MAP;

    private static void put(Map<KeyCode, Entry> map, KeyCode keyCode, int windowsVirtualKeyCode, String keyIdentifier) {
        map.put(keyCode, new Entry(windowsVirtualKeyCode, keyIdentifier));
    }

    private static void put(Map<KeyCode, Entry> map, KeyCode keyCode, int windowsVirtualKeyCode) {
        KeyCodeMap.put(map, keyCode, windowsVirtualKeyCode, null);
    }

    public static Entry lookup(KeyCode keyCode) {
        Entry entry = MAP.get((Object)keyCode);
        if (entry == null || entry.getKeyIdentifier() == null) {
            int windowsVirtualKeyCode = entry != null ? entry.getWindowsVirtualKeyCode() : 0;
            String keyIdentifier = String.format("U+%04X", windowsVirtualKeyCode);
            entry = new Entry(windowsVirtualKeyCode, keyIdentifier);
        }
        return entry;
    }

    static {
        HashMap<KeyCode, Entry> map = new HashMap<KeyCode, Entry>();
        KeyCodeMap.put(map, KeyCode.ENTER, 13, "Enter");
        KeyCodeMap.put(map, KeyCode.BACK_SPACE, 8);
        KeyCodeMap.put(map, KeyCode.TAB, 9);
        KeyCodeMap.put(map, KeyCode.CANCEL, 3);
        KeyCodeMap.put(map, KeyCode.CLEAR, 12, "Clear");
        KeyCodeMap.put(map, KeyCode.SHIFT, 16, "Shift");
        KeyCodeMap.put(map, KeyCode.CONTROL, 17, "Control");
        KeyCodeMap.put(map, KeyCode.ALT, 18, "Alt");
        KeyCodeMap.put(map, KeyCode.PAUSE, 19, "Pause");
        KeyCodeMap.put(map, KeyCode.CAPS, 20, "CapsLock");
        KeyCodeMap.put(map, KeyCode.ESCAPE, 27);
        KeyCodeMap.put(map, KeyCode.SPACE, 32);
        KeyCodeMap.put(map, KeyCode.PAGE_UP, 33, "PageUp");
        KeyCodeMap.put(map, KeyCode.PAGE_DOWN, 34, "PageDown");
        KeyCodeMap.put(map, KeyCode.END, 35, "End");
        KeyCodeMap.put(map, KeyCode.HOME, 36, "Home");
        KeyCodeMap.put(map, KeyCode.LEFT, 37, "Left");
        KeyCodeMap.put(map, KeyCode.UP, 38, "Up");
        KeyCodeMap.put(map, KeyCode.RIGHT, 39, "Right");
        KeyCodeMap.put(map, KeyCode.DOWN, 40, "Down");
        KeyCodeMap.put(map, KeyCode.COMMA, 188);
        KeyCodeMap.put(map, KeyCode.MINUS, 189);
        KeyCodeMap.put(map, KeyCode.PERIOD, 190);
        KeyCodeMap.put(map, KeyCode.SLASH, 191);
        KeyCodeMap.put(map, KeyCode.DIGIT0, 48);
        KeyCodeMap.put(map, KeyCode.DIGIT1, 49);
        KeyCodeMap.put(map, KeyCode.DIGIT2, 50);
        KeyCodeMap.put(map, KeyCode.DIGIT3, 51);
        KeyCodeMap.put(map, KeyCode.DIGIT4, 52);
        KeyCodeMap.put(map, KeyCode.DIGIT5, 53);
        KeyCodeMap.put(map, KeyCode.DIGIT6, 54);
        KeyCodeMap.put(map, KeyCode.DIGIT7, 55);
        KeyCodeMap.put(map, KeyCode.DIGIT8, 56);
        KeyCodeMap.put(map, KeyCode.DIGIT9, 57);
        KeyCodeMap.put(map, KeyCode.SEMICOLON, 186);
        KeyCodeMap.put(map, KeyCode.EQUALS, 187);
        KeyCodeMap.put(map, KeyCode.A, 65);
        KeyCodeMap.put(map, KeyCode.B, 66);
        KeyCodeMap.put(map, KeyCode.C, 67);
        KeyCodeMap.put(map, KeyCode.D, 68);
        KeyCodeMap.put(map, KeyCode.E, 69);
        KeyCodeMap.put(map, KeyCode.F, 70);
        KeyCodeMap.put(map, KeyCode.G, 71);
        KeyCodeMap.put(map, KeyCode.H, 72);
        KeyCodeMap.put(map, KeyCode.I, 73);
        KeyCodeMap.put(map, KeyCode.J, 74);
        KeyCodeMap.put(map, KeyCode.K, 75);
        KeyCodeMap.put(map, KeyCode.L, 76);
        KeyCodeMap.put(map, KeyCode.M, 77);
        KeyCodeMap.put(map, KeyCode.N, 78);
        KeyCodeMap.put(map, KeyCode.O, 79);
        KeyCodeMap.put(map, KeyCode.P, 80);
        KeyCodeMap.put(map, KeyCode.Q, 81);
        KeyCodeMap.put(map, KeyCode.R, 82);
        KeyCodeMap.put(map, KeyCode.S, 83);
        KeyCodeMap.put(map, KeyCode.T, 84);
        KeyCodeMap.put(map, KeyCode.U, 85);
        KeyCodeMap.put(map, KeyCode.V, 86);
        KeyCodeMap.put(map, KeyCode.W, 87);
        KeyCodeMap.put(map, KeyCode.X, 88);
        KeyCodeMap.put(map, KeyCode.Y, 89);
        KeyCodeMap.put(map, KeyCode.Z, 90);
        KeyCodeMap.put(map, KeyCode.OPEN_BRACKET, 219);
        KeyCodeMap.put(map, KeyCode.BACK_SLASH, 220);
        KeyCodeMap.put(map, KeyCode.CLOSE_BRACKET, 221);
        KeyCodeMap.put(map, KeyCode.NUMPAD0, 96);
        KeyCodeMap.put(map, KeyCode.NUMPAD1, 97);
        KeyCodeMap.put(map, KeyCode.NUMPAD2, 98);
        KeyCodeMap.put(map, KeyCode.NUMPAD3, 99);
        KeyCodeMap.put(map, KeyCode.NUMPAD4, 100);
        KeyCodeMap.put(map, KeyCode.NUMPAD5, 101);
        KeyCodeMap.put(map, KeyCode.NUMPAD6, 102);
        KeyCodeMap.put(map, KeyCode.NUMPAD7, 103);
        KeyCodeMap.put(map, KeyCode.NUMPAD8, 104);
        KeyCodeMap.put(map, KeyCode.NUMPAD9, 105);
        KeyCodeMap.put(map, KeyCode.MULTIPLY, 106);
        KeyCodeMap.put(map, KeyCode.ADD, 107);
        KeyCodeMap.put(map, KeyCode.SEPARATOR, 108);
        KeyCodeMap.put(map, KeyCode.SUBTRACT, 109);
        KeyCodeMap.put(map, KeyCode.DECIMAL, 110);
        KeyCodeMap.put(map, KeyCode.DIVIDE, 111);
        KeyCodeMap.put(map, KeyCode.DELETE, 46, "U+007F");
        KeyCodeMap.put(map, KeyCode.NUM_LOCK, 144);
        KeyCodeMap.put(map, KeyCode.SCROLL_LOCK, 145, "Scroll");
        KeyCodeMap.put(map, KeyCode.F1, 112, "F1");
        KeyCodeMap.put(map, KeyCode.F2, 113, "F2");
        KeyCodeMap.put(map, KeyCode.F3, 114, "F3");
        KeyCodeMap.put(map, KeyCode.F4, 115, "F4");
        KeyCodeMap.put(map, KeyCode.F5, 116, "F5");
        KeyCodeMap.put(map, KeyCode.F6, 117, "F6");
        KeyCodeMap.put(map, KeyCode.F7, 118, "F7");
        KeyCodeMap.put(map, KeyCode.F8, 119, "F8");
        KeyCodeMap.put(map, KeyCode.F9, 120, "F9");
        KeyCodeMap.put(map, KeyCode.F10, 121, "F10");
        KeyCodeMap.put(map, KeyCode.F11, 122, "F11");
        KeyCodeMap.put(map, KeyCode.F12, 123, "F12");
        KeyCodeMap.put(map, KeyCode.F13, 124, "F13");
        KeyCodeMap.put(map, KeyCode.F14, 125, "F14");
        KeyCodeMap.put(map, KeyCode.F15, 126, "F15");
        KeyCodeMap.put(map, KeyCode.F16, 127, "F16");
        KeyCodeMap.put(map, KeyCode.F17, 128, "F17");
        KeyCodeMap.put(map, KeyCode.F18, 129, "F18");
        KeyCodeMap.put(map, KeyCode.F19, 130, "F19");
        KeyCodeMap.put(map, KeyCode.F20, 131, "F20");
        KeyCodeMap.put(map, KeyCode.F21, 132, "F21");
        KeyCodeMap.put(map, KeyCode.F22, 133, "F22");
        KeyCodeMap.put(map, KeyCode.F23, 134, "F23");
        KeyCodeMap.put(map, KeyCode.F24, 135, "F24");
        KeyCodeMap.put(map, KeyCode.PRINTSCREEN, 44, "PrintScreen");
        KeyCodeMap.put(map, KeyCode.INSERT, 45, "Insert");
        KeyCodeMap.put(map, KeyCode.HELP, 47, "Help");
        KeyCodeMap.put(map, KeyCode.META, 0, "Meta");
        KeyCodeMap.put(map, KeyCode.BACK_QUOTE, 192);
        KeyCodeMap.put(map, KeyCode.QUOTE, 222);
        KeyCodeMap.put(map, KeyCode.KP_UP, 38, "Up");
        KeyCodeMap.put(map, KeyCode.KP_DOWN, 40, "Down");
        KeyCodeMap.put(map, KeyCode.KP_LEFT, 37, "Left");
        KeyCodeMap.put(map, KeyCode.KP_RIGHT, 39, "Right");
        KeyCodeMap.put(map, KeyCode.AMPERSAND, 55);
        KeyCodeMap.put(map, KeyCode.ASTERISK, 56);
        KeyCodeMap.put(map, KeyCode.QUOTEDBL, 222);
        KeyCodeMap.put(map, KeyCode.LESS, 188);
        KeyCodeMap.put(map, KeyCode.GREATER, 190);
        KeyCodeMap.put(map, KeyCode.BRACELEFT, 219);
        KeyCodeMap.put(map, KeyCode.BRACERIGHT, 221);
        KeyCodeMap.put(map, KeyCode.AT, 50);
        KeyCodeMap.put(map, KeyCode.COLON, 186);
        KeyCodeMap.put(map, KeyCode.CIRCUMFLEX, 54);
        KeyCodeMap.put(map, KeyCode.DOLLAR, 52);
        KeyCodeMap.put(map, KeyCode.EXCLAMATION_MARK, 49);
        KeyCodeMap.put(map, KeyCode.LEFT_PARENTHESIS, 57);
        KeyCodeMap.put(map, KeyCode.NUMBER_SIGN, 51);
        KeyCodeMap.put(map, KeyCode.PLUS, 187);
        KeyCodeMap.put(map, KeyCode.RIGHT_PARENTHESIS, 48);
        KeyCodeMap.put(map, KeyCode.UNDERSCORE, 189);
        KeyCodeMap.put(map, KeyCode.WINDOWS, 91, "Win");
        KeyCodeMap.put(map, KeyCode.CONTEXT_MENU, 93);
        KeyCodeMap.put(map, KeyCode.FINAL, 24);
        KeyCodeMap.put(map, KeyCode.CONVERT, 28);
        KeyCodeMap.put(map, KeyCode.NONCONVERT, 29);
        KeyCodeMap.put(map, KeyCode.ACCEPT, 30);
        KeyCodeMap.put(map, KeyCode.MODECHANGE, 31);
        KeyCodeMap.put(map, KeyCode.KANA, 21);
        KeyCodeMap.put(map, KeyCode.KANJI, 25);
        KeyCodeMap.put(map, KeyCode.ALT_GRAPH, 165);
        KeyCodeMap.put(map, KeyCode.PLAY, 250);
        KeyCodeMap.put(map, KeyCode.TRACK_PREV, 177);
        KeyCodeMap.put(map, KeyCode.TRACK_NEXT, 176);
        KeyCodeMap.put(map, KeyCode.VOLUME_UP, 175);
        KeyCodeMap.put(map, KeyCode.VOLUME_DOWN, 174);
        KeyCodeMap.put(map, KeyCode.MUTE, 173);
        MAP = Collections.unmodifiableMap(map);
    }

    public static final class Entry {
        private final int windowsVirtualKeyCode;
        private final String keyIdentifier;

        private Entry(int windowsVirtualKeyCode, String keyIdentifier) {
            this.windowsVirtualKeyCode = windowsVirtualKeyCode;
            this.keyIdentifier = keyIdentifier;
        }

        public int getWindowsVirtualKeyCode() {
            return this.windowsVirtualKeyCode;
        }

        public String getKeyIdentifier() {
            return this.keyIdentifier;
        }
    }
}

