/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Graphics;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.QueuedPixelSource;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DResourceFactory;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class J2DPresentable
implements Presentable {
    J2DResourceFactory factory;
    boolean needsResize;
    BufferedImage buffer;
    IntBuffer ib;
    J2DRTTexture readbackBuffer;

    static J2DPresentable create(PresentableState pState, J2DResourceFactory factory) {
        return new Glass(pState, factory);
    }

    static J2DPresentable create(BufferedImage buffer, J2DResourceFactory factory) {
        return new Bimg(buffer, factory);
    }

    J2DPresentable(BufferedImage buffer, J2DResourceFactory factory) {
        this.buffer = buffer;
        this.factory = factory;
    }

    ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public abstract BufferedImage createBuffer(int var1, int var2);

    @Override
    public Graphics createGraphics() {
        if (this.needsResize) {
            int w = this.getContentWidth();
            int h = this.getContentHeight();
            this.buffer = null;
            this.readbackBuffer = null;
            this.buffer = this.createBuffer(w, h);
            WritableRaster r = this.buffer.getRaster();
            DataBuffer db = r.getDataBuffer();
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)r.getSampleModel();
            int[] pixels = ((DataBufferInt)db).getData();
            this.ib = IntBuffer.wrap(pixels, db.getOffset(), db.getSize());
            this.needsResize = false;
        }
        Graphics2D g2d = this.buffer.createGraphics();
        return this.factory.createJ2DPrismGraphics(this, g2d);
    }

    J2DRTTexture getReadbackBuffer() {
        if (this.readbackBuffer == null) {
            this.readbackBuffer = (J2DRTTexture)this.factory.createRTTexture(this.getContentWidth(), this.getContentHeight(), Texture.WrapMode.CLAMP_NOT_NEEDED);
            this.readbackBuffer.makePermanent();
        }
        return this.readbackBuffer;
    }

    BufferedImage getBackBuffer() {
        return this.buffer;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.factory.getScreen();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public float getPixelScaleFactor() {
        return 1.0f;
    }

    @Override
    public int getPhysicalWidth() {
        return this.buffer == null ? this.getContentWidth() : this.buffer.getWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.buffer == null ? this.getContentHeight() : this.buffer.getHeight();
    }

    @Override
    public boolean isMSAA() {
        return false;
    }

    private static class Bimg
    extends J2DPresentable {
        private boolean opaque;

        public Bimg(BufferedImage buffer, J2DResourceFactory factory) {
            super(buffer, factory);
        }

        @Override
        public BufferedImage createBuffer(int w, int h) {
            throw new UnsupportedOperationException("cannot create new buffers for image");
        }

        @Override
        public boolean lockResources(PresentableState pState) {
            return false;
        }

        @Override
        public boolean prepare(Rectangle dirtyregion) {
            throw new UnsupportedOperationException("cannot prepare/present on image");
        }

        @Override
        public boolean present() {
            throw new UnsupportedOperationException("cannot prepare/present on image");
        }

        @Override
        public int getContentWidth() {
            return this.buffer.getWidth();
        }

        @Override
        public int getContentHeight() {
            return this.buffer.getHeight();
        }

        @Override
        public void setOpaque(boolean opaque) {
            this.opaque = opaque;
        }

        @Override
        public boolean isOpaque() {
            return this.opaque;
        }
    }

    private static class Glass
    extends J2DPresentable {
        private final PresentableState pState;
        private final int theFormat;
        private Pixels pixels;
        private QueuedPixelSource pixelSource = new QueuedPixelSource(false);
        private boolean opaque;

        Glass(PresentableState pState, J2DResourceFactory factory) {
            super(null, factory);
            this.pState = pState;
            this.theFormat = pState.getPixelFormat();
            this.needsResize = true;
        }

        @Override
        public BufferedImage createBuffer(int w, int h) {
            if (PrismSettings.verbose) {
                System.out.println("Glass native format: " + this.theFormat);
            }
            ByteOrder byteorder = ByteOrder.nativeOrder();
            switch (this.theFormat) {
                case 1: {
                    if (byteorder == ByteOrder.LITTLE_ENDIAN) {
                        return new BufferedImage(w, h, 3);
                    }
                    throw new UnsupportedOperationException("BYTE_BGRA_PRE pixel format on BIG_ENDIAN");
                }
                case 2: {
                    if (byteorder == ByteOrder.BIG_ENDIAN) {
                        return new BufferedImage(w, h, 2);
                    }
                    throw new UnsupportedOperationException("BYTE_ARGB pixel format on LITTLE_ENDIAN");
                }
            }
            throw new UnsupportedOperationException("unrecognized pixel format: " + this.theFormat);
        }

        @Override
        public boolean lockResources(PresentableState pState) {
            if (this.pState != pState || this.theFormat != pState.getPixelFormat()) {
                return true;
            }
            this.needsResize = this.buffer == null || this.buffer.getWidth() != pState.getWidth() || this.buffer.getHeight() != pState.getHeight();
            return false;
        }

        @Override
        public boolean prepare(Rectangle dirty) {
            if (!this.pState.isViewClosed()) {
                int w = this.getPhysicalWidth();
                int h = this.getPhysicalHeight();
                this.pixels = this.pixelSource.getUnusedPixels(w, h, 1.0f);
                IntBuffer pixBuf = (IntBuffer)this.pixels.getPixels();
                assert (this.ib.hasArray());
                System.arraycopy(this.ib.array(), 0, pixBuf.array(), 0, w * h);
                return true;
            }
            return false;
        }

        @Override
        public boolean present() {
            this.pixelSource.enqueuePixels(this.pixels);
            this.pState.uploadPixels(this.pixelSource);
            return true;
        }

        @Override
        public int getContentWidth() {
            return this.pState.getWidth();
        }

        @Override
        public int getContentHeight() {
            return this.pState.getHeight();
        }

        @Override
        public void setOpaque(boolean opaque) {
            this.opaque = opaque;
        }

        @Override
        public boolean isOpaque() {
            return this.opaque;
        }
    }
}

