/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;

public class PickResult {
    public static final int FACE_UNDEFINED = -1;
    private Node node;
    private Point3D point;
    private double distance = Double.POSITIVE_INFINITY;
    private int face = -1;
    private Point3D normal;
    private Point2D texCoord;

    public PickResult(@NamedArg(value="node") Node node, @NamedArg(value="point") Point3D point, @NamedArg(value="distance") double distance, @NamedArg(value="face") int face, @NamedArg(value="texCoord") Point2D texCoord) {
        this.node = node;
        this.point = point;
        this.distance = distance;
        this.face = face;
        this.normal = null;
        this.texCoord = texCoord;
    }

    public PickResult(@NamedArg(value="node") Node node, @NamedArg(value="point") Point3D point, @NamedArg(value="distance") double distance, @NamedArg(value="face") int face, @NamedArg(value="normal") Point3D normal, @NamedArg(value="texCoord") Point2D texCoord) {
        this.node = node;
        this.point = point;
        this.distance = distance;
        this.face = face;
        this.normal = normal;
        this.texCoord = texCoord;
    }

    public PickResult(@NamedArg(value="node") Node node, @NamedArg(value="point") Point3D point, @NamedArg(value="distance") double distance) {
        this.node = node;
        this.point = point;
        this.distance = distance;
        this.face = -1;
        this.normal = null;
        this.texCoord = null;
    }

    public PickResult(@NamedArg(value="target") EventTarget target, @NamedArg(value="sceneX") double sceneX, @NamedArg(value="sceneY") double sceneY) {
        this(target instanceof Node ? (Node)target : null, target instanceof Node ? ((Node)target).sceneToLocal(sceneX, sceneY, 0.0) : new Point3D(sceneX, sceneY, 0.0), 1.0);
    }

    public final Node getIntersectedNode() {
        return this.node;
    }

    public final Point3D getIntersectedPoint() {
        return this.point;
    }

    public final double getIntersectedDistance() {
        return this.distance;
    }

    public final int getIntersectedFace() {
        return this.face;
    }

    public final Point3D getIntersectedNormal() {
        return this.normal;
    }

    public final Point2D getIntersectedTexCoord() {
        return this.texCoord;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PickResult [");
        sb.append("node = ").append(this.getIntersectedNode()).append(", point = ").append(this.getIntersectedPoint()).append(", distance = ").append(this.getIntersectedDistance());
        if (this.getIntersectedFace() != -1) {
            sb.append(", face = ").append(this.getIntersectedFace());
        }
        if (this.getIntersectedNormal() != null) {
            sb.append(", normal = ").append(this.getIntersectedNormal());
        }
        if (this.getIntersectedTexCoord() != null) {
            sb.append(", texCoord = ").append(this.getIntersectedTexCoord());
        }
        return sb.toString();
    }
}

