/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.JarSignature;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.resource.PackagerResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class PackagerLib {
    public static final String JAVAFX_VERSION = "8.0";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private CreateJarParams createJarParams;
    private CreateBSSParams createBssParams;
    private File bssTmpDir;
    private ClassLoader classLoader;
    private Set<String> alreadyAddedEntries = new HashSet<String>();

    private ClassLoader getClassLoader() throws PackagerException {
        if (this.classLoader == null) {
            try {
                URL[] urls = new URL[]{new URL(this.getJfxrtPath())};
                this.classLoader = URLClassLoader.newInstance(urls);
            }
            catch (MalformedURLException ex) {
                throw new PackagerException(ex, "ERR_CantFindRuntime", new String[0]);
            }
        }
        return this.classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File jarFileToUpdate(CreateJarParams params) {
        if (params.resources.size() != 1) return null;
        PackagerResource p = params.resources.get(0);
        File f = p.getFile();
        if (!f.isFile()) return null;
        if (!f.getAbsolutePath().toLowerCase().endsWith(".jar")) {
            return null;
        }
        try (JarFile jf = new JarFile(f);){
            jf.getManifest();
            File file = f;
            return file;
        }
        catch (Exception e) {
            Log.verbose(e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void packageAsJar(CreateJarParams createJarParams) throws PackagerException {
        String existingSetting;
        File parentFile;
        if (createJarParams == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        if (createJarParams.outfile == null) {
            throw new IllegalArgumentException("Output file is not specified");
        }
        this.createJarParams = createJarParams;
        File jarToUpdate = this.jarFileToUpdate(createJarParams);
        Manifest m = null;
        if (jarToUpdate != null) {
            Log.info(MessageFormat.format(bundle.getString("MSG_UpdatingJar"), jarToUpdate.getAbsolutePath()));
            try (JarFile jf = new JarFile(jarToUpdate);){
                m = jf.getManifest();
                if (m != null) {
                    Object value;
                    Attributes attrs = m.getMainAttributes();
                    if (createJarParams.applicationClass == null) {
                        createJarParams.applicationClass = attrs.getValue(Attributes.Name.MAIN_CLASS);
                    }
                    if (createJarParams.classpath == null) {
                        createJarParams.classpath = attrs.getValue(Attributes.Name.CLASS_PATH);
                    }
                    if (createJarParams.codebase == null) {
                        createJarParams.codebase = attrs.getValue(new Attributes.Name("Codebase"));
                    }
                    if (createJarParams.allPermissions == null && (value = attrs.getValue(new Attributes.Name("Permissions"))) != null) {
                        createJarParams.allPermissions = Boolean.valueOf((String)value);
                    }
                }
            }
            catch (IOException ex) {
                throw new PackagerException(ex, "ERR_FileReadFailed", jarToUpdate.getAbsolutePath());
            }
        }
        if (createJarParams.applicationClass == null) {
            throw new IllegalArgumentException("Main application class is not specified");
        }
        File applicationJar = new File(createJarParams.outdir, createJarParams.outfile.endsWith(".jar") ? createJarParams.outfile : createJarParams.outfile + ".jar");
        if (jarToUpdate != null && applicationJar.getAbsoluteFile().equals(jarToUpdate.getAbsoluteFile())) {
            try {
                File newInputJar = File.createTempFile("tempcopy", ".jar");
                Files.move(jarToUpdate.toPath(), newInputJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                jarToUpdate = newInputJar;
            }
            catch (IOException ioe) {
                throw new PackagerException(ioe, "ERR_FileCopyFailed", jarToUpdate.getAbsolutePath());
            }
        }
        if ((parentFile = applicationJar.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        if (m == null) {
            m = new Manifest();
        }
        Attributes attr = m.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        if (createJarParams.manifestAttrs != null) {
            for (Map.Entry entry : createJarParams.manifestAttrs.entrySet()) {
                attr.put(new Attributes.Name((String)entry.getKey()), entry.getValue());
            }
        }
        attr.put(Attributes.Name.MAIN_CLASS, createJarParams.applicationClass);
        if (createJarParams.classpath != null) {
            String cp = createJarParams.classpath;
            cp = cp.replace(';', ' ').replace(',', ' ');
            attr.put(Attributes.Name.CLASS_PATH, cp);
        }
        if ((existingSetting = attr.getValue("Permissions")) == null) {
            attr.put(new Attributes.Name("Permissions"), Boolean.TRUE.equals(createJarParams.allPermissions) ? "all-permissions" : "sandbox");
        } else if (createJarParams.allPermissions != null && !Boolean.valueOf(existingSetting).equals(createJarParams.allPermissions)) {
            throw new PackagerException("ERR_ContradictorySetting", "Permissions");
        }
        existingSetting = attr.getValue("Codebase");
        if (existingSetting == null) {
            if (createJarParams.codebase != null) {
                attr.put(new Attributes.Name("Codebase"), createJarParams.codebase);
            }
        } else if (createJarParams.codebase != null && !existingSetting.equals(createJarParams.codebase)) {
            throw new PackagerException("ERR_ContradictorySetting", "Codebase");
        }
        attr.put(new Attributes.Name("JavaFX-Version"), createJarParams.fxVersion);
        if (createJarParams.preloader != null) {
            attr.put(new Attributes.Name("JavaFX-Preloader-Class"), createJarParams.preloader);
        }
        if (createJarParams.arguments != null) {
            boolean bl = true;
            for (String arg : createJarParams.arguments) {
                void var8_15;
                attr.put(new Attributes.Name("JavaFX-Argument-" + (int)var8_15), this.encodeAsBase64(arg.getBytes()));
                ++var8_15;
            }
        }
        if (createJarParams.params != null) {
            boolean bl = true;
            for (Param p : createJarParams.params) {
                void var8_17;
                if (p.name == null) continue;
                attr.put(new Attributes.Name("JavaFX-Parameter-Name-" + (int)var8_17), this.encodeAsBase64(p.name.getBytes()));
                if (p.value != null) {
                    attr.put(new Attributes.Name("JavaFX-Parameter-Value-" + (int)var8_17), this.encodeAsBase64(p.value.getBytes()));
                }
                ++var8_17;
            }
        }
        if (createJarParams.css2bin) {
            try {
                this.bssTmpDir = File.createTempFile("bssfiles", "");
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_CreatingTempFileFailed", new String[0]);
            }
            this.bssTmpDir.delete();
        }
        if (applicationJar.exists() && !applicationJar.delete()) {
            throw new PackagerException("ERR_CantDeleteFile", createJarParams.outfile);
        }
        try {
            this.jar(m, createJarParams.resources, jarToUpdate, new JarOutputStream(new FileOutputStream(applicationJar)), Filter.ALL);
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_CreatingJarFailed", createJarParams.outfile);
        }
        PackagerLib.deleteDirectory(this.bssTmpDir);
        this.createJarParams = null;
    }

    public void generateDeploymentPackages(DeployParams deployParams) throws PackagerException {
        if (deployParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        try {
            BundleParams bp = deployParams.getBundleParams();
            if (bp != null) {
                this.generateNativeBundles(deployParams.outdir, bp.getBundleParamsAsMap(), "JNLP", "jnlp");
                this.generateNativeBundles(new File(deployParams.outdir, "bundles"), bp.getBundleParamsAsMap(), deployParams.getBundleType().toString(), deployParams.getTargetFormat());
            }
        }
        catch (PackagerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PackagerException(ex, "ERR_DeployFailed", ex.getMessage());
        }
    }

    private void generateNativeBundles(File outdir, Map<String, ? super Object> params, String bundleType, String bundleFormat) throws PackagerException {
        if (params.containsKey("runtime")) {
            RelativeFileSet runtime = BundleParams.getRuntime(params);
            if (runtime == null) {
                Log.info(bundle.getString("MSG_NoJREPackaged"));
            } else {
                Log.info(MessageFormat.format(bundle.getString("MSG_UserProvidedJRE"), runtime.getBaseDirectory().getAbsolutePath()));
                if (Log.isDebug()) {
                    runtime.dump();
                }
            }
        } else {
            Log.info(bundle.getString("MSG_UseSystemJRE"));
        }
        for (Bundler bundler : Bundlers.createBundlersInstance().getBundlers(bundleType)) {
            if (bundleFormat != null && !bundleFormat.equalsIgnoreCase(bundler.getID())) continue;
            HashMap<String, ? super Object> localParams = new HashMap<String, Object>(params);
            try {
                File result;
                if (!bundler.validate(localParams) || (result = bundler.execute(localParams, outdir)) != null) continue;
                throw new PackagerException("MSG_BundlerFailed", bundler.getID(), bundler.getName());
            }
            catch (UnsupportedPlatformException e) {
                Log.debug(MessageFormat.format(bundle.getString("MSG_BundlerPlatformException"), bundler.getName()));
            }
            catch (ConfigException e) {
                Log.debug(e);
                if (e.getAdvice() != null) {
                    Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigException"), bundler.getName(), e.getMessage(), e.getAdvice()));
                    continue;
                }
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigExceptionNoAdvice"), bundler.getName(), e.getMessage()));
            }
            catch (RuntimeException re) {
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerRuntimeException"), bundler.getName(), re.toString()));
                Log.debug(re);
            }
        }
    }

    public void generateBSS(CreateBSSParams params) throws PackagerException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.createBssParams = params;
        this.createBinaryCss(this.createBssParams.resources, this.createBssParams.outdir);
        this.createBssParams = null;
    }

    public void signJar(SignJarParams params) throws PackagerException {
        try {
            JarSignature signature = this.retrieveSignature(params);
            for (PackagerResource pr : params.resources) {
                this.signFile(pr, signature, params.outdir, params.verbose);
            }
        }
        catch (Exception ex) {
            Log.verbose(ex);
            throw new PackagerException("ERR_SignFailed", ex);
        }
    }

    private JarSignature retrieveSignature(SignJarParams params) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, InvalidKeyException {
        if (params.keyPass == null) {
            params.keyPass = params.storePass;
        }
        if (params.keyStore == null) {
            throw new IOException("No keystore specified");
        }
        if (params.storePass == null) {
            throw new IOException("No store password specified");
        }
        if (params.storeType == null) {
            throw new IOException("No store type is specified");
        }
        KeyStore store = KeyStore.getInstance(params.storeType);
        store.load(new FileInputStream(params.keyStore), params.storePass.toCharArray());
        Certificate[] chain = store.getCertificateChain(params.alias);
        X509Certificate[] certChain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            certChain[i] = (X509Certificate)chain[i];
        }
        PrivateKey privateKey = (PrivateKey)store.getKey(params.alias, params.keyPass.toCharArray());
        return JarSignature.create(privateKey, certChain);
    }

    private void signFile(PackagerResource pr, JarSignature signature, File outdir, boolean verbose) throws NoSuchAlgorithmException, IOException, SignatureException {
        if (pr.getFile().isDirectory()) {
            File[] children = pr.getFile().listFiles();
            if (children != null) {
                for (File innerFile : children) {
                    this.signFile(new PackagerResource(pr.getBaseDir(), innerFile), signature, outdir, verbose);
                }
            }
        } else {
            File destJar;
            File jar = pr.getFile();
            File parent = jar.getParentFile();
            String name = "bsigned_" + jar.getName();
            File signedJar = new File(parent, name);
            System.out.println("Signing (BLOB) " + jar.getPath());
            this.signAsBLOB(jar, signedJar, signature);
            if (outdir != null) {
                destJar = new File(outdir, pr.getRelativePath());
            } else {
                jar.delete();
                destJar = jar;
            }
            destJar.delete();
            destJar.getParentFile().mkdirs();
            signedJar.renameTo(destJar);
            if (verbose) {
                System.out.println("Signed as " + destJar.getPath());
            }
        }
    }

    private void signAsBLOB(File jar, File signedJar, JarSignature signature) throws IOException, NoSuchAlgorithmException, SignatureException {
        if (signature == null) {
            throw new IllegalStateException("Should retrieve signature first");
        }
        JarSignature.InputStreamSource in = () -> new FileInputStream(jar);
        if (!signedJar.isFile()) {
            signedJar.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(signedJar);
        signature.signJarAsBLOB(in, new ZipOutputStream(fos));
    }

    public void makeAll(MakeAllParams makeAllParams) throws PackagerException {
        String exe = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        String jHome = System.getenv("JAVA_HOME");
        if (jHome == null) {
            jHome = System.getProperty("java.home");
        }
        if (jHome == null) {
            throw new PackagerException("ERR_MissingJavaHome");
        }
        File javac = new File(new File(jHome), "bin/javac" + exe);
        String jfxHome = System.getenv("JAVAFX_HOME");
        if (jfxHome == null) {
            jfxHome = System.getProperty("javafx.home");
        }
        if (jfxHome == null) {
            throw new PackagerException("ERR_MissingJavaFxHome");
        }
        String srcDirName = "src";
        String compiledDirName = "compiled";
        String distDirName = "dist";
        String outfileName = "dist";
        String jarName = "dist.jar";
        File distDir = new File("dist");
        File compiledDir = new File("compiled");
        compiledDir.mkdir();
        try {
            int ret;
            File tmpFile = File.createTempFile("javac", "sources", new File("."));
            tmpFile.deleteOnExit();
            try (FileWriter sources = new FileWriter(tmpFile);){
                PackagerLib.scanAndCopy(new PackagerResource(new File("src"), "."), sources, compiledDir);
            }
            String classpath = jfxHome + "/../rt/lib/ext/jfxrt.jar";
            if (makeAllParams.classpath != null) {
                classpath = classpath + File.pathSeparator + makeAllParams.classpath;
            }
            if (makeAllParams.verbose) {
                System.out.println("Executing javac:");
                System.out.printf("%s %s %s %s %s %s%n", javac.getAbsolutePath(), "-d", "compiled", "-cp", classpath, "@" + tmpFile.getAbsolutePath());
            }
            if ((ret = PackagerLib.execute(javac.getAbsolutePath(), "-d", "compiled", "-cp", classpath, "@" + tmpFile.getAbsolutePath())) != 0) {
                throw new PackagerException("ERR_JavacFailed", Integer.toString(ret));
            }
        }
        catch (PackagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PackagerException(e, "ERR_MakeAllJavacFailed", new String[0]);
        }
        CreateJarParams cjp = new CreateJarParams();
        cjp.applicationClass = makeAllParams.appClass;
        cjp.preloader = makeAllParams.preloader;
        cjp.classpath = makeAllParams.classpath;
        cjp.css2bin = false;
        cjp.outdir = distDir;
        cjp.outfile = "dist.jar";
        cjp.addResource(compiledDir, ".");
        this.packageAsJar(cjp);
        DeployParams dp = new DeployParams();
        dp.applicationClass = makeAllParams.appClass;
        dp.appName = makeAllParams.appName;
        dp.description = "Application description";
        dp.height = makeAllParams.height;
        dp.width = makeAllParams.width;
        dp.vendor = "Application vendor";
        dp.outdir = distDir;
        dp.outfile = "dist";
        dp.addResource(distDir, "dist.jar");
        dp.setBundleType(Bundler.BundleType.ALL);
        this.generateDeploymentPackages(dp);
        PackagerLib.deleteDirectory(compiledDir);
    }

    private static int execute(Object ... args) throws IOException, InterruptedException {
        ArrayList<String> argsList = new ArrayList<String>();
        for (Object a : args) {
            if (a instanceof List) {
                argsList.addAll((List)a);
                continue;
            }
            if (!(a instanceof String)) continue;
            argsList.add((String)a);
        }
        Process p = Runtime.getRuntime().exec(argsList.toArray(new String[argsList.size()]));
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        Thread t = new Thread(() -> {
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioe) {
                Log.verbose(ioe);
            }
        });
        t.setDaemon(true);
        t.start();
        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        t = new Thread(() -> {
            try {
                String line;
                while ((line = err.readLine()) != null) {
                    System.err.println(line);
                }
            }
            catch (IOException ioe) {
                Log.verbose(ioe);
            }
        });
        t.setDaemon(true);
        t.start();
        return p.waitFor();
    }

    private static void scanAndCopy(PackagerResource dir, Writer out, File outdir) throws PackagerException {
        if (!dir.getFile().exists()) {
            throw new PackagerException("ERR_MissingDirectory", dir.getFile().getName());
        }
        File[] dirFilesList = dir.getFile().listFiles();
        if (dirFilesList == null || dirFilesList.length == 0) {
            throw new PackagerException("ERR_EmptySourceDirectory", dir.getFile().getName());
        }
        try {
            for (File f : dirFilesList) {
                if (f.isDirectory()) {
                    PackagerLib.scanAndCopy(new PackagerResource(dir.getBaseDir(), f), out, outdir);
                    continue;
                }
                if (f.getName().endsWith(".java")) {
                    out.write('\'' + f.getAbsolutePath().replace('\\', '/') + "'\n");
                    continue;
                }
                PackagerLib.copyFileToOutDir(new FileInputStream(f), new File(outdir.getPath() + File.separator + dir.getRelativePath() + File.separator + f.getName()));
            }
        }
        catch (IOException ex) {
            throw new PackagerException("ERR_FileCopyFailed", dir.getFile().getName());
        }
    }

    private String encodeAsBase64(byte[] inp) {
        return Base64.getEncoder().encodeToString(inp);
    }

    private static void copyFileToOutDir(InputStream isa, File fout) throws PackagerException {
        File outDir = fout.getParentFile();
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new PackagerException("ERR_CreatingDirFailed", outDir.getPath());
        }
        try (InputStream is = isa;
             FileOutputStream out = new FileOutputStream(fout);){
            int len;
            byte[] buf = new byte[16384];
            while ((len = is.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            throw new PackagerException(ex, "ERR_FileCopyFailed", outDir.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(Manifest manifest, List<PackagerResource> files, File importJarFile, JarOutputStream jar, Filter filter) throws IOException, PackagerException {
        try {
            jar.putNextEntry(new ZipEntry("META-INF/"));
            jar.closeEntry();
            jar.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(jar);
            jar.closeEntry();
            this.alreadyAddedEntries.add("META-INF/");
            if (importJarFile != null) {
                this.copyFromOtherJar(jar, importJarFile);
            } else {
                for (PackagerResource pr : files) {
                    this.jar(pr.getFile(), jar, filter, pr.getBaseDir().getAbsolutePath().length() + 1);
                }
            }
        }
        finally {
            jar.close();
            this.alreadyAddedEntries.clear();
        }
    }

    private void createParentEntries(String relativePath, JarOutputStream jar) throws IOException {
        String[] pathComponents = relativePath.split("/");
        StringBuilder pathSB = new StringBuilder();
        for (int i = 0; i < pathComponents.length - 1; ++i) {
            pathSB.append(pathComponents[i]).append("/");
            if (!this.alreadyAddedEntries.contains(pathSB.toString())) {
                jar.putNextEntry(new ZipEntry(pathSB.toString()));
                jar.closeEntry();
            }
            this.alreadyAddedEntries.add(pathSB.toString());
        }
    }

    private void copyFromOtherJar(JarOutputStream jar, File inputFile) throws IOException {
        JarFile inJar = new JarFile(inputFile);
        Enumeration<JarEntry> all = inJar.entries();
        while (all.hasMoreElements()) {
            JarEntry je = all.nextElement();
            if ("META-INF/MANIFEST.MF".equals(je.getName().toUpperCase()) || "META-INF/".equals(je.getName().toUpperCase())) continue;
            jar.putNextEntry(new JarEntry(je.getName()));
            byte[] b = new byte[65000];
            try (InputStream in = inJar.getInputStream(je);){
                int i;
                while ((i = in.read(b)) > 0) {
                    jar.write(b, 0, i);
                }
            }
            jar.closeEntry();
        }
    }

    private void jar(File f, JarOutputStream jar, Filter filter, int cut) throws IOException, PackagerException {
        if (!f.exists()) {
            throw new FileNotFoundException("Input folder does not exist [" + f.getAbsolutePath() + "]");
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children != null) {
                for (File innerFile : children) {
                    this.jar(innerFile, jar, filter, cut);
                }
            }
        } else if (filter == Filter.ALL || filter == Filter.CLASSES_ONLY && f.getName().endsWith(".class") || filter == Filter.RESOURCES && this.isResource(f.getAbsolutePath())) {
            String absPath = f.getAbsolutePath();
            if (absPath.endsWith("META-INF\\MANIFEST.MF") || absPath.endsWith("META-INF/MANIFEST.MF")) {
                return;
            }
            this.createParentEntries(absPath.substring(cut).replace('\\', '/'), jar);
            if (this.createJarParams.css2bin && f.getName().endsWith(".css")) {
                int startOfExt = absPath.lastIndexOf(".") + 1;
                String bssFileName = absPath.substring(cut, startOfExt).concat("bss");
                File bssFile = new File(this.bssTmpDir, bssFileName);
                bssFile.getParentFile().mkdirs();
                this.createBinaryCss(absPath, bssFile.getAbsolutePath());
                jar.putNextEntry(new ZipEntry(bssFileName.replace('\\', '/')));
                f = bssFile;
            } else {
                jar.putNextEntry(new ZipEntry(absPath.substring(cut).replace('\\', '/')));
            }
            byte[] b = new byte[65000];
            try (FileInputStream in = new FileInputStream(f);){
                int i;
                while ((i = in.read(b)) > 0) {
                    jar.write(b, 0, i);
                }
            }
            jar.closeEntry();
        }
    }

    private void createBinaryCss(List<PackagerResource> cssResources, File outdir) throws PackagerException {
        for (PackagerResource cssRes : cssResources) {
            String relPath = cssRes.getRelativePath();
            this.createBinaryCss(cssRes.getFile(), outdir, relPath);
        }
    }

    private void createBinaryCss(File f, File outdir, String relPath) throws PackagerException {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children != null) {
                for (File innerFile : children) {
                    this.createBinaryCss(innerFile, outdir, relPath + '/' + innerFile.getName());
                }
            }
        } else if (f.getName().endsWith(".css")) {
            String cssFileName = f.getAbsolutePath();
            String bssFileName = new File(outdir.getAbsolutePath(), PackagerLib.replaceExtensionByBSS(relPath)).getAbsolutePath();
            this.createBinaryCss(cssFileName, bssFileName);
        }
    }

    private String getJfxrtPath() throws PackagerException {
        Class<PackagerLib> theClass = PackagerLib.class;
        String theClassFile = "PackagerLib.class";
        String classUrl = theClass.getResource(theClassFile).toString();
        if (!classUrl.startsWith("jar:file:") || !classUrl.contains("!")) {
            throw new PackagerException("ERR_CantFindRuntime");
        }
        classUrl = classUrl.substring(0, classUrl.lastIndexOf("!"));
        int lastIndexOfSlash = Math.max(classUrl.lastIndexOf("/"), classUrl.lastIndexOf("\\"));
        return classUrl.substring(0, lastIndexOfSlash) + "/../rt/lib/ext/jfxrt.jar!/";
    }

    private Class loadClassFromRuntime(String className) throws PackagerException {
        try {
            ClassLoader cl = this.getClassLoader();
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new PackagerException(ex, "ERR_CantFindRuntime", new String[0]);
        }
    }

    private void createBinaryCss(String cssFile, String binCssFile) throws PackagerException {
        Class clazz;
        String ofname = binCssFile != null ? binCssFile : PackagerLib.replaceExtensionByBSS(cssFile);
        File of = new File(ofname);
        File parentFile = of.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        try {
            clazz = Class.forName("com.sun.javafx.css.parser.Css2Bin");
        }
        catch (ClassNotFoundException e) {
            clazz = this.loadClassFromRuntime("com.sun.javafx.css.parser.Css2Bin");
        }
        try {
            Method m = clazz.getMethod("convertToBinary", String.class, String.class);
            m.invoke(null, cssFile, ofname);
        }
        catch (Exception ex) {
            Throwable causeEx = ex.getCause();
            String cause = causeEx != null ? causeEx.getMessage() : bundle.getString("ERR_UnknownReason");
            throw new PackagerException(ex, "ERR_BSSConversionFailed", cssFile, cause);
        }
    }

    private static String replaceExtensionByBSS(String cssName) {
        return cssName.substring(0, cssName.lastIndexOf(".") + 1).concat("bss");
    }

    private boolean isResource(String name) {
        if (name.endsWith(".class")) {
            return false;
        }
        if (name.endsWith(".java")) {
            return false;
        }
        if (name.endsWith(".fx")) {
            return false;
        }
        if (name.endsWith(".cvsignore")) {
            return false;
        }
        if (name.endsWith(".hgignore")) {
            return false;
        }
        if (name.endsWith("vssver.scc")) {
            return false;
        }
        if (name.endsWith(".DS_Store")) {
            return false;
        }
        if (name.endsWith("~")) {
            return false;
        }
        if ((name = name.replace('\\', '/')).contains("/CVS/")) {
            return false;
        }
        if (name.contains("/.svn/")) {
            return false;
        }
        if (name.contains("/.hg/")) {
            return false;
        }
        if (name.contains("/.#")) {
            return false;
        }
        if (name.contains("/._")) {
            return false;
        }
        if (name.endsWith("#") && name.contains("/#")) {
            return false;
        }
        if (name.endsWith("%") && name.contains("/%")) {
            return false;
        }
        return !name.endsWith("MANIFEST.MF");
    }

    private static boolean deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            for (String file : dir.list()) {
                PackagerLib.deleteDirectory(new File(dir, file));
            }
        }
        return dir.delete();
    }

    private static enum Filter {
        ALL,
        CLASSES_ONLY,
        RESOURCES;

    }
}

