/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.utils.NativeLibLoader;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

public abstract class Application {
    private static final String DEFAULT_NAME = "java";
    protected String name = "java";
    private EventHandler eventHandler;
    private boolean initialActiveEventReceived = false;
    private String[] initialOpenedFiles = null;
    private static boolean loaded = false;
    private static Application application;
    private static Thread eventThread;
    private static final boolean disableThreadChecks;
    private static volatile Map deviceDetails;
    private boolean terminateWhenLastWindowClosed = true;
    private static int nestedEventLoopCounter;

    protected static synchronized void loadNativeLibrary(String libname) {
        if (!loaded) {
            NativeLibLoader.loadLibrary(libname);
            loaded = true;
        }
    }

    protected static synchronized void loadNativeLibrary() {
        Application.loadNativeLibrary("glass");
    }

    public static void setDeviceDetails(Map details) {
        deviceDetails = details;
    }

    public static Map getDeviceDetails() {
        return deviceDetails;
    }

    protected Application() {
    }

    public static void run(Runnable launchable) {
        if (application != null) {
            throw new IllegalStateException("Application is already running");
        }
        application = PlatformFactory.getPlatformFactory().createApplication();
        try {
            application.runLoop(() -> {
                Screen.initScreens();
                launchable.run();
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected abstract void runLoop(Runnable var1);

    protected void finishTerminating() {
        application = null;
    }

    public String getName() {
        Application.checkEventThread();
        return this.name;
    }

    public void setName(String name) {
        Application.checkEventThread();
        if (name != null && DEFAULT_NAME.equals(this.name)) {
            this.name = name;
        }
    }

    public String getDataDirectory() {
        Application.checkEventThread();
        String userHome = AccessController.doPrivileged(() -> System.getProperty("user.home"));
        return userHome + File.separator + "." + this.name + File.separator;
    }

    protected void notifyWillFinishLaunching() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillFinishLaunchingAction(this, System.nanoTime());
        }
    }

    protected void notifyDidFinishLaunching() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidFinishLaunchingAction(this, System.nanoTime());
        }
    }

    protected void notifyWillBecomeActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillBecomeActiveAction(this, System.nanoTime());
        }
    }

    protected void notifyDidBecomeActive() {
        this.initialActiveEventReceived = true;
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidBecomeActiveAction(this, System.nanoTime());
        }
    }

    protected void notifyWillResignActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillResignActiveAction(this, System.nanoTime());
        }
    }

    protected boolean notifyThemeChanged(String themeName) {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            return handler.handleThemeChanged(themeName);
        }
        return false;
    }

    protected void notifyDidResignActive() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidResignActiveAction(this, System.nanoTime());
        }
    }

    protected void notifyDidReceiveMemoryWarning() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidReceiveMemoryWarning(this, System.nanoTime());
        }
    }

    protected void notifyWillHide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillHideAction(this, System.nanoTime());
        }
    }

    protected void notifyDidHide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidHideAction(this, System.nanoTime());
        }
    }

    protected void notifyWillUnhide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleWillUnhideAction(this, System.nanoTime());
        }
    }

    protected void notifyDidUnhide() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleDidUnhideAction(this, System.nanoTime());
        }
    }

    protected void notifyOpenFiles(String[] files) {
        EventHandler handler;
        if (!this.initialActiveEventReceived && this.initialOpenedFiles == null) {
            this.initialOpenedFiles = files;
        }
        if ((handler = this.getEventHandler()) != null && files != null) {
            handler.handleOpenFilesAction(this, System.nanoTime(), files);
        }
    }

    protected void notifyWillQuit() {
        EventHandler handler = this.getEventHandler();
        if (handler != null) {
            handler.handleQuitAction(this, System.nanoTime());
        }
    }

    public void installDefaultMenus(MenuBar menubar) {
        Application.checkEventThread();
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        Application.checkEventThread();
        boolean resendOpenFiles = this.eventHandler != null && this.initialOpenedFiles != null;
        this.eventHandler = eventHandler;
        if (resendOpenFiles) {
            this.notifyOpenFiles(this.initialOpenedFiles);
        }
    }

    public final boolean shouldTerminateWhenLastWindowClosed() {
        Application.checkEventThread();
        return this.terminateWhenLastWindowClosed;
    }

    public final void setTerminateWhenLastWindowClosed(boolean b) {
        Application.checkEventThread();
        this.terminateWhenLastWindowClosed = b;
    }

    public boolean shouldUpdateWindow() {
        Application.checkEventThread();
        return false;
    }

    public boolean hasWindowManager() {
        return true;
    }

    public void notifyRenderingFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Application.checkEventThread();
        try {
            LinkedList<Window> windows = new LinkedList<Window>(Window.getWindows());
            for (Window window : windows) {
                window.setVisible(false);
            }
            for (Window window : windows) {
                window.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.finishTerminating();
        }
    }

    public static Application GetApplication() {
        return application;
    }

    protected static void setEventThread(Thread thread) {
        eventThread = thread;
    }

    protected static Thread getEventThread() {
        return eventThread;
    }

    public static boolean isEventThread() {
        return Thread.currentThread() == eventThread;
    }

    public static void checkEventThread() {
        if (!disableThreadChecks && Thread.currentThread() != eventThread) {
            throw new IllegalStateException("This operation is permitted on the event thread only; currentThread = " + Thread.currentThread().getName());
        }
    }

    public static void reportException(Throwable t) {
        Thread currentThread = Thread.currentThread();
        Thread.UncaughtExceptionHandler handler = currentThread.getUncaughtExceptionHandler();
        handler.uncaughtException(currentThread, t);
    }

    protected abstract void _invokeAndWait(Runnable var1);

    public static void invokeAndWait(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (Application.isEventThread()) {
            runnable.run();
        } else {
            Application.GetApplication()._invokeAndWait(runnable);
        }
    }

    protected abstract void _invokeLater(Runnable var1);

    public static void invokeLater(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Application.GetApplication()._invokeLater(runnable);
    }

    protected abstract Object _enterNestedEventLoop();

    protected abstract void _leaveNestedEventLoop(Object var1);

    static Object enterNestedEventLoop() {
        Application.checkEventThread();
        ++nestedEventLoopCounter;
        try {
            Object object = Application.GetApplication()._enterNestedEventLoop();
            return object;
        }
        finally {
            --nestedEventLoopCounter;
        }
    }

    static void leaveNestedEventLoop(Object retValue) {
        Application.checkEventThread();
        if (nestedEventLoopCounter == 0) {
            throw new IllegalStateException("Not in a nested event loop");
        }
        Application.GetApplication()._leaveNestedEventLoop(retValue);
    }

    public static boolean isNestedLoopRunning() {
        Application.checkEventThread();
        return nestedEventLoopCounter > 0;
    }

    public void menuAboutAction() {
        System.err.println("about");
    }

    public abstract Window createWindow(Window var1, Screen var2, int var3);

    public final Window createWindow(Screen screen, int styleMask) {
        return this.createWindow(null, screen, styleMask);
    }

    public abstract Window createWindow(long var1);

    public abstract View createView();

    public abstract Cursor createCursor(int var1);

    public abstract Cursor createCursor(int var1, int var2, Pixels var3);

    protected abstract void staticCursor_setVisible(boolean var1);

    protected abstract Size staticCursor_getBestSize(int var1, int var2);

    public final Menu createMenu(String title) {
        return new Menu(title);
    }

    public final Menu createMenu(String title, boolean enabled) {
        return new Menu(title, enabled);
    }

    public final MenuBar createMenuBar() {
        return new MenuBar();
    }

    public final MenuItem createMenuItem(String title) {
        return this.createMenuItem(title, null);
    }

    public final MenuItem createMenuItem(String title, MenuItem.Callback callback) {
        return this.createMenuItem(title, callback, 0, 0);
    }

    public final MenuItem createMenuItem(String title, MenuItem.Callback callback, int shortcutKey, int shortcutModifiers) {
        return this.createMenuItem(title, callback, shortcutKey, shortcutModifiers, null);
    }

    public final MenuItem createMenuItem(String title, MenuItem.Callback callback, int shortcutKey, int shortcutModifiers, Pixels pixels) {
        return new MenuItem(title, callback, shortcutKey, shortcutModifiers, pixels);
    }

    public abstract Pixels createPixels(int var1, int var2, ByteBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3);

    public abstract Pixels createPixels(int var1, int var2, IntBuffer var3, float var4);

    protected abstract int staticPixels_getNativeFormat();

    static Pixels createPixels(int width, int height, int[] data, float scale) {
        return Application.GetApplication().createPixels(width, height, IntBuffer.wrap(data), scale);
    }

    static float getScaleFactor(int x, int y, int w, int h) {
        float scale = 0.0f;
        for (Screen s : Screen.getScreens()) {
            int sx = s.getX();
            int sy = s.getY();
            int sw = s.getWidth();
            int sh = s.getHeight();
            if (x >= sx + sw || x + w <= sx || y >= sy + sh || y + h <= sy || !(scale < s.getRenderScale())) continue;
            scale = s.getRenderScale();
        }
        return scale == 0.0f ? 1.0f : scale;
    }

    public abstract Robot createRobot();

    protected abstract double staticScreen_getVideoRefreshPeriod();

    protected abstract Screen[] staticScreen_getScreens();

    public abstract Timer createTimer(Runnable var1);

    protected abstract int staticTimer_getMinPeriod();

    protected abstract int staticTimer_getMaxPeriod();

    public final EventLoop createEventLoop() {
        return new EventLoop();
    }

    public Accessible createAccessible() {
        return null;
    }

    protected abstract CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window var1, String var2, String var3, String var4, int var5, boolean var6, CommonDialogs.ExtensionFilter[] var7, int var8);

    protected abstract File staticCommonDialogs_showFolderChooser(Window var1, String var2, String var3);

    protected abstract long staticView_getMultiClickTime();

    protected abstract int staticView_getMultiClickMaxX();

    protected abstract int staticView_getMultiClickMaxY();

    public String getHighContrastTheme() {
        Application.checkEventThread();
        return null;
    }

    protected abstract void _showDocument(String var1);

    protected boolean _supportsInputMethods() {
        return false;
    }

    public final boolean supportsInputMethods() {
        Application.checkEventThread();
        return this._supportsInputMethods();
    }

    protected abstract boolean _supportsTransparentWindows();

    public final boolean supportsTransparentWindows() {
        Application.checkEventThread();
        return this._supportsTransparentWindows();
    }

    public boolean hasTwoLevelFocus() {
        return false;
    }

    public boolean hasVirtualKeyboard() {
        return false;
    }

    public boolean hasTouch() {
        return false;
    }

    public boolean hasMultiTouch() {
        return false;
    }

    public boolean hasPointer() {
        return true;
    }

    protected abstract boolean _supportsUnifiedWindows();

    public final boolean supportsUnifiedWindows() {
        Application.checkEventThread();
        return this._supportsUnifiedWindows();
    }

    protected boolean _supportsSystemMenu() {
        return false;
    }

    public final boolean supportsSystemMenu() {
        Application.checkEventThread();
        return this._supportsSystemMenu();
    }

    protected abstract int _getKeyCodeForChar(char var1);

    public static int getKeyCodeForChar(char c) {
        return application._getKeyCodeForChar(c);
    }

    protected int _isKeyLocked(int keyCode) {
        return -1;
    }

    public final Optional<Boolean> isKeyLocked(int keyCode) {
        Application.checkEventThread();
        int lockState = this._isKeyLocked(keyCode);
        switch (lockState) {
            case 0: {
                return Optional.of(false);
            }
            case 1: {
                return Optional.of(true);
            }
        }
        return Optional.empty();
    }

    public void showDocument(String uri) {
        this._showDocument(uri);
    }

    static {
        disableThreadChecks = AccessController.doPrivileged(() -> {
            String str = System.getProperty("glass.disableThreadChecks", "false");
            return "true".equalsIgnoreCase(str);
        });
        deviceDetails = null;
        nestedEventLoopCounter = 0;
    }

    public static class EventHandler {
        public void handleWillFinishLaunchingAction(Application app, long time) {
        }

        public void handleDidFinishLaunchingAction(Application app, long time) {
        }

        public void handleWillBecomeActiveAction(Application app, long time) {
        }

        public void handleDidBecomeActiveAction(Application app, long time) {
        }

        public void handleWillResignActiveAction(Application app, long time) {
        }

        public void handleDidResignActiveAction(Application app, long time) {
        }

        public void handleDidReceiveMemoryWarning(Application app, long time) {
        }

        public void handleWillHideAction(Application app, long time) {
        }

        public void handleDidHideAction(Application app, long time) {
        }

        public void handleWillUnhideAction(Application app, long time) {
        }

        public void handleDidUnhideAction(Application app, long time) {
        }

        public void handleOpenFilesAction(Application app, long time, String[] files) {
        }

        public void handleQuitAction(Application app, long time) {
        }

        public boolean handleThemeChanged(String themeName) {
            return false;
        }
    }
}

