/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.win.WinAccessible;
import com.sun.glass.ui.win.WinVariant;
import com.sun.javafx.util.Utils;
import java.text.BreakIterator;
import javafx.geometry.Bounds;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

class WinTextRangeProvider {
    private static final int TextPatternRangeEndpoint_Start = 0;
    private static final int TextPatternRangeEndpoint_End = 1;
    private static final int TextUnit_Character = 0;
    private static final int TextUnit_Format = 1;
    private static final int TextUnit_Word = 2;
    private static final int TextUnit_Line = 3;
    private static final int TextUnit_Paragraph = 4;
    private static final int TextUnit_Page = 5;
    private static final int TextUnit_Document = 6;
    private static final int UIA_FontNameAttributeId = 40005;
    private static final int UIA_FontSizeAttributeId = 40006;
    private static final int UIA_FontWeightAttributeId = 40007;
    private static final int UIA_IsHiddenAttributeId = 40013;
    private static final int UIA_IsItalicAttributeId = 40014;
    private static final int UIA_IsReadOnlyAttributeId = 40015;
    private static int idCount;
    private int id;
    private int start;
    private int end;
    private WinAccessible accessible;
    private long peer;

    private static native void _initIDs();

    private native long _createTextRangeProvider(long var1);

    private native void _destroyTextRangeProvider(long var1);

    WinTextRangeProvider(WinAccessible accessible) {
        this.accessible = accessible;
        this.peer = this._createTextRangeProvider(accessible.getNativeAccessible());
        this.id = idCount++;
    }

    long getNativeProvider() {
        return this.peer;
    }

    void dispose() {
        this._destroyTextRangeProvider(this.peer);
        this.peer = 0L;
    }

    private void validateRange(String text) {
        if (text == null) {
            this.end = 0;
            this.start = 0;
            return;
        }
        int length = text.length();
        this.start = Utils.clamp(0, this.start, length);
        this.end = Utils.clamp(this.start, this.end, length);
    }

    static int getEndIndex(int startIndex, int length, int endIndex) {
        if (length < 0 || endIndex - startIndex <= length) {
            return endIndex;
        }
        return startIndex + length;
    }

    void setRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    public String toString() {
        return "Range(start: " + this.start + ", end: " + this.end + ", id: " + this.id + ")";
    }

    private Object getAttribute(AccessibleAttribute attribute, Object ... parameters) {
        return this.accessible.getAttribute(attribute, parameters);
    }

    private boolean isWordStart(BreakIterator bi, String text, int offset) {
        if (offset == 0) {
            return true;
        }
        if (offset >= text.length()) {
            return true;
        }
        if (offset == -1) {
            return true;
        }
        return bi.isBoundary(offset) && Character.isLetterOrDigit(text.charAt(offset));
    }

    private long Clone() {
        WinTextRangeProvider clone = new WinTextRangeProvider(this.accessible);
        clone.setRange(this.start, this.end);
        return clone.getNativeProvider();
    }

    private boolean Compare(WinTextRangeProvider range) {
        if (range == null) {
            return false;
        }
        return this.accessible == range.accessible && this.start == range.start && this.end == range.end;
    }

    private int CompareEndpoints(int endpoint, WinTextRangeProvider targetRange, int targetEndpoint) {
        int offset = endpoint == 0 ? this.start : this.end;
        int targetOffset = targetEndpoint == 0 ? targetRange.start : targetRange.end;
        return offset - targetOffset;
    }

    private void ExpandToEnclosingUnit(int unit) {
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return;
        }
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.validateRange(text);
        switch (unit) {
            case 0: {
                if (this.start == length) {
                    --this.start;
                }
                this.end = this.start + 1;
                break;
            }
            case 1: 
            case 2: {
                int offset;
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText(text);
                if (!this.isWordStart(bi, text, this.start)) {
                    offset = bi.preceding(this.start);
                    while (!this.isWordStart(bi, text, offset)) {
                        offset = bi.previous();
                    }
                    int n = this.start = offset != -1 ? offset : 0;
                }
                if (this.isWordStart(bi, text, this.end)) break;
                offset = bi.following(this.end);
                while (!this.isWordStart(bi, text, offset)) {
                    offset = bi.next();
                }
                this.end = offset != -1 ? offset : length;
                break;
            }
            case 3: {
                Integer lineIndex = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, this.start);
                Integer lineStart = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, lineIndex);
                Integer lineEnd = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, lineIndex);
                if (lineIndex == null || lineEnd == null || lineStart == null) {
                    this.start = 0;
                    this.end = length;
                    break;
                }
                this.start = lineStart;
                this.end = lineEnd;
                break;
            }
            case 4: {
                int offset;
                Integer lineIndex = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, this.start);
                if (lineIndex == null) {
                    this.start = 0;
                    this.end = length;
                    break;
                }
                BreakIterator bi = BreakIterator.getSentenceInstance();
                bi.setText(text);
                if (!bi.isBoundary(this.start)) {
                    offset = bi.preceding(this.start);
                    this.start = offset != -1 ? offset : 0;
                }
                this.end = (offset = bi.following(this.start)) != -1 ? offset : length;
                break;
            }
            case 5: 
            case 6: {
                this.start = 0;
                this.end = length;
            }
        }
        this.validateRange(text);
    }

    private long FindAttribute(int attributeId, WinVariant val, boolean backward) {
        System.err.println("FindAttribute NOT IMPLEMENTED");
        return 0L;
    }

    private long FindText(String text, boolean backward, boolean ignoreCase) {
        if (text == null) {
            return 0L;
        }
        String documentText = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (documentText == null) {
            return 0L;
        }
        String rangeText = documentText.substring(this.start, this.end);
        if (ignoreCase) {
            rangeText = rangeText.toLowerCase();
            text = text.toLowerCase();
        }
        int index = -1;
        index = backward ? rangeText.lastIndexOf(text) : rangeText.indexOf(text);
        if (index == -1) {
            return 0L;
        }
        WinTextRangeProvider result = new WinTextRangeProvider(this.accessible);
        result.setRange(this.start + index, this.start + index + text.length());
        return result.getNativeProvider();
    }

    private WinVariant GetAttributeValue(int attributeId) {
        WinVariant variant = null;
        switch (attributeId) {
            case 40005: {
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font == null) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = font.getName();
                break;
            }
            case 40006: {
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font == null) break;
                variant = new WinVariant();
                variant.vt = (short)5;
                variant.dblVal = font.getSize();
                break;
            }
            case 40007: {
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font == null) break;
                boolean bold = font.getStyle().toLowerCase().contains("bold");
                variant = new WinVariant();
                variant.vt = (short)3;
                variant.lVal = bold ? FontWeight.BOLD.getWeight() : FontWeight.NORMAL.getWeight();
                break;
            }
            case 40013: 
            case 40015: {
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = false;
                break;
            }
            case 40014: {
                Font font = (Font)this.getAttribute(AccessibleAttribute.FONT, new Object[0]);
                if (font == null) break;
                boolean italic = font.getStyle().toLowerCase().contains("italic");
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = italic;
                break;
            }
        }
        return variant;
    }

    private double[] GetBoundingRectangles() {
        Bounds[] bounds;
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return null;
        }
        int length = text.length();
        this.validateRange(text);
        if (length == 0) {
            return new double[0];
        }
        int endOffset = this.end;
        if (endOffset > 0 && endOffset > this.start && text.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        if (endOffset > 0 && endOffset > this.start && text.charAt(endOffset - 1) == '\r') {
            --endOffset;
        }
        if (endOffset > 0 && endOffset > this.start && endOffset == length) {
            --endOffset;
        }
        if ((bounds = (Bounds[])this.getAttribute(AccessibleAttribute.BOUNDS_FOR_RANGE, this.start, endOffset)) != null) {
            double[] result = new double[bounds.length * 4];
            int index = 0;
            for (int i = 0; i < bounds.length; ++i) {
                Bounds b = bounds[i];
                result[index++] = b.getMinX();
                result[index++] = b.getMinY();
                result[index++] = b.getWidth();
                result[index++] = b.getHeight();
            }
            return result;
        }
        return null;
    }

    private long GetEnclosingElement() {
        return this.accessible.getNativeAccessible();
    }

    private String GetText(int maxLength) {
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return null;
        }
        this.validateRange(text);
        int endOffset = WinTextRangeProvider.getEndIndex(this.start, maxLength, this.end);
        return text.substring(this.start, endOffset);
    }

    private int Move(int unit, int requestedCount) {
        int actualCount;
        if (requestedCount == 0) {
            return 0;
        }
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return 0;
        }
        int length = text.length();
        if (length == 0) {
            return 0;
        }
        switch (unit) {
            case 0: {
                int oldStart = this.start;
                this.start = Math.max(0, Math.min(this.start + requestedCount, length - 1));
                this.end = this.start + 1;
                actualCount = this.start - oldStart;
                break;
            }
            case 1: 
            case 2: {
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText(text);
                int offset = this.start;
                while (!this.isWordStart(bi, text, offset)) {
                    offset = bi.preceding(this.start);
                }
                while (offset != -1 && actualCount != requestedCount) {
                    if (requestedCount > 0) {
                        offset = bi.following(offset);
                        while (!this.isWordStart(bi, text, offset)) {
                            offset = bi.next();
                        }
                        ++actualCount;
                        continue;
                    }
                    offset = bi.preceding(offset);
                    while (!this.isWordStart(bi, text, offset)) {
                        offset = bi.previous();
                    }
                    --actualCount;
                }
                if (actualCount == 0) break;
                this.start = offset != -1 ? offset : (requestedCount > 0 ? length : 0);
                offset = bi.following(this.start);
                while (!this.isWordStart(bi, text, offset)) {
                    offset = bi.next();
                }
                this.end = offset != -1 ? offset : length;
                break;
            }
            case 3: {
                int step;
                Integer lineIndex = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, this.start);
                if (lineIndex == null) {
                    return 0;
                }
                int n = step = requestedCount > 0 ? 1 : -1;
                for (actualCount = 0; requestedCount != actualCount && this.getAttribute(AccessibleAttribute.LINE_START, lineIndex + step) != null; actualCount += step) {
                    lineIndex = lineIndex + step;
                }
                if (actualCount == 0) break;
                Integer lineStart = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, lineIndex);
                Integer lineEnd = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, lineIndex);
                if (lineStart == null || lineEnd == null) {
                    return 0;
                }
                this.start = lineStart;
                this.end = lineEnd;
                break;
            }
            case 4: {
                int offset;
                BreakIterator bi = BreakIterator.getSentenceInstance();
                bi.setText(text);
                int n = offset = bi.isBoundary(this.start) ? this.start : bi.preceding(this.start);
                while (offset != -1 && actualCount != requestedCount) {
                    if (requestedCount > 0) {
                        offset = bi.following(offset);
                        ++actualCount;
                        continue;
                    }
                    offset = bi.preceding(offset);
                    --actualCount;
                }
                if (actualCount == 0) break;
                this.start = offset != -1 ? offset : 0;
                offset = bi.following(this.start);
                this.end = offset != -1 ? offset : length;
                break;
            }
            case 5: 
            case 6: {
                return 0;
            }
        }
        this.validateRange(text);
        return actualCount;
    }

    private int MoveEndpointByUnit(int endpoint, int unit, int requestedCount) {
        if (requestedCount == 0) {
            return 0;
        }
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return 0;
        }
        int length = text.length();
        this.validateRange(text);
        int actualCount = 0;
        int offset = endpoint == 0 ? this.start : this.end;
        switch (unit) {
            case 0: {
                int oldOffset = offset;
                offset = Math.max(0, Math.min(offset + requestedCount, length));
                actualCount = offset - oldOffset;
                break;
            }
            case 1: 
            case 2: {
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText(text);
                while (offset != -1 && actualCount != requestedCount) {
                    if (requestedCount > 0) {
                        offset = bi.following(offset);
                        while (!this.isWordStart(bi, text, offset)) {
                            offset = bi.next();
                        }
                        ++actualCount;
                        continue;
                    }
                    offset = bi.preceding(offset);
                    while (!this.isWordStart(bi, text, offset)) {
                        offset = bi.previous();
                    }
                    --actualCount;
                }
                if (offset != -1) break;
                offset = requestedCount > 0 ? length : 0;
                break;
            }
            case 3: {
                Integer lineIndex = (Integer)this.getAttribute(AccessibleAttribute.LINE_FOR_OFFSET, offset);
                Integer lineStart = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, lineIndex);
                Integer lineEnd = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, lineIndex);
                if (lineIndex == null || lineStart == null || lineEnd == null) {
                    offset = requestedCount > 0 ? length : 0;
                    break;
                }
                int step = requestedCount > 0 ? 1 : -1;
                int endOffset = requestedCount > 0 ? lineEnd : lineStart;
                if (offset != endOffset) {
                    actualCount += step;
                }
                while (requestedCount != actualCount && this.getAttribute(AccessibleAttribute.LINE_START, lineIndex + step) != null) {
                    lineIndex = lineIndex + step;
                    actualCount += step;
                }
                if (actualCount == 0) break;
                lineStart = (Integer)this.getAttribute(AccessibleAttribute.LINE_START, lineIndex);
                lineEnd = (Integer)this.getAttribute(AccessibleAttribute.LINE_END, lineIndex);
                if (lineStart == null || lineEnd == null) {
                    return 0;
                }
                offset = requestedCount > 0 ? lineEnd : lineStart;
                break;
            }
            case 4: {
                BreakIterator bi = BreakIterator.getSentenceInstance();
                bi.setText(text);
                while (offset != -1 && actualCount != requestedCount) {
                    if (requestedCount > 0) {
                        offset = bi.following(offset);
                        ++actualCount;
                        continue;
                    }
                    offset = bi.preceding(offset);
                    --actualCount;
                }
                if (offset != -1) break;
                offset = requestedCount > 0 ? length : 0;
                break;
            }
            case 5: 
            case 6: {
                return 0;
            }
        }
        if (endpoint == 0) {
            this.start = offset;
        } else {
            this.end = offset;
        }
        if (this.start > this.end) {
            this.start = this.end = offset;
        }
        this.validateRange(text);
        return actualCount;
    }

    private void MoveEndpointByRange(int endpoint, WinTextRangeProvider targetRange, int targetEndpoint) {
        int offset;
        String text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
        if (text == null) {
            return;
        }
        int length = text.length();
        int n = offset = targetEndpoint == 0 ? targetRange.start : targetRange.end;
        if (endpoint == 0) {
            this.start = offset;
        } else {
            this.end = offset;
        }
        if (this.start > this.end) {
            this.start = this.end = offset;
        }
        this.validateRange(text);
    }

    private void Select() {
        this.accessible.executeAction(AccessibleAction.SET_TEXT_SELECTION, this.start, this.end);
    }

    private void AddToSelection() {
    }

    private void RemoveFromSelection() {
    }

    private void ScrollIntoView(boolean alignToTop) {
        this.accessible.executeAction(AccessibleAction.SHOW_TEXT_RANGE, this.start, this.end);
    }

    private long[] GetChildren() {
        return new long[0];
    }

    static {
        WinTextRangeProvider._initIDs();
        idCount = 1;
    }
}

