/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.glass.ui.Application;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class HostServicesDelegate {
    public static HostServicesDelegate getInstance(javafx.application.Application app) {
        return StandaloneHostService.getInstance(app);
    }

    protected HostServicesDelegate() {
    }

    public abstract String getCodeBase();

    public abstract String getDocumentBase();

    public abstract void showDocument(String var1);

    private static class StandaloneHostService
    extends HostServicesDelegate {
        private static HostServicesDelegate instance = null;
        private Class appClass = null;
        static final String[] browsers = new String[]{"google-chrome", "firefox", "opera", "konqueror", "mozilla"};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HostServicesDelegate getInstance(javafx.application.Application app) {
            Class<StandaloneHostService> clazz = StandaloneHostService.class;
            synchronized (StandaloneHostService.class) {
                if (instance == null) {
                    instance = new StandaloneHostService(app);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private StandaloneHostService(javafx.application.Application app) {
            this.appClass = app.getClass();
        }

        @Override
        public String getCodeBase() {
            String codebase;
            String classUrlString;
            String theClassFile = this.appClass.getName();
            int idx = theClassFile.lastIndexOf(".");
            if (idx >= 0) {
                theClassFile = theClassFile.substring(idx + 1);
            }
            if (!(classUrlString = this.appClass.getResource(theClassFile = theClassFile + ".class").toString()).startsWith("jar:file:") || classUrlString.indexOf("!") == -1) {
                return "";
            }
            String urlString = classUrlString.substring(4, classUrlString.lastIndexOf("!"));
            File jarFile = null;
            try {
                jarFile = new File(new URI(urlString).getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jarFile != null && (codebase = jarFile.getParent()) != null) {
                return this.toURIString(codebase);
            }
            return "";
        }

        private String toURIString(String filePath) {
            try {
                return new File(filePath).toURI().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        @Override
        public String getDocumentBase() {
            return this.toURIString(System.getProperty("user.dir"));
        }

        @Override
        public void showDocument(String uri) {
            URI link = null;
            try {
                link = new URI(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (link == null || link.getScheme() == null) {
                File file = new File(uri);
                if (file.exists()) {
                    link = file.toURI();
                } else {
                    System.err.println("ERROR: unable to open: " + uri);
                    return;
                }
            }
            Application.GetApplication().showDocument(link.toString());
        }
    }
}

