/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.CompoundTexture;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.PixelFormat;

final class WCImageImpl
extends PrismImage {
    private static final Logger log = Logger.getLogger(WCImageImpl.class.getName());
    private final Image img;
    private Texture texture;
    private CompoundTexture compoundTexture;

    WCImageImpl(int w, int h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating empty image({0},{1})", new Object[]{w, h});
        }
        this.img = Image.fromIntArgbPreData(new int[w * h], w, h);
    }

    WCImageImpl(int[] buffer, int w, int h) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image({0},{1}) from buffer", new Object[]{w, h});
        }
        this.img = Image.fromIntArgbPreData(buffer, w, h);
    }

    WCImageImpl(ImageFrame frame) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating image {0}x{1} of type {2} from buffer", new Object[]{frame.getWidth(), frame.getHeight(), frame.getImageType()});
        }
        this.img = Image.convertImageFrame(frame);
    }

    @Override
    Image getImage() {
        return this.img;
    }

    @Override
    Graphics getGraphics() {
        return null;
    }

    @Override
    void draw(Graphics g, int dstx1, int dsty1, int dstx2, int dsty2, int srcx1, int srcy1, int srcx2, int srcy2) {
        ResourceFactory resourceFactory = g.getResourceFactory();
        if (resourceFactory.isDisposed()) {
            log.fine("WCImageImpl::draw : skip because device disposed or not ready");
            return;
        }
        if (g instanceof PrinterGraphics) {
            Texture t = resourceFactory.createTexture(this.img, Texture.Usage.STATIC, Texture.WrapMode.CLAMP_NOT_NEEDED);
            g.drawTexture(t, dstx1, dsty1, dstx2, dsty2, srcx1, srcy1, srcx2, srcy2);
            t.dispose();
            return;
        }
        if (this.texture != null) {
            this.texture.lock();
            if (this.texture.isSurfaceLost()) {
                this.texture = null;
            }
        }
        if (this.texture == null && this.compoundTexture == null) {
            int maxSize = resourceFactory.getMaximumTextureSize();
            if (this.img.getWidth() <= maxSize && this.img.getHeight() <= maxSize) {
                this.texture = resourceFactory.createTexture(this.img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
                assert (this.texture != null);
            } else {
                this.compoundTexture = new CompoundTexture(this.img, maxSize);
            }
        }
        if (this.texture != null) {
            assert (this.compoundTexture == null);
            g.drawTexture(this.texture, dstx1, dsty1, dstx2, dsty2, srcx1, srcy1, srcx2, srcy2);
            this.texture.unlock();
        } else {
            assert (this.compoundTexture != null);
            ViewPort viewPort = new ViewPort(srcx1, srcy1, srcx2 - srcx1, srcy2 - srcy1);
            Coords coords = new Coords(dstx2 - dstx1, dsty2 - dsty1, viewPort);
            CompoundCoords compoundCoords = new CompoundCoords(this.compoundTexture, coords);
            compoundCoords.draw(g, this.compoundTexture, dstx1, dsty1);
        }
    }

    @Override
    void dispose() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
        if (this.compoundTexture != null) {
            this.compoundTexture.dispose();
            this.compoundTexture = null;
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        int w = this.img.getWidth();
        int h = this.img.getHeight();
        int s = w * 4;
        ByteBuffer pixels = ByteBuffer.allocate(s * h);
        this.img.getPixels(0, 0, w, h, PixelFormat.getByteBgraInstance(), pixels, s);
        return pixels;
    }

    @Override
    public float getPixelScale() {
        return this.img.getPixelScale();
    }
}

