/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.configwithorigins;

import com.oracle.svm.agent.configwithorigins.ClassInfo;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class MethodInfoRecordKeeper {
    private final boolean shouldTrackMethodInfo;
    private final Map<Long, MethodInfo> jMethodIdToMethodInfoMap = new ConcurrentHashMap<Long, MethodInfo>();
    private final Map<String, ClassInfo> classSignatureToClassInfoMap = new ConcurrentHashMap<String, ClassInfo>();

    public MethodInfoRecordKeeper(boolean shouldTrackMethodInfo) {
        this.shouldTrackMethodInfo = shouldTrackMethodInfo;
    }

    public MethodInfo[] getStackTraceInfo(JNIMethodId[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        try {
            MethodInfo[] methodInfoTrace = new MethodInfo[stackTrace.length];
            for (int i = 0; i < stackTrace.length; ++i) {
                methodInfoTrace[i] = this.getMethodInfo(stackTrace[i].rawValue());
            }
            return methodInfoTrace;
        }
        catch (Support.WrongPhaseException e) {
            return null;
        }
    }

    private MethodInfo getMethodInfo(long rawJMethodIdValue) throws Support.WrongPhaseException {
        assert (this.shouldTrackMethodInfo);
        if (this.jMethodIdToMethodInfoMap.containsKey(rawJMethodIdValue)) {
            return this.jMethodIdToMethodInfoMap.get(rawJMethodIdValue);
        }
        return this.findOrCreateMethodInfo(rawJMethodIdValue);
    }

    private MethodInfo findOrCreateMethodInfo(long rawJMethodIdValue) throws Support.WrongPhaseException {
        String declaringClassSignature = MethodInfoRecordKeeper.getMethodDeclaringClassSignature(rawJMethodIdValue);
        ClassInfo classInfo = this.findOrCreateClassInfo(declaringClassSignature);
        MethodInfo methodInfo = classInfo.findOrCreateMethodInfo(rawJMethodIdValue);
        this.jMethodIdToMethodInfoMap.putIfAbsent(rawJMethodIdValue, methodInfo);
        return methodInfo;
    }

    static String getJavaStringAndFreeNativeString(CCharPointer nativeString) {
        String javaString = Support.fromCString((CCharPointer)nativeString);
        Support.jvmtiFunctions().Deallocate().invoke(Support.jvmtiEnv(), (PointerBase)nativeString);
        return javaString;
    }

    private static String getMethodDeclaringClassSignature(long rawJMethodIdValue) throws Support.WrongPhaseException {
        JNIMethodId jMethodId = (JNIMethodId)WordFactory.pointer((long)rawJMethodIdValue);
        JNIObjectHandle declaringClass = Support.getMethodDeclaringClass((JNIMethodId)jMethodId);
        CCharPointerPointer signaturePointer = (CCharPointerPointer)StackValue.get(CCharPointerPointer.class);
        Support.checkPhase((JvmtiError)Support.jvmtiFunctions().GetClassSignature().invoke(Support.jvmtiEnv(), declaringClass, signaturePointer, (CCharPointerPointer)WordFactory.nullPointer()));
        return MethodInfoRecordKeeper.getJavaStringAndFreeNativeString(signaturePointer.read());
    }

    private ClassInfo findOrCreateClassInfo(String classSignature) {
        this.classSignatureToClassInfoMap.computeIfAbsent(classSignature, ClassInfo::new);
        return this.classSignatureToClassInfoMap.get(classSignature);
    }
}

